/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.demo.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

class PaintPanel
extends JPanel {
    private int squareX = 50;
    private int squareY = 50;
    private int squareW = 20;
    private int squareH = 20;

    public PaintPanel() {
        this.setBorder(BorderFactory.createLineBorder(Color.black));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                PaintPanel.this.moveSquare(e.getX(), e.getY());
            }
        });
        this.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                PaintPanel.this.moveSquare(e.getX(), e.getY());
            }
        });
    }

    private void moveSquare(int x, int y) {
        int OFFSET = 1;
        if (this.squareX != x || this.squareY != y) {
            this.repaint(this.squareX, this.squareY, this.squareW + OFFSET, this.squareH + OFFSET);
            this.squareX = x;
            this.squareY = y;
            this.repaint(this.squareX, this.squareY, this.squareW + OFFSET, this.squareH + OFFSET);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        System.out.println("Panel reports pref size ");
        return new Dimension(250, 200);
    }

    @Override
    protected void paintComponent(Graphics g) {
        System.out.println("Panel.paintComponent");
        super.paintComponent(g);
        g.drawString("This is a custom Panel!", 10, 20);
        g.setColor(Color.RED);
        g.fillRect(this.squareX, this.squareY, this.squareW, this.squareH);
        g.setColor(Color.BLACK);
        g.drawRect(this.squareX, this.squareY, this.squareW, this.squareH);
    }
}

