/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.annotations.processing;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.StandardLocation;
import org.lsst.ccs.gconsole.annotations.ConsoleLookup;

@SupportedAnnotationTypes(value={"org.lsst.ccs.gconsole.annotations.ConsoleLookup"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class LookupGenerator
extends AbstractProcessor {
    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        ArrayList<String> data = new ArrayList<String>();
        for (Element element : roundEnv.getElementsAnnotatedWith(ConsoleLookup.class)) {
            ConsoleLookup ann;
            String id;
            if (element.getKind() != ElementKind.CLASS || element.getEnclosingElement().getKind() != ElementKind.PACKAGE || (id = (ann = element.getAnnotation(ConsoleLookup.class)).id()).isEmpty()) continue;
            String className = element.asType().toString();
            data.add(id + "=" + className);
        }
        if (!data.isEmpty()) {
            try (OutputStream os = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", "gui/lookup.txt", new Element[0]).openOutputStream();
                 PrintWriter printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(os)));){
                data.forEach(s -> out.println((String)s));
            }
            catch (IOException x) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Error writing gui/lookup.txt: " + x);
            }
        }
        return true;
    }
}

