/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.function;

import hep.aida.IAnnotation;
import hep.aida.IFunction;
import hep.aida.ref.Annotation;
import hep.aida.ref.function.FunctionCore;

public class IFunctionCoreNotNorm
extends FunctionCore {
    protected boolean providesNormalization;
    private IFunction function;

    public IFunctionCoreNotNorm(IFunction func) {
        super(func.dimension(), func.numberOfParameters(), null);
        this.function = func;
        this.initIFunctionCore();
    }

    public IFunctionCoreNotNorm(IFunction func, double[] pVal) {
        super(func.dimension(), func.numberOfParameters(), pVal);
        this.function = func;
        this.initIFunctionCore();
    }

    private void initIFunctionCore() {
        String tit = null;
        try {
            IAnnotation an = this.function.annotation();
            if (an != null) {
                tit = an.value(Annotation.titleKey);
            }
        }
        catch (IllegalArgumentException an) {
            // empty catch block
        }
        if (tit != null && !tit.equals("")) {
            this.setTitle(tit);
        }
        this.providesNormalization = false;
        String[] names = this.function.parameterNames();
        this.setParameterNames(names);
    }

    @Override
    public double functionValue(double[] var) {
        return this.function.value(var);
    }

    @Override
    public boolean providesGradient() {
        return this.function.providesGradient();
    }

    @Override
    public double[] gradient(double[] var) {
        return this.function.gradient(var);
    }

    @Override
    public boolean providesParameterGradient() {
        if (this.function instanceof FunctionCore) {
            return ((FunctionCore)this.function).providesParameterGradient();
        }
        return false;
    }

    @Override
    public double[] parameterGradient(double[] var) {
        throw new UnsupportedOperationException(this.title() + "IFunctionCore does not provide parameter gradient");
    }

    @Override
    public boolean providesNormalization() {
        return this.providesNormalization;
    }

    @Override
    public double normalizationAmplitude(double[] xMin, double[] xMax) {
        throw new UnsupportedOperationException(this.title() + " *****  Can not calculate normalization for a not normalized function");
    }

    @Override
    public double[] parameters() {
        return this.function.parameters();
    }

    @Override
    public double parameter(String name) {
        return this.function.parameters()[this.indexOfParameter(name)];
    }

    @Override
    public void setParameters(double[] params) {
        this.function.setParameters(params);
    }

    @Override
    public void setParameter(String name, double x) throws IllegalArgumentException {
        String fName = this.function.parameterNames()[this.indexOfParameter(name)];
        this.function.setParameter(fName, x);
    }
}

