/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb.trendServer;

import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetSocketAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.core.Application;
import javax.ws.rs.ext.RuntimeDelegate;
import org.lsst.ccs.localdb.statusdb.server.DataServer;
import org.lsst.ccs.localdb.statusdb.server.DebugExceptionMapper;
import org.lsst.ccs.messaging.NetworkUtilities;

public class RestServer {
    private HttpServer s;
    private static int port = 8080;
    private static String host = null;
    private final String restRoot = "/rest/data";

    RestServer() {
    }

    public RestServer(int port) {
        RestServer.port = port;
    }

    public void start() {
        class MyApplication
        extends Application {
            MyApplication() {
            }

            public Set<Class<?>> getClasses() {
                HashSet s = new HashSet();
                s.add(DataServer.class);
                s.add(DebugExceptionMapper.class);
                return s;
            }
        }
        MyApplication app = new MyApplication();
        HttpHandler h = (HttpHandler)RuntimeDelegate.getInstance().createEndpoint((Application)app, HttpHandler.class);
        try {
            this.s = HttpServer.create(new InetSocketAddress(port), 5);
        }
        catch (IOException ex) {
            throw new RuntimeException("could not create http server", ex);
        }
        this.s.createContext("/rest/data", h);
        this.s.start();
    }

    public void stop() {
        this.s.stop(1);
    }

    public static int getRestServerPort() {
        return port;
    }

    public static String getRestServerHost() {
        if (host == null) {
            try {
                NetworkInterface ne = NetworkInterface.getByName(NetworkUtilities.getMainInterfaceName());
                for (InterfaceAddress ia : ne.getInterfaceAddresses()) {
                    boolean isIPV6 = ia.getAddress() instanceof Inet6Address;
                    if (isIPV6) continue;
                    host = ia.getAddress().getHostAddress();
                    break;
                }
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
        return host;
    }

    public static void main(String[] args) {
        System.out.println(RestServer.getRestServerHost());
    }
}

