/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import org.lsst.ccs.Agent;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.ComponentConfigurationEnvironment;
import org.lsst.ccs.ConfigurationDAOWrapper;
import org.lsst.ccs.ConfigurationListener;
import org.lsst.ccs.ServiceLifecycle;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bootstrap.SubstitutionTokenUtils;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.ConfigurationData;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.ConfigurationParameterInfo;
import org.lsst.ccs.bus.data.ConfigurationParameterType;
import org.lsst.ccs.bus.data.DataProviderDictionary;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.bus.definition.Bus;
import org.lsst.ccs.bus.messages.BusMessage;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.StatusConfigurationData;
import org.lsst.ccs.bus.messages.StatusConfigurationInfo;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.states.AgentState;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.bus.states.ConfigurationState;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.bus.states.StateBundle;
import org.lsst.ccs.command.Options;
import org.lsst.ccs.command.SupportedOption;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.command.annotations.Option;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.config.BulkSettingException;
import org.lsst.ccs.config.CategoryDataChain;
import org.lsst.ccs.config.CategoryDescription;
import org.lsst.ccs.config.CategoryHandler;
import org.lsst.ccs.config.ConfigurationDescription;
import org.lsst.ccs.config.ConfigurationHandler;
import org.lsst.ccs.config.ConfigurationHandlerSet;
import org.lsst.ccs.config.ConfigurationLoadedData;
import org.lsst.ccs.config.ConfigurationParameterHandler;
import org.lsst.ccs.config.ConfigurationParameterTaggedValue;
import org.lsst.ccs.config.ConfigurationServiceException;
import org.lsst.ccs.config.ConfigurationView;
import org.lsst.ccs.config.SingleCategoryTag;
import org.lsst.ccs.config.SingleCategoryTagData;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.description.ComponentNode;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.framework.TreeWalkerUtils;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.BusMessagePreProcessor;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.services.AgentCommandDictionaryService;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.services.AgentService;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.DataProviderDictionaryService;
import org.lsst.ccs.services.HasDataProviderInfos;
import org.lsst.ccs.services.MessagingService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.utilities.conv.TypeUtils;
import org.lsst.ccs.utilities.structs.ParameterPath;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public final class ConfigurationService
implements ServiceLifecycle,
AgentPresenceListener,
AgentService,
HasDataProviderInfos,
HasLifecycle,
BusMessagePreProcessor,
DataProviderDictionaryService.DataProviderDictionaryListener {
    private static final Logger conf_sub_log = Logger.getLogger(ConfigurationService.class.getName());
    private static final Alert CS_ALERT_1 = new Alert("CCSCFGSRV", "configuration service unavailable");
    private static final Alert CS_ALERT_2 = new Alert("CCSCFGOP", "operator error");
    private static final Alert ConfigInfoMismatch = new Alert("ConfigInfoMismatch", "Reconstructed ConfigurationInfo mismatch!");
    private ConfigurationDAOWrapper configurationDao;
    private final Set<String> categories = new HashSet<String>();
    private final Map<String, ComponentConfigurationEnvironment> keyEnvironmentMap = new HashMap<String, ComponentConfigurationEnvironment>();
    private String descriptionName;
    private String agentName;
    private ConfigurationView groovyView = null;
    private boolean saveInitialConfiguration = false;
    private volatile boolean buildClientConfigurationInfo = false;
    private boolean migrateConfigurationFiles = false;
    private String printConfigurationParameters = null;
    @LookupField(strategy=LookupField.Strategy.TOP)
    protected Agent agent;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentStateService stateService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private DataProviderDictionaryService dataDictionaryService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPropertiesService agentPropertiesService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentCommandDictionaryService agentCommandDictionaryService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private MessagingService messagingService;
    private final ReadWriteLock configLock = new ReentrantReadWriteLock();
    private ConcurrentMessagingUtils cmu;
    private boolean discontinuePublicationForConsoles = false;
    private ConfigurationInfo currentConfigInfo;
    private ConfigurationHandlerSet configurationHandler;
    private ConfigurationView currentView;
    private ConfigurationDescription defaultInitialDescription = null;
    private ConfigurationDescription currentDescription = null;
    private ConfigurationDescription baseDescription = null;
    private ConfigurationView initialView;
    private boolean canGoToConfigured = false;
    private final boolean testContext = System.getProperty("org.lsst.ccs.testcontext", "false").equals("true");
    private final List<ConfigurationListener> configurationListeners = new CopyOnWriteArrayList<ConfigurationListener>();
    private volatile boolean fullConfigurationNeedsUpdating = true;
    private volatile byte[] zippedFullConfigurationData = null;
    private String userProvidedConfiguration = null;
    private final SupportedOption dirtyOption = SupportedOption.getSupportedOption((String)"dirtyOnly");
    private final SupportedOption originTagOption = SupportedOption.getSupportedOption((String)"originTag");
    private final SupportedOption fullConfigurationOption = SupportedOption.getSupportedOption((String)"full");
    private final SupportedOption testRunOption = SupportedOption.getSupportedOption((String)"testRun");
    private final SupportedOption initialSaveOption = SupportedOption.getSupportedOption((String)"initialSave");
    private final SupportedOption allCategoriesOption = SupportedOption.getSupportedOption((String)"allCategories");
    private final SupportedOption dropChangesOption = SupportedOption.getSupportedOption((String)"dropChanges");
    private final SupportedOption initialOption = SupportedOption.getSupportedOption((String)"initial");
    private final SupportedOption baseOption = SupportedOption.getSupportedOption((String)"base");
    private final SupportedOption doNotPublishOption = SupportedOption.getSupportedOption((String)"doNotPublish");
    private ConfigurationLoadedData persistedData = new ConfigurationLoadedData();
    private final List<String> configurableComponentsForCommands = new ArrayList<String>();
    private final Map<String, ConfigurationInfo> staticConfigurationInfoMap = new ConcurrentHashMap<String, ConfigurationInfo>();
    private final Object messageProcessing = new Object();
    private final Map<String, String> defaultCategorySources = new ConcurrentHashMap<String, String>();

    @Override
    public String getAgentServiceName() {
        return "configurationService";
    }

    public static Properties getBuildProperties(String descriptionName, String initialConfig) {
        try (ConfigurationDAOWrapper configurationProxy = new ConfigurationDAOWrapper(descriptionName);){
            Properties properties = ConfigurationService.getBuildProperties(configurationProxy, initialConfig);
            return properties;
        }
    }

    private static Properties getBuildProperties(ConfigurationDAOWrapper dao, String initialConfig) {
        ConfigurationDescription inputDescription = new ConfigurationDescription(Collections.singleton("build")).withDefaultInitial(true);
        if ((initialConfig = SubstitutionTokenUtils.resolveSubstitutionTokens((String)initialConfig)) != null) {
            inputDescription.parseConfigurationString(initialConfig.split(","));
        }
        Properties res = new Properties();
        Properties inputProperties = BootUtils.getInputBuildProperties();
        if (inputProperties != null) {
            res = inputProperties;
        }
        for (SingleCategoryTag tag : inputDescription.getCategoryTag("build").getSingleCategoryTags()) {
            res.putAll((Map<?, ?>)dao.getConfigurationProperties(tag));
        }
        return res;
    }

    public Properties getBuildProperties() {
        return ConfigurationService.getBuildProperties(this.configurationDao, this.userProvidedConfiguration);
    }

    @Override
    public void shutdown() {
        if (this.configurationDao != null) {
            this.configurationDao.close();
        }
    }

    @Override
    public void preBuild() {
        Properties bootProps = BootstrapResourceUtils.getBootstrapSystemProperties();
        if (!bootProps.getOrDefault((Object)"org.lsst.ccs.config.remote", "false").equals("false")) {
            this.agentPropertiesService.setAgentProperty("org.lsst.ccs.config.remote", bootProps.getProperty("org.lsst.ccs.config.remote"));
        }
        if (this.agent.getAgentInfo().isGraphicalConsole() || this.agent.getAgentInfo().getType().compareTo((Enum)AgentInfo.AgentType.SERVICE) >= 0) {
            this.buildClientConfigurationInfo = true;
        }
        this.userProvidedConfiguration = (String)this.agent.getComponentLookup().getTopComponentNode().getTag("startupConfig");
        if (this.userProvidedConfiguration != null && this.userProvidedConfiguration.isEmpty()) {
            this.userProvidedConfiguration = null;
            conf_sub_log.log(Level.WARNING, "The empty String is no longer supported as a valid input for the --initialConfiguration option.\nPlease remove it or provide an explicit category tag to load.");
        }
        String migrateConfigurationFilesStr = (String)this.agent.getComponentLookup().getTopComponentNode().getTag("migrateConfigurationFiles");
        this.migrateConfigurationFiles = "true".equals(migrateConfigurationFilesStr);
        String saveInitialConfigurationStr = (String)this.agent.getComponentLookup().getTopComponentNode().getTag("saveInitialConfiguration");
        this.saveInitialConfiguration = "true".equals(saveInitialConfigurationStr);
        this.printConfigurationParameters = (String)this.agent.getComponentLookup().getTopComponentNode().getTag("printConfigurationParameters");
        ComponentLookup lookup = this.agent.getComponentLookup();
        ComponentNode configServiceNode = lookup.getComponentNodeForObject((Object)this);
        this.descriptionName = this.agent.getDescription();
        this.agentName = this.agent.getName();
        this.configurationDao = new ConfigurationDAOWrapper(this.descriptionName, this);
        lookup.addComponentNodeToLookup(configServiceNode, new ComponentNode("configurationDAO", (Object)this.configurationDao));
        this.currentView = this.initialView = this.scanTreeAndBuildInitialView(true);
        ConfigurationView userProvided = this.buildUserProvidedConfigurationView(true);
        this.initialView.putAll(userProvided);
        if (this.hasBuildParameters()) {
            this.currentConfigInfo = this.configurationHandler.initialize(this.descriptionName, userProvided, this.agentName, true, true);
            this.updateStateAndSendStatusConfigurationInfo(this.currentConfigInfo, ConfigurationListener.ConfigurationOperation.LOAD, false);
        }
    }

    private ConfigurationView buildUserProvidedConfigurationView(boolean isBuild) {
        String[] providedConfs;
        this.categories.clear();
        this.categories.addAll(this.configurationHandler.getCategorySet());
        this.defaultInitialDescription = new ConfigurationDescription(this.categories).withDefaultInitial(true);
        if (this.userProvidedConfiguration != null) {
            this.defaultInitialDescription.parseConfigurationString(this.userProvidedConfiguration.split(","));
        }
        ConfigurationView userProvidedConfigurationView = this.groovyView != null ? this.groovyView : new ConfigurationView();
        Set<Object> categoriesToLoad = new HashSet();
        ConfigurationDescription startupDescription = null;
        String[] stringArray = providedConfs = this.userProvidedConfiguration != null ? this.userProvidedConfiguration.split(",") : new String[]{};
        if (isBuild) {
            if (this.hasBuildParameters()) {
                categoriesToLoad.add("build");
                startupDescription = new ConfigurationDescription(categoriesToLoad).withDefaultInitial(true);
                for (String conf : providedConfs) {
                    if (!conf.contains("build")) continue;
                    startupDescription = startupDescription.parseConfigurationString(new String[]{conf});
                }
            }
        } else {
            categoriesToLoad = this.categories;
            if (this.agent.getAgentInfo().getType().compareTo((Enum)AgentInfo.AgentType.WORKER) >= 0) {
                startupDescription = new ConfigurationDescription(categoriesToLoad);
                for (String conf : providedConfs) {
                    if (conf.contains("build") && !this.hasBuildParameters()) continue;
                    startupDescription = startupDescription.parseConfigurationString(new String[]{conf});
                }
                startupDescription = startupDescription.withDefaultInitial(true);
            }
        }
        ConfigurationDescription loadedDescription = this.defaultInitialDescription.cloneForCategories(this.categories);
        if (startupDescription != null) {
            this.defaultInitialDescription = startupDescription.cloneForCategories(this.categories);
            ConfigurationLoadedData lastLoad = this.configurationDao.initialLoadConfiguration(startupDescription, !this.saveInitialConfiguration);
            ConfigurationView additionalUserProvidedConfigurationView = lastLoad.getConfigurationView(this.configurationHandler.getDataChainProcessorsMap());
            this.persistedData.putConfigurationLoadedData(lastLoad);
            userProvidedConfigurationView.putAll(additionalUserProvidedConfigurationView);
            loadedDescription = userProvidedConfigurationView.getConfigurationDescription();
        }
        this.currentDescription = new ConfigurationDescription().merge(this.defaultInitialDescription);
        ConfigurationDescription userProvidedDesc = userProvidedConfigurationView.getConfigurationDescription();
        if (userProvidedDesc != null) {
            this.currentDescription = this.currentDescription.merge(userProvidedDesc);
        }
        userProvidedConfigurationView.setConfigurationDescription(this.currentDescription);
        return userProvidedConfigurationView;
    }

    @Override
    public void preInit() {
        this.discontinuePublicationForConsoles = BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.config.discontinue.publication.consoles", "false").equals("true");
        ClearAlertHandler configurationServiceClearAlertHadler = new ClearAlertHandler(){

            @Override
            public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState alertState) {
                if (CS_ALERT_1.getAlertId().equals(alert.getAlertId())) {
                    return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
                }
                if (CS_ALERT_2.getAlertId().equals(alert.getAlertId())) {
                    return ConfigurationService.this.stateService.isInState((Enum)ConfigurationState.CONFIGURED) ? ClearAlertHandler.ClearAlertCode.CLEAR_ALERT : ClearAlertHandler.ClearAlertCode.DONT_CLEAR_ALERT;
                }
                if (ConfigInfoMismatch.getAlertId().equals(alert.getAlertId())) {
                    return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
                }
                return ClearAlertHandler.ClearAlertCode.UNKNOWN_ALERT;
            }
        };
        this.alertService.registerAlert(CS_ALERT_1, configurationServiceClearAlertHadler);
        this.alertService.registerAlert(CS_ALERT_2, configurationServiceClearAlertHadler);
        this.alertService.registerAlert(ConfigInfoMismatch, configurationServiceClearAlertHadler);
        this.currentView = this.initialView = this.scanTreeAndBuildInitialView(false);
        ConfigurationView userProvided = this.buildUserProvidedConfigurationView(false);
        this.initialView.putAll(userProvided);
        this.currentConfigInfo = this.configurationHandler.initialize(this.descriptionName, userProvided, this.agentName, false, true);
        this.updateStateAndSendStatusConfigurationInfo(this.currentConfigInfo, ConfigurationListener.ConfigurationOperation.LOAD);
        if (this.saveInitialConfiguration) {
            Options opts = new Options().withOption("initialSave");
            this.saveChanges(opts);
            System.exit(0);
        }
        if (this.migrateConfigurationFiles) {
            this.configurationDao.close();
            System.exit(0);
        }
        if (this.printConfigurationParameters != null) {
            Properties buildProps;
            String[] cats;
            HashSet<String> printCats = new HashSet<String>();
            if (!this.printConfigurationParameters.isEmpty() && (cats = this.printConfigurationParameters.split(",")).length > 0) {
                for (String c : cats) {
                    if (this.categories.contains(c = c.trim())) {
                        printCats.add(c);
                        continue;
                    }
                    System.out.println("Invalid category " + c + ". Allowed values are " + this.categories);
                }
            }
            if (printCats.isEmpty()) {
                printCats.addAll(this.categories);
            }
            if (!(buildProps = this.getBuildProperties()).isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (Object prop : buildProps.keySet()) {
                    try {
                        ParameterPath path = ParameterPath.valueOf((String)((String)prop));
                        try {
                            if (this.getParameterByPath(path).isBuild()) {
                                continue;
                            }
                        }
                        catch (Exception exception) {
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    sb.append(prop).append(" = ").append(buildProps.getProperty((String)prop)).append("\n");
                }
                if (!sb.toString().isEmpty()) {
                    System.out.println("\nBuild Properties: \n" + sb.toString());
                }
            }
            String[] toPrint = new String[printCats.size()];
            toPrint = printCats.toArray(toPrint);
            System.out.println();
            System.out.println(this.printConfigurationParameters(new Options(), toPrint));
            System.exit(0);
        }
    }

    @Override
    public void postInit() {
        if (this.dataDictionaryService != null) {
            this.dataDictionaryService.addDataProviderDictionaryListener(this);
        }
    }

    ConfigurationView getCurrentConfigurationView() {
        try (ConfigurationLock rlock = this.acquireConfigurationLock();){
            ConfigurationView configurationView = new ConfigurationView(this.currentView);
            return configurationView;
        }
    }

    private boolean hasBuildParameters() {
        try (ConfigurationLock rlock = this.acquireConfigurationLock();){
            for (String category : this.categories) {
                CategoryHandler categoryHandler = this.configurationHandler.getCategoryHandler(category);
                for (ConfigurationParameterHandler cph : categoryHandler.getParameters()) {
                    if (!cph.isBuild()) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
    }

    private ConfigurationView scanTreeAndBuildInitialView(boolean isBuild) {
        boolean checkConfigViews = this.agent.getAgentInfo().getType().compareTo((Enum)AgentInfo.AgentType.WORKER) >= 0;
        boolean failOnViewProblems = checkConfigViews && !this.saveInitialConfiguration;
        this.configurationHandler = new ConfigurationHandlerSet(checkConfigViews, failOnViewProblems);
        ComponentLookup lookup = this.agent.getComponentLookup();
        ComponentNode topNode = lookup.getTopComponentNode();
        TreeWalkerUtils.proceduralNodeWalk(lookup, null, n -> {
            Object component;
            String nodeName = n.getPath();
            ConfigurationHandler ch = this.configurationHandler.addConfigurationHandlerForObject(nodeName, component = n.getComponent());
            if (ch != null && !isBuild && ch.hasRuntimeParameters()) {
                ComponentConfigurationEnvironment cce = new ComponentConfigurationEnvironment(nodeName, this);
                this.keyEnvironmentMap.put(nodeName, cce);
                this.agentCommandDictionaryService.addCommandSetToObject(cce, n.getPath());
            }
        }, null);
        ConfigurationView initialView = new ConfigurationView();
        initialView.putAll(this.configurationHandler.getLiveConfigurationView());
        if (this.groovyView == null) {
            this.groovyView = new ConfigurationView();
            String agentPrefix = this.agent.getName() + "/";
            Map topNodeTags = topNode.getTags();
            for (Map.Entry entry : topNodeTags.entrySet()) {
                if (!(entry.getKey() instanceof String)) continue;
                try {
                    ParameterPath path;
                    Object nodeObj;
                    String value = TypeUtils.stringify(entry.getValue());
                    String parPath = (String)entry.getKey();
                    if (parPath.startsWith(agentPrefix) && !(parPath = parPath.replace(agentPrefix, "")).contains("/")) {
                        parPath = "/" + parPath;
                    }
                    if ((nodeObj = lookup.getComponentByPath((path = ParameterPath.valueOf((String)parPath)).getComponentName())) == null) continue;
                    String componentPath = lookup.getComponentNodeForObject(nodeObj).getPath();
                    if (this.isParameterConfigurable(componentPath, (path = new ParameterPath(componentPath, path.getParameterName())).getParameterName())) {
                        this.groovyView.putParameterValue(path.toString(), value);
                        continue;
                    }
                    throw new RuntimeException("Not configurable " + path + " " + parPath);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
            }
        }
        initialView.putAll(this.groovyView);
        return initialView;
    }

    @Override
    public void preStart() {
        this.canGoToConfigured = true;
        if (this.currentConfigInfo.getConfigurationState() != ConfigurationState.CONFIGURED) {
            this.currentConfigInfo.setConfigurationState(ConfigurationState.CONFIGURED);
            try (ConfigurationWriteLock wlock = this.acquireConfigurationWriteLock();){
                this.updateStateAndSendStatusConfigurationInfo(this.currentConfigInfo, ConfigurationListener.ConfigurationOperation.LOAD);
            }
        }
        this.messagingService.getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)this);
        this.cmu = new ConcurrentMessagingUtils(this.agent.getMessagingAccess());
    }

    @Override
    public List<DataProviderInfo> getDataProviderInfos() {
        List dataList = this.configurationHandler.getDataPoviderInfoList();
        return dataList;
    }

    @Override
    public void publishDataProviderCurrentData(AgentInfo ... agents) {
        for (AgentInfo ai : agents) {
            if (this.discontinuePublicationForConsoles && ai.isGraphicalConsole()) continue;
            this.publishConfigurationInfo();
            return;
        }
    }

    @Command(category=Command.CommandCategory.CORE, type=Command.CommandType.QUERY, level=0)
    public String getConfigurationParameterValue(@Argument(allowedValueProvider="getAllConfigurableComponentsWithTrailingSlash") String componentName, String parameterName) {
        componentName = this.manipulateInputComponentName(componentName);
        ConfigurationView view = this.configurationHandler.getLiveConfigurationView();
        Map values = view.getValuesForComponent(componentName);
        if (!values.containsKey(parameterName)) {
            throw new IllegalArgumentException("Parameter " + parameterName + " does not exist for component " + componentName);
        }
        return (String)view.getValuesForComponent(componentName).get(parameterName);
    }

    private String manipulateInputComponentName(String componentName) {
        if (componentName != null) {
            if (componentName.startsWith("/")) {
                componentName = componentName.substring(1);
            }
            if (!this.getAllConfigurableComponents().contains(componentName)) {
                throw new IllegalArgumentException("Component " + componentName + " does not exist.");
            }
        }
        return componentName;
    }

    @Command(category=Command.CommandCategory.CORE, type=Command.CommandType.QUERY, level=0)
    @Option.List(value={@Option(name="dirtyOnly", description="Only print information about dirty configuration parameters"), @Option(name="originTag", description="Show in which tag the parameter is defined")})
    public String printConfigurationParameters(Options options, String ... categories) {
        return this.printConfigParameters(options, null, categories);
    }

    public String printConfigurationParameters(String ... categories) {
        return this.printConfigurationParameters(new Options(), categories);
    }

    @Command(description="displays the current values of the parameters that belong to the given categories for the provided component", type=Command.CommandType.QUERY, category=Command.CommandCategory.CORE, level=0)
    @Option.List(value={@Option(name="dirtyOnly", description="Only print information about dirty configuration parameters"), @Option(name="originTag", description="Show in which tag the parameter is defined")})
    public String printConfigurationParametersForComponent(Options options, @Argument(allowedValueProvider="getAllConfigurableComponentsWithTrailingSlash") String component, String ... categories) {
        return this.printConfigParameters(options, component, categories);
    }

    String printConfigParameters(Options options, String component, String ... inputCategories) {
        component = this.manipulateInputComponentName(component);
        this.verifyInputCategories(inputCategories);
        StringBuilder sb = new StringBuilder();
        HashSet<String> cats = new HashSet<String>();
        if (inputCategories != null) {
            cats.addAll(Arrays.asList(inputCategories));
        }
        boolean dirtyOnly = options.hasOption(this.dirtyOption);
        boolean originTag = options.hasOption(this.originTagOption);
        Set<String> categorySet = this.getCategories();
        try (ConfigurationLock rlock = this.acquireConfigurationLock();){
            ConfigurationView view = this.configurationHandler.getLiveConfigurationView();
            for (String category : categorySet) {
                if (!cats.isEmpty() && !cats.contains(category)) continue;
                boolean printCategory = true;
                CategoryHandler catHandler = this.configurationHandler.getCategoryHandler(category);
                for (ConfigurationParameterHandler par : catHandler.getParameters()) {
                    ConfigurationParameterTaggedValue tg;
                    ParameterPath path = par.getParameterPath();
                    if (component != null && !path.getComponentName().equals(component)) continue;
                    ConfigurationParameterInfo cpi = this.getConfigurationInfo().getCurrentParameterInfo(path.toString());
                    if (dirtyOnly && !cpi.isDirty()) continue;
                    if (printCategory) {
                        sb.append("Category : ").append(category).append("\n");
                        printCategory = false;
                    }
                    String configType = par.isFinal() ? "final" : (par.isBuild() ? "build" : (par.isReadOnly() ? "read-only" : ""));
                    sb.append(path.getComponentName()).append(" ").append(path.getParameterName()).append(cpi.isDirty() ? "*" : "").append(" ").append(view.getPathValue(path)).append(" ").append(par.getUnits()).append(configType.isEmpty() ? "" : " (" + configType + ")");
                    if (originTag && (tg = (ConfigurationParameterTaggedValue)this.persistedData.getLoadedDataForCategory(category).getConfigurationParameterTaggedValues().get(path.toString())) != null) {
                        sb.append(" ").append(tg.getSingleCategoryTag());
                    }
                    sb.append("\n");
                }
                if (sb.toString().isEmpty()) continue;
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    private void verifyInputCategories(String ... categories) {
        List<String> existingCategories = this.getCategoriesList();
        for (String inputCategory : categories) {
            if (existingCategories.contains(inputCategory)) continue;
            throw new IllegalArgumentException("Input category \"" + inputCategory + "\" is invalid.");
        }
    }

    public void saveChanges(Options options) {
        options = options.withOption("allCategories");
        this.saveCategories(options, new String[0]);
    }

    public void saveChanges() {
        Options options = new Options();
        this.saveChanges(options);
    }

    @Command(description="Saves the specified categories with a name", type=Command.CommandType.CONFIGURATION, category=Command.CommandCategory.CORE, level=1)
    @Option.List(value={@Option(name="allCategories", description="Load all categories, even the unspecified ones."), @Option(name="testRun", description="Perform a trial run of the command and report back the result."), @Option(name="originTag", description="The save is performend in the tag that last defined a configuration parameter"), @Option(name="full", description="Saves all configuration parameters, rather than just the changes")})
    public String saveCategories(Options options, String ... categoryTags) {
        return this.saveChangesForCategoriesInternal(options, categoryTags);
    }

    public void saveChangesForCategories(String ... categoryTags) {
        this.saveCategories(new Options(), categoryTags);
    }

    private String saveChangesForCategoriesInternal(Options options, String ... taggedCategories) {
        boolean fullConfiguration = options.hasOption(this.fullConfigurationOption);
        boolean testRun = options.hasOption(this.testRunOption);
        boolean originTag = options.hasOption(this.originTagOption);
        boolean initialSave = options.hasOption(this.initialSaveOption);
        StringBuilder testSb = new StringBuilder();
        if (testRun) {
            testSb.append("TEST RUN: \n");
        }
        try (ConfigurationWriteLock wlock = this.acquireConfigurationWriteLock();){
            ConfigurationDescription configDesc = this.buildConfigurationDescription(ConfigurationListener.ConfigurationOperation.SAVE, options, taggedCategories);
            this.checkForSubmittedChangesForCategories(new Options(), configDesc.getCategoriesSet());
            this.checkValidStates(true);
            if (configDesc.isEmpty()) {
                String string = "Nothing to save";
                return string;
            }
            try {
                ConfigurationView currentInMemoryView = this.configurationHandler.getLiveConfigurationView();
                ConfigurationView diff = this.extractConfigurationViewFromCurrentConfigurationInfo().diff(currentInMemoryView);
                if (!diff.isEmpty()) {
                    StringBuilder sb = new StringBuilder("the following parameters have had their value changed without notifying the configuration service : \n");
                    for (ParameterPath parm : diff.getAsParameterPathMap().keySet()) {
                        sb.append(parm).append(" expected ").append(this.currentConfigInfo.getCurrentValueForParameter(parm.toString())).append(" was ").append(currentInMemoryView.getPathValue(parm)).append("\n");
                    }
                    throw new BulkSettingException(sb.toString());
                }
                HashMap<SingleCategoryTag, SingleCategoryTagData> dataToSave = new HashMap<SingleCategoryTag, SingleCategoryTagData>();
                ConfigurationView theCurrentView = this.getCurrentConfigurationView();
                Map currentDataMap = theCurrentView.getAsParameterPathMap();
                for (Map.Entry e : currentDataMap.entrySet()) {
                    String category;
                    CategoryDescription catDesc;
                    ParameterPath p = (ParameterPath)e.getKey();
                    String value = (String)e.getValue();
                    String path = p.toString();
                    ConfigurationParameterInfo cpi = this.getConfigurationInfo().getCurrentParameterInfo(path);
                    if (cpi.isReadOnly() || (catDesc = configDesc.getCategoryTag(category = cpi.getCategoryName())) == null) continue;
                    boolean needsSaving = cpi.isDirty();
                    if (initialSave) {
                        boolean bl = needsSaving = needsSaving || this.persistedData.getLoadedDataForCategory(category).getConfigurationParameterTaggedValues().get(path) == null || this.persistedData.getLoadedDataForCategory(category).needsSaving();
                    }
                    if (!fullConfiguration && !needsSaving) continue;
                    SingleCategoryTag tagToSaveInto = originTag ? ((ConfigurationParameterTaggedValue)this.persistedData.getLoadedDataForCategory(category).getConfigurationParameterTaggedValues().get(path)).getSingleCategoryTag() : catDesc.getTopMostTag();
                    boolean skipDataValue = false;
                    if (!fullConfiguration) {
                        int indexOfTagToSaveInto;
                        CategoryDataChain catDataChain = this.persistedData.getLoadedDataForCategory(category);
                        List loadedTags = catDesc.getSingleCategoryTags();
                        int i = indexOfTagToSaveInto = loadedTags.indexOf(tagToSaveInto);
                        while (i-- > 0) {
                            SingleCategoryTag catTag = (SingleCategoryTag)loadedTags.get(i);
                            SingleCategoryTagData tagData = catDataChain.getSingleCategoryTagData(catTag);
                            Map dataMap = tagData.getConfigurationData();
                            if (!dataMap.containsKey(path)) continue;
                            if (this.configurationHandler.getCategoryHandler(category).getConfigurationParameterHandler(path).isCollection()) {
                                SingleCategoryTag sct;
                                ArrayList<String> upToHereValues = new ArrayList<String>();
                                CategoryDataChain dataChain = this.persistedData.getLoadedDataForCategory(category);
                                List currentlyLoadedTags = catDesc.getSingleCategoryTags();
                                Iterator iterator = currentlyLoadedTags.iterator();
                                while (iterator.hasNext() && !(sct = (SingleCategoryTag)iterator.next()).equals((Object)tagToSaveInto)) {
                                    String valStr = (String)dataChain.getSingleCategoryTagData(sct).getConfigurationData().get(path);
                                    if (valStr == null) continue;
                                    upToHereValues.add(valStr);
                                }
                                if (upToHereValues.isEmpty()) break;
                                Object initialValue = this.configurationHandler.getDataChainProcessor(path).processDataChainToObject(upToHereValues);
                                Object currentValue = cpi.getCurrentValueObject();
                                Object[] diffCollections = ConfigurationService.getCollectionDifference(initialValue, currentValue);
                                String tmpValue = "";
                                if (diffCollections[0] != null) {
                                    tmpValue = tmpValue + "+" + TypeUtils.stringify((Object)diffCollections[0]);
                                }
                                if (diffCollections[1] != null) {
                                    tmpValue = tmpValue + "-" + TypeUtils.stringify((Object)diffCollections[1]);
                                }
                                if (!tmpValue.isEmpty()) {
                                    value = tmpValue;
                                    break;
                                }
                                skipDataValue = true;
                                break;
                            }
                            if (!this.isObjectValueEqual(p, (String)dataMap.get(path), value)) break;
                            skipDataValue = true;
                            break;
                        }
                    }
                    SingleCategoryTagData tagData = dataToSave.computeIfAbsent(tagToSaveInto, t -> {
                        SingleCategoryTagData existingTagData = this.persistedData.getLoadedDataForCategory(cpi.getCategoryName()).getSingleCategoryTagData(t);
                        if (existingTagData != null) {
                            return new SingleCategoryTagData(existingTagData);
                        }
                        return new SingleCategoryTagData(t);
                    });
                    if (!skipDataValue) {
                        tagData.getConfigurationData().put(path, value);
                        continue;
                    }
                    tagData.getConfigurationData().remove(path);
                }
                for (SingleCategoryTagData tagDataToSave : dataToSave.values()) {
                    SingleCategoryTagData existingData;
                    String category = tagDataToSave.getSingleCategoryTag().getCategory();
                    if (category.equals("build")) {
                        SingleCategoryTagData buildProperties = this.configurationDao.loadCategoryTag(tagDataToSave.getSingleCategoryTag());
                        buildProperties.mergeSingleCategoryTagData(tagDataToSave);
                        tagDataToSave = buildProperties;
                    }
                    if ((existingData = this.persistedData.getLoadedDataForCategory(category).getSingleCategoryTagData(tagDataToSave.getSingleCategoryTag())) == null || !existingData.getConfigurationData().equals(tagDataToSave.getConfigurationData()) || existingData.needsSaving()) {
                        if (testRun) {
                            testSb.append("Saving to ").append(tagDataToSave.getSingleCategoryTag()).append("\n");
                            testSb.append(tagDataToSave.fullDataString()).append("\n");
                            continue;
                        }
                        SingleCategoryTag singleTag = this.configurationDao.saveChangesForCategoriesAs(tagDataToSave);
                        configDesc.getCategoryTag(category).addOrUpdadateSingleTag(singleTag);
                        this.persistedData.getLoadedDataForCategory(category).addSingleCategoryTagData(tagDataToSave, this.agent.getAgentInfo());
                        continue;
                    }
                    if (!testRun) continue;
                    testSb.append("No data to save for category ").append(category).append("\n");
                }
                currentInMemoryView.setConfigurationDescription(configDesc);
                ConfigurationInfo.Builder ciBuilder = this.buildConfigurationInfo(currentInMemoryView);
                ConfigurationInfo ci = ciBuilder.build();
                if (!testRun) {
                    this.updateStateAndSendStatusConfigurationInfo(ci, ConfigurationListener.ConfigurationOperation.SAVE);
                }
            }
            catch (RuntimeException ex) {
                this.handleException(ex, ConfigurationListener.ConfigurationOperation.SAVE);
            }
        }
        return testSb.toString();
    }

    private static Object[] getCollectionDifference(Object initial, Object current) {
        if (initial instanceof Collection && current instanceof Collection) {
            Collection initialCollection = (Collection)initial;
            Collection currentCollection = (Collection)current;
            ArrayList<Object> added = new ArrayList<Object>();
            for (Object currentObject : currentCollection) {
                if (initialCollection.contains(currentObject)) continue;
                added.add(currentObject);
            }
            ArrayList removed = new ArrayList();
            for (Object initialObject : initialCollection) {
                if (currentCollection.contains(initialObject)) continue;
                removed.add(initialObject);
            }
            return new Object[]{added.isEmpty() ? null : added, removed.isEmpty() ? null : removed};
        }
        if (initial instanceof Map && current instanceof Map) {
            Map initialMap = (Map)initial;
            Map currentMap = (Map)current;
            HashMap added = new HashMap();
            for (Object currentKey : currentMap.keySet()) {
                Object currentValue = currentMap.get(currentKey);
                if (initialMap.containsKey(currentKey) && initialMap.get(currentKey).equals(currentValue)) continue;
                added.put(currentKey, currentValue);
            }
            HashMap removed = new HashMap();
            for (Object initialKey : initialMap.keySet()) {
                Object initialValue = initialMap.get(initialKey);
                if (currentMap.containsKey(initialKey)) continue;
                removed.put(initialKey, initialValue);
            }
            return new Object[]{added.isEmpty() ? null : added, removed.isEmpty() ? null : removed};
        }
        throw new RuntimeException("Something went wrong!! Incompatible collection types: " + initial.getClass() + " " + current.getClass());
    }

    private boolean isObjectValueEqual(ParameterPath pp, String str1, String str2) {
        ConfigurationParameterHandler parHandler = this.configurationHandler.getConfigurationParameterHandler(pp);
        Object obj1 = parHandler.convert(str1).getValue();
        Object obj2 = parHandler.convert(str2).getValue();
        if (obj1 == null && obj2 != null) {
            return false;
        }
        return obj1 == null || Objects.deepEquals(obj1, obj2);
    }

    private ConfigurationDescription getPartialConfigurationDescription(String ... categories) {
        HashSet<String> set = new HashSet<String>(Arrays.asList(categories));
        return ConfigurationDescription.fromConfigurationInfo((ConfigurationInfo)this.currentConfigInfo, set);
    }

    @Command(name="dropChanges", description="drop unsaved changes for the specified categories", type=Command.CommandType.CONFIGURATION, category=Command.CommandCategory.CORE, level=1)
    @Option.List(value={@Option(name="allCategories", description="Load all categories, even the unspecified ones."), @Option(name="testRun", description="Perform a trial run of the command and report back the result.")})
    public String dropChanges(Options options, String ... categories) {
        return this.dropChangesInternal(options, categories);
    }

    private Map<String, List<ConfigurationParameterInfo>> getChangesForCategories(Set<String> cats) {
        HashMap<String, List<ConfigurationParameterInfo>> changesByCategory = new HashMap<String, List<ConfigurationParameterInfo>>();
        for (ConfigurationParameterInfo cpi : this.currentConfigInfo.getAllParameterInfo()) {
            if (!cats.contains(cpi.getCategoryName()) || cpi.isReadOnly()) continue;
            String currentValue = cpi.getCurrentValue();
            String configuredValue = cpi.getConfiguredValue();
            if ((currentValue == null || currentValue.equals(configuredValue)) && (currentValue != null || configuredValue == null)) continue;
            changesByCategory.computeIfAbsent(cpi.getCategoryName(), k -> new ArrayList()).add(cpi);
        }
        return changesByCategory;
    }

    private String buildStringWithChanges(Map<String, List<ConfigurationParameterInfo>> changes, boolean showMigration) {
        StringBuilder sb = new StringBuilder();
        for (String category : changes.keySet()) {
            List<ConfigurationParameterInfo> droppedForCategory = changes.get(category);
            if (droppedForCategory == null || droppedForCategory.isEmpty()) continue;
            sb.append("\nCategory: ").append(category).append("\n");
            for (ConfigurationParameterInfo cpi : droppedForCategory) {
                sb.append("\t").append(cpi.getPathName()).append(": ").append(cpi.getCurrentValue());
                if (showMigration) {
                    sb.append(" --> ").append(cpi.getConfiguredValue());
                }
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    private String dropChangesInternal(Options options, String ... cats) {
        ConfigurationDescription confDesc = this.buildConfigurationDescription(ConfigurationListener.ConfigurationOperation.DROP, options, cats);
        Set catSet = confDesc.getCategoriesSet();
        boolean testRun = options.hasOption(this.testRunOption);
        String result = "";
        try (ConfigurationWriteLock wlock = this.acquireConfigurationWriteLock();){
            this.checkValidStates(true);
            try {
                StringBuilder sb;
                Map<String, List<ConfigurationParameterInfo>> droppedChangesByCategory = this.getChangesForCategories(catSet);
                ConfigurationView view = new ConfigurationView(this.getPartialConfigurationDescription(catSet.toArray(new String[1])));
                for (List<ConfigurationParameterInfo> list : droppedChangesByCategory.values()) {
                    for (ConfigurationParameterInfo cpi : list) {
                        view.putParameterValue(cpi.getComponentName(), cpi.getParameterName(), cpi.getConfiguredValue());
                    }
                }
                if (!testRun) {
                    sb = new StringBuilder("List of dropped changes by category.\n");
                    ConfigurationView res = this.configurationHandler.loadCategories(view, true);
                    ConfigurationInfo.Builder ciBuilder = this.buildConfigurationInfo(res);
                    this.updateStateAndSendStatusConfigurationInfo(ciBuilder.build(), ConfigurationListener.ConfigurationOperation.DROP);
                } else {
                    sb = new StringBuilder("TEST RUN: List of changes that would be dropped by category.\n");
                }
                sb.append(this.buildStringWithChanges(droppedChangesByCategory, true));
                result = sb.toString();
            }
            catch (RuntimeException ex) {
                this.handleException(ex, ConfigurationListener.ConfigurationOperation.DROP);
            }
        }
        conf_sub_log.log(Level.INFO, result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(description="Update the specified category tags", type=Command.CommandType.CONFIGURATION, category=Command.CommandCategory.CORE, level=1)
    @Option.List(value={@Option(name="allCategories", description="Load all categories, even the unspecified ones."), @Option(name="testRun", description="Perform a trial run of the command and report back the result."), @Option(name="dropChanges", description="Force the drop of all the outstanding changes.")})
    public String updateCategories(Options options, String ... taggedCategories) {
        try (ConfigurationWriteLock wlock = this.acquireConfigurationWriteLock();){
            ConfigurationDescription configDesc = this.buildConfigurationDescription(ConfigurationListener.ConfigurationOperation.UPDATE, options, taggedCategories);
            if (configDesc.isEmpty()) {
                String string = "No categories to update";
                return string;
            }
            boolean testRun = options.hasOption(this.testRunOption);
            StringBuilder sb = new StringBuilder();
            String handleChanges = this.handleExistingChanges(ConfigurationListener.ConfigurationOperation.UPDATE, options, configDesc.getCategoriesSet());
            if (handleChanges != null) {
                sb = new StringBuilder(handleChanges);
            }
            ConfigurationView updatedView = null;
            ConfigurationView fullView = new ConfigurationView(this.currentView);
            Exception exception = null;
            try {
                if (testRun) {
                    sb.append("TEST RUN: ");
                }
                ConfigurationLoadedData copyOfLoadedData = new ConfigurationLoadedData();
                copyOfLoadedData.putConfigurationLoadedData(this.persistedData);
                sb.append("Initial Configuration Description \n").append(copyOfLoadedData.getConfigurationDescription()).append("\n");
                sb.append("Updating Configuration \n").append(configDesc).append("\n");
                for (String updateCat : configDesc.getCategoriesSet()) {
                    for (SingleCategoryTag updateTag : configDesc.getCategoryTag(updateCat).getSingleCategoryTags()) {
                        SingleCategoryTagData updatedTagData = this.configurationDao.loadCategoryTag(updateTag);
                        sb.append("Updated tag: ").append(updateTag).append(" to version ").append(updatedTagData.getSingleCategoryTag().getResolvedVersion()).append("\n");
                        copyOfLoadedData.getLoadedDataForCategory(updateCat).addSingleCategoryTagData(updatedTagData, this.agent.getAgentInfo());
                    }
                }
                if (!testRun) {
                    updatedView = copyOfLoadedData.getConfigurationView(this.configurationHandler.getDataChainProcessorsMap());
                    if (this.testContext) {
                        for (String category : configDesc.getCategoriesSet()) {
                            for (ConfigurationParameterHandler cph : this.getCategoryParameters(category)) {
                                ParameterPath parPath = cph.getParameterPath();
                                if (updatedView.containsPath(parPath)) continue;
                                updatedView.putParameterValue(parPath.toString(), this.getInitialView().getPathValue(parPath));
                            }
                        }
                    }
                    updatedView = this.configurationHandler.loadCategories(updatedView);
                    this.persistedData = copyOfLoadedData;
                    fullView.putAll(updatedView);
                }
                sb.append("Final Configuration Description \n").append(copyOfLoadedData.getConfigurationDescription());
            }
            catch (Exception e) {
                exception = e;
                conf_sub_log.log(Level.WARNING, "Failed to load configuration " + configDesc.getDescriptionName(), e);
            }
            finally {
                if (exception != null) {
                    conf_sub_log.log(Level.WARNING, "Rolling back to previously loaded configuration: {0}", this.currentView.getConfigurationDescription().getDescriptionName());
                    this.dropAllSubmittedChanges();
                    fullView = this.configurationHandler.loadCategories(this.currentView);
                }
                if (!testRun) {
                    ConfigurationInfo.Builder ciBuilder = this.buildConfigurationInfo(fullView);
                    this.updateStateAndSendStatusConfigurationInfo(ciBuilder.build(), ConfigurationListener.ConfigurationOperation.UPDATE);
                    if (exception != null) {
                        this.handleException((RuntimeException)new ConfigurationServiceException("Failed Loading " + configDesc.getDescriptionName(), (Throwable)exception), ConfigurationListener.ConfigurationOperation.UPDATE);
                    }
                }
            }
            String string = sb.toString();
            return string;
        }
    }

    public String updateCategories(String ... taggedCategories) {
        return this.updateCategories(new Options(), taggedCategories);
    }

    @Command(description="loads the configuration for the specified categories", type=Command.CommandType.CONFIGURATION, category=Command.CommandCategory.CORE, level=1)
    @Option.List(value={@Option(name="allCategories", description="Load all categories, even the unspecified ones."), @Option(name="dropChanges", description="Force the drop of all the outstanding changes."), @Option(name="testRun", description="Perform a trial run of the command and report back the result.")})
    public String loadCategories(Options options, String ... taggedCategories) {
        boolean allCategories = options.hasOption(this.allCategoriesOption);
        if (taggedCategories.length == 0 && !allCategories) {
            return "No categories to load";
        }
        try (ConfigurationWriteLock wlock = this.acquireConfigurationWriteLock();){
            ConfigurationDescription res = this.buildConfigurationDescription(ConfigurationListener.ConfigurationOperation.LOAD, options, taggedCategories);
            String string = this.loadCategoriesInternal(res, options);
            return string;
        }
    }

    public String loadCategories(String ... taggedCategories) {
        return this.loadCategories(new Options(), taggedCategories);
    }

    public ConfigurationDescription buildConfigurationDescription(ConfigurationListener.ConfigurationOperation co, Options options, String ... taggedCategories) {
        if (options == null) {
            options = new Options();
        }
        HashMap<String, CategoryDescription> requestedCategoryDescriptions = new HashMap<String, CategoryDescription>();
        for (String category : taggedCategories) {
            boolean isFull;
            String catName;
            CategoryDescription requestedCatDescription = new CategoryDescription(category, this.getDefaultSourceForCategory(category));
            if (category.contains(":")) {
                requestedCatDescription = CategoryDescription.parseCategoryTagInput((String)category, cat -> this.getDefaultSourceForCategory((String)cat));
            }
            if (!this.categories.contains(catName = requestedCatDescription.getCategoryName())) {
                throw new IllegalArgumentException("The provided category \"" + catName + "\" does not exist. Valid categories are: " + this.categories);
            }
            if (co == ConfigurationListener.ConfigurationOperation.SAVE && !(isFull = options.hasOption(this.fullConfigurationOption)) && !this.currentDescription.getCategoryTag(catName).hasChanges()) {
                throw new IllegalArgumentException("There are no changes to be saved for category " + category);
            }
            requestedCategoryDescriptions.put(requestedCatDescription.getCategoryName(), requestedCatDescription);
        }
        boolean allCategories = options.hasOption(this.allCategoriesOption);
        if (allCategories) {
            for (String category : this.categories) {
                requestedCategoryDescriptions.computeIfAbsent(category, c -> new CategoryDescription(c, this.getDefaultSourceForCategory((String)c)));
            }
        }
        ConfigurationDescription res = new ConfigurationDescription();
        try (ConfigurationWriteLock wlock = this.acquireConfigurationWriteLock();){
            this.checkValidStates(true);
            for (CategoryDescription confDescription : requestedCategoryDescriptions.values()) {
                String category = confDescription.getCategoryName();
                List requestedTags = confDescription.getSingleCategoryTags();
                int nTags = requestedTags.size();
                if (co == ConfigurationListener.ConfigurationOperation.SAVE) {
                    if (nTags > 1) {
                        throw new IllegalArgumentException("Invalid tagged category for SAVE operation " + confDescription + ". It's not allowed to specify more than one tag.");
                    }
                    CategoryDescription catDescription = this.currentDescription.getCategoryTag(category);
                    res.addCategoryTag(catDescription);
                    if (requestedTags.isEmpty()) continue;
                    SingleCategoryTag requestedSaveTag = (SingleCategoryTag)requestedTags.get(0);
                    if (requestedSaveTag.getInputVersion() != "") {
                        throw new IllegalArgumentException("Invalid tagged category for SAVE operation " + confDescription + ". It's illegal to specify a tag with a version.");
                    }
                    if (res.getCategoryTag(category).containsSingleTag(requestedSaveTag)) continue;
                    res.getCategoryTag(category).addOrUpdadateSingleTag(requestedSaveTag);
                    continue;
                }
                if (co == ConfigurationListener.ConfigurationOperation.LOAD) {
                    res.addCategoryTag(new CategoryDescription(category, this.getDefaultSourceForCategory(category)));
                    if (requestedTags.isEmpty()) continue;
                    for (SingleCategoryTag tag : requestedTags) {
                        if (this.baseDescription.getCategoryTag(category).containsSingleTag(tag) || res.getCategoryTag(category).containsSingleTag(tag)) {
                            throw new IllegalArgumentException("Invalid taggedCategory for LOAD operation " + confDescription + ". There is a duplicate tag to be loaded.");
                        }
                        res.getCategoryTag(category).addOrUpdadateSingleTag(tag);
                    }
                    continue;
                }
                if (co == ConfigurationListener.ConfigurationOperation.UPDATE) {
                    CategoryDescription currentCategoryDesc = this.currentDescription.getCategoryTag(category);
                    res.addCategoryTag(new CategoryDescription(category, this.getDefaultSourceForCategory(category)));
                    if (requestedTags.isEmpty()) {
                        for (SingleCategoryTag tag : currentCategoryDesc.getSingleCategoryTags()) {
                            if (tag.isRequestedVersionAnInteger()) continue;
                            res.getCategoryTag(category).addOrUpdadateSingleTag(tag);
                        }
                        continue;
                    }
                    for (SingleCategoryTag tag : requestedTags) {
                        if (!currentCategoryDesc.containsSingleTag(tag)) {
                            throw new IllegalArgumentException("Invalid taggedCategory for UPDATE operation " + confDescription + ". The category tags to be updated must exist in the current configuration " + this.currentDescription);
                        }
                        if (tag.getInputVersion().equals("")) {
                            SingleCategoryTag existingTag = currentCategoryDesc.getSingleTag(tag);
                            if (existingTag.isRequestedVersionAnInteger()) continue;
                            res.getCategoryTag(category).addOrUpdadateSingleTag(existingTag);
                            continue;
                        }
                        res.getCategoryTag(category).addOrUpdadateSingleTag(tag);
                    }
                    continue;
                }
                if (co == ConfigurationListener.ConfigurationOperation.DROP) {
                    res.addCategoryTag(this.currentDescription.getCategoryTag(category));
                    if (requestedTags.isEmpty()) continue;
                    throw new IllegalArgumentException("Invalid category for DROP operation " + confDescription + ". Only categories are accepted; tags cannot be specified.");
                }
                throw new IllegalArgumentException("Invalid operation " + (Object)((Object)co));
            }
        }
        return res;
    }

    private String handleExistingChanges(ConfigurationListener.ConfigurationOperation co, Options options, Set<String> catSet) {
        boolean dropChanges = options.hasOption(this.dropChangesOption);
        String result = this.checkForSubmittedChangesForCategories(options, catSet);
        if (co == ConfigurationListener.ConfigurationOperation.LOAD || co == ConfigurationListener.ConfigurationOperation.UPDATE) {
            if (dropChanges) {
                Options dropOptions = new Options(options);
                dropOptions.withOption("doNotPublish");
                result = result + this.dropChanges(dropOptions, (String[])catSet.stream().toArray(String[]::new));
            } else {
                Map<String, List<ConfigurationParameterInfo>> changesByCategory = this.getChangesForCategories(catSet);
                if (!changesByCategory.isEmpty()) {
                    StringBuilder sb = new StringBuilder("Cannot perform a Load or Update operation with the following outstanding changes.\nThey either need to be Saved or Dropped first.\n");
                    sb.append(this.buildStringWithChanges(changesByCategory, false));
                    throw new RuntimeException(sb.toString());
                }
            }
        } else {
            throw new RuntimeException("Method \"handleExistingChanges\" does not support ConfigurationOperation " + (Object)((Object)co));
        }
        return result;
    }

    public ConfigurationLoadedData getConfigurationLoadedData() {
        ConfigurationLoadedData d = new ConfigurationLoadedData();
        d.putConfigurationLoadedData(this.persistedData);
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private String loadCategoriesInternal(ConfigurationDescription configDesc, Options options) {
        block24: {
            testRun = options.hasOption(this.testRunOption);
            sb = new StringBuilder();
            handleChanges = this.handleExistingChanges(ConfigurationListener.ConfigurationOperation.LOAD, options, configDesc.getCategoriesSet());
            if (handleChanges != null) {
                sb = new StringBuilder(handleChanges);
            }
            view = this.currentView;
            loadedView = null;
            exception = null;
            try {
                lastLoad = new ConfigurationLoadedData();
                for (String baseCat : this.baseDescription.getCategoriesSet()) {
                    loadedCatData = this.persistedData.getLoadedDataForCategory(baseCat);
                    if (!configDesc.getCategoriesSet().contains(baseCat)) continue;
                    baseCatData = new CategoryDataChain(baseCat);
                    baseDesc = this.baseDescription.getCategoryTag(baseCat);
                    for (SingleCategoryTag t : baseDesc.getSingleCategoryTags()) {
                        baseCatData.addSingleCategoryTagData(loadedCatData.getSingleCategoryTagData(t), this.agent.getAgentInfo());
                    }
                    lastLoad.putCategoryDataChain(baseCatData);
                }
                for (String cat : configDesc.getCategoriesSet()) {
                    catDataChain = lastLoad.getLoadedDataForCategory(cat);
                    catDesc = configDesc.getCategoryTag(cat);
                    for (SingleCategoryTag t : catDesc.getSingleCategoryTags()) {
                        tagData = this.configurationDao.loadCategoryTag(t);
                        this.verifyIntegrityOfLoadedData(tagData, true);
                        catDataChain.addSingleCategoryTagData(tagData, this.agent.getAgentInfo());
                    }
                }
                loadedView = lastLoad.getConfigurationView(this.configurationHandler.getDataChainProcessorsMap());
                if (testRun) {
                    sb.append("TEST RUN: ");
                }
                sb.append("Loaded Configuration ").append(lastLoad.getConfigurationDescription());
                for (String category : lastLoad.getCategories()) {
                    catDataChain = lastLoad.getLoadedDataForCategory(category);
                    categoryLoadedData = catDataChain.getConfigurationParameterTaggedValues();
                    categoryExistingData = this.persistedData.getLoadedDataForCategory(category).getConfigurationParameterTaggedValues();
                    sb.append("\n\nData for category: ").append(category);
                    for (Map.Entry e : categoryLoadedData.entrySet()) {
                        path = (String)e.getKey();
                        loadedTaggedValue = (ConfigurationParameterTaggedValue)e.getValue();
                        existingTaggedValue = (ConfigurationParameterTaggedValue)categoryExistingData.get(path);
                        sb.append("\n").append(path).append(": ").append(loadedTaggedValue.getParameterValue()).append(" (").append(loadedTaggedValue.getSingleCategoryTag()).append(")");
                        if (existingTaggedValue == null) continue;
                        sb.append(" replaces ").append(existingTaggedValue.getParameterValue()).append(" (").append(existingTaggedValue.getSingleCategoryTag()).append(")");
                    }
                    sb.append("\n");
                }
                if (this.testContext) {
                    for (String category : configDesc.getCategoriesSet()) {
                        for (ConfigurationParameterHandler cph : this.getCategoryParameters(category)) {
                            parPath = cph.getParameterPath();
                            if (loadedView.containsPath(parPath)) continue;
                            loadedView.putParameterValue(parPath.toString(), this.getInitialView().getPathValue(parPath));
                        }
                    }
                }
                if (!testRun) {
                    loadedView = this.configurationHandler.loadCategories(loadedView);
                    this.persistedData.putConfigurationLoadedData(lastLoad);
                }
                if (exception == null) break block24;
                ConfigurationService.conf_sub_log.log(Level.WARNING, "Rolling back to previously loaded configuration: {0}", view.getConfigurationDescription().getDescriptionName());
                this.dropAllSubmittedChanges();
            }
            catch (Exception e) {
                block25: {
                    try {
                        exception = e;
                        ConfigurationService.conf_sub_log.log(Level.WARNING, "Failed to load configuration " + configDesc.getDescriptionName(), e);
                        if (exception == null) break block25;
                        ConfigurationService.conf_sub_log.log(Level.WARNING, "Rolling back to previously loaded configuration: {0}", view.getConfigurationDescription().getDescriptionName());
                        this.dropAllSubmittedChanges();
                    }
                    catch (Throwable var20_22) {
                        if (exception != null) {
                            ConfigurationService.conf_sub_log.log(Level.WARNING, "Rolling back to previously loaded configuration: {0}", view.getConfigurationDescription().getDescriptionName());
                            this.dropAllSubmittedChanges();
                            loadedView = this.configurationHandler.loadCategories(view);
                            loadedView.setConfigurationDescription(new ConfigurationDescription());
                        }
                        if (!testRun) {
                            ciBuilder = this.buildConfigurationInfo(loadedView);
                            this.updateStateAndSendStatusConfigurationInfo(ciBuilder.build(), ConfigurationListener.ConfigurationOperation.LOAD);
                            if (exception != null) {
                                this.handleException((RuntimeException)new ConfigurationServiceException("Failed Loading " + configDesc.getDescriptionName(), (Throwable)exception), ConfigurationListener.ConfigurationOperation.LOAD);
                            }
                        }
                        throw var20_22;
                    }
                    loadedView = this.configurationHandler.loadCategories(view);
                    loadedView.setConfigurationDescription(new ConfigurationDescription());
                }
                if (!testRun) {
                    ciBuilder = this.buildConfigurationInfo(loadedView);
                    this.updateStateAndSendStatusConfigurationInfo(ciBuilder.build(), ConfigurationListener.ConfigurationOperation.LOAD);
                    if (exception != null) {
                        this.handleException((RuntimeException)new ConfigurationServiceException("Failed Loading " + configDesc.getDescriptionName(), (Throwable)exception), ConfigurationListener.ConfigurationOperation.LOAD);
                    } else {
                        ** GOTO lbl106
                    }
                } else {
                    ** GOTO lbl106
                }
            }
            loadedView = this.configurationHandler.loadCategories(view);
            loadedView.setConfigurationDescription(new ConfigurationDescription());
        }
        if (!testRun) {
            ciBuilder = this.buildConfigurationInfo(loadedView);
            this.updateStateAndSendStatusConfigurationInfo(ciBuilder.build(), ConfigurationListener.ConfigurationOperation.LOAD);
            if (exception != null) {
                this.handleException((RuntimeException)new ConfigurationServiceException("Failed Loading " + configDesc.getDescriptionName(), (Throwable)exception), ConfigurationListener.ConfigurationOperation.LOAD);
            }
        }
        if (testRun) {
            return sb.toString();
        }
        return "";
    }

    void verifyIntegrityOfLoadedData(SingleCategoryTagData tagData, boolean failOnException) {
        Map loadedDataForTag = tagData.getConfigurationDataForAgent(this.agent.getAgentInfo());
        Iterator iterator = loadedDataForTag.entrySet().iterator();
        ArrayList<String> removedParameters = new ArrayList<String>();
        while (iterator.hasNext()) {
            Map.Entry e = iterator.next();
            String parameterPath = (String)e.getKey();
            boolean isBuildProperty = parameterPath.contains(".") && !parameterPath.contains("/");
            if (isBuildProperty) continue;
            try {
                if (this.getParameterByPath(ParameterPath.valueOf((String)parameterPath)).getCategory().equals(tagData.getSingleCategoryTag().getCategory())) continue;
                iterator.remove();
                removedParameters.add(parameterPath);
            }
            catch (Exception ex) {
                if (failOnException) {
                    throw ex;
                }
                tagData.removeConfigurationParameter(parameterPath);
            }
        }
        SingleCategoryTag singleCategoryTag = tagData.getSingleCategoryTag();
        if (!removedParameters.isEmpty()) {
            StringBuilder sb = new StringBuilder("The following parameters don't belong to category " + singleCategoryTag.getCategory() + "\n");
            for (String par : removedParameters) {
                sb.append(par).append("\n");
            }
            sb.append("Please remove them from ").append(singleCategoryTag.toString());
            conf_sub_log.log(Level.WARNING, sb.toString());
            if (failOnException) {
                RuntimeException re = new RuntimeException(sb.toString());
                throw new ConfigurationServiceException("Could not load " + singleCategoryTag, (Throwable)re);
            }
        }
    }

    @Command(description="return a ConfigurationInfo object", type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM, level=0)
    public ConfigurationInfo getConfigurationInfo() {
        try (ConfigurationLock rlock = this.acquireConfigurationLock();){
            ConfigurationInfo configurationInfo = this.currentConfigInfo;
            return configurationInfo;
        }
    }

    @Command(description="Return the configuration description for the provided categories", type=Command.CommandType.QUERY, category=Command.CommandCategory.CORE, level=0)
    @Option.List(value={@Option(name="initial", description="Shows the initial configuration description, i.e. the one requested when the Subsystem started."), @Option(name="base", description="Shows the base configuration description")})
    public ConfigurationDescription getConfigurationDescription(Options options, String ... categories) {
        boolean initial = options.hasOption(this.initialOption);
        boolean base = options.hasOption(this.baseOption);
        if (initial && base) {
            throw new IllegalArgumentException("Options \"base\" and \"initial\" cannot be provided together.");
        }
        if (initial) {
            return this.cloneConfigurationDescriptionForCategories(this.defaultInitialDescription, categories);
        }
        if (base) {
            return this.cloneConfigurationDescriptionForCategories(this.baseDescription, categories);
        }
        return this.cloneConfigurationDescriptionForCategories(this.currentDescription, categories);
    }

    public ConfigurationDescription getConfigurationDescription() {
        return this.getConfigurationDescription(new Options(), new String[0]);
    }

    private ConfigurationDescription cloneConfigurationDescriptionForCategories(ConfigurationDescription cdToClone, String ... categories) {
        HashSet<String> requestedCategories = new HashSet<String>();
        if (categories == null | categories.length == 0) {
            requestedCategories = this.getCategories();
        } else {
            requestedCategories.addAll(Arrays.asList(categories));
            this.checkCategories(requestedCategories);
        }
        return cdToClone.cloneForCategories(requestedCategories);
    }

    public void setReadOnlyParameter(String componentName, String parameterName, Object value) {
        try (ConfigurationWriteLock wlock = this.acquireConfigurationWriteLock();){
            if (!this.isParameterReadOnly(componentName, parameterName)) {
                throw new IllegalArgumentException(componentName + "/" + parameterName + " is not a read-only configuration parameter");
            }
            try {
                ConfigurationView view = this.configurationHandler.setSingleParameter(componentName, parameterName, value, true);
                ConfigurationInfo.Builder ciBuilder = this.buildConfigurationInfo(view);
                this.updateStateAndSendStatusConfigurationInfo(ciBuilder.build(), ConfigurationListener.ConfigurationOperation.CHANGE);
            }
            catch (RuntimeException ex) {
                this.handleException(ex, ConfigurationListener.ConfigurationOperation.CHANGE);
            }
        }
    }

    @Command(description="publish a ConfigurationInfo object", type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM, level=0)
    public void publishConfigurationInfo() {
        this.publishConfigurationInfo(null);
    }

    public void publishConfigurationInfo(ConfigurationData configData) {
        try (ConfigurationLock rlock = this.acquireConfigurationLock();){
            ConfigurationInfo ci = this.getConfigurationInfo();
            if (configData == null || ci.getAllParameterInfo().size() == configData.getCurrentValues().size()) {
                if (this.fullConfigurationNeedsUpdating || this.zippedFullConfigurationData == null) {
                    configData = ConfigurationData.buildConfigurationData((ConfigurationInfo)ci, (List)ci.getAllParameterInfo(), null);
                    this.zippedFullConfigurationData = this.gzipConfigurationData(configData);
                    this.fullConfigurationNeedsUpdating = false;
                }
                this.agent.sendStatusMessage((StatusMessage)new StatusConfigurationData(this.zippedFullConfigurationData, true));
            } else {
                this.agent.sendStatusMessage((StatusMessage)new StatusConfigurationData(configData, false));
            }
        }
    }

    @Command(description="Submits a single change to be processed immediately", type=Command.CommandType.CONFIGURATION, category=Command.CommandCategory.CORE, level=1)
    public void change(@Argument(allowedValueProvider="getAllConfigurableComponentsWithTrailingSlash") String componentName, String parameterName, Object value) {
        try (ConfigurationWriteLock wlock = this.acquireConfigurationWriteLock();){
            this.checkValidStates(true);
            componentName = this.manipulateInputComponentName(componentName);
            if (!this.isParameterConfigurable(componentName, parameterName)) {
                throw new IllegalArgumentException(componentName + "/" + parameterName + " is not a configuration parameter");
            }
            if (this.isParameterReadOnly(componentName, parameterName)) {
                throw new IllegalArgumentException(componentName + "/" + parameterName + " is a read-only configuration parameter");
            }
            this.checkForSubmittedChanges();
            try {
                ConfigurationView view = this.configurationHandler.setSingleParameter(componentName, parameterName, value);
                ConfigurationInfo.Builder ciBuilder = this.buildConfigurationInfo(view);
                this.updateStateAndSendStatusConfigurationInfo(ciBuilder.build(), ConfigurationListener.ConfigurationOperation.CHANGE);
            }
            catch (RuntimeException ex) {
                this.handleException(ex, ConfigurationListener.ConfigurationOperation.CHANGE);
            }
        }
    }

    private List<String> getAllConfigurableComponents() {
        try (ConfigurationLock rlock = this.acquireConfigurationLock();){
            ArrayList<String> arrayList = new ArrayList<String>(this.configurationHandler.getConfigurableComponents());
            return arrayList;
        }
    }

    public List<String> getAllConfigurableComponentsWithTrailingSlash() {
        if (this.configurableComponentsForCommands.isEmpty()) {
            try (ConfigurationLock rlock = this.acquireConfigurationLock();){
                for (String component : this.configurationHandler.getConfigurableComponents()) {
                    String componentWithTrailingSlash = !component.isEmpty() ? component : "/";
                    this.configurableComponentsForCommands.add(componentWithTrailingSlash);
                }
            }
        }
        return this.configurableComponentsForCommands;
    }

    @Command(description="Submits a change of parameter to be validated later", type=Command.CommandType.CONFIGURATION, category=Command.CommandCategory.CORE, level=1)
    public void submitChange(@Argument(allowedValueProvider="getAllConfigurableComponentsWithTrailingSlash") String componentName, String parameterName, Object value) {
        componentName = this.manipulateInputComponentName(componentName);
        try (ConfigurationWriteLock wlock = this.acquireConfigurationWriteLock();){
            this.checkValidStates(true);
            this.configurationHandler.submitChange(componentName, parameterName, value);
        }
    }

    @Command(description="Submits changes of parameters to be validated later", type=Command.CommandType.CONFIGURATION, category=Command.CommandCategory.CORE, level=1)
    public void submitChanges(@Argument(allowedValueProvider="getAllConfigurableComponentsWithTrailingSlash") String componentName, Map<String, Object> changes) {
        componentName = this.manipulateInputComponentName(componentName);
        try (ConfigurationWriteLock wlock = this.acquireConfigurationWriteLock();){
            this.checkValidStates(true);
            for (Map.Entry<String, Object> entry : changes.entrySet()) {
                this.configurationHandler.submitChange(componentName, entry.getKey(), entry.getValue());
            }
        }
    }

    @Command(name="applySubmittedChanges", description="processes the bulk change", type=Command.CommandType.CONFIGURATION, category=Command.CommandCategory.CORE, level=1)
    public void commitBulkChange() {
        this.commitBulkChangeForComponent(null);
    }

    public void commitBulkChangeForComponent(String component) {
        try (ConfigurationWriteLock wlock = this.acquireConfigurationWriteLock();){
            this.checkValidStates(true);
            try {
                ConfigurationView view = this.configurationHandler.commitBulkChange(null, component);
                ConfigurationInfo.Builder ciBuilder = this.buildConfigurationInfo(view);
                this.updateStateAndSendStatusConfigurationInfo(ciBuilder.build(), ConfigurationListener.ConfigurationOperation.CHANGE);
                conf_sub_log.log(Level.FINEST, this.currentConfigInfo.getLatestChanges().size() + " successfully set parameters");
            }
            catch (RuntimeException ex) {
                this.handleException(ex, ConfigurationListener.ConfigurationOperation.CHANGE);
            }
        }
    }

    @Command(name="cancelAllSubmittedChanges", description="Drops the submitted changes for all components", type=Command.CommandType.CONFIGURATION, category=Command.CommandCategory.CORE, level=1)
    public void dropAllSubmittedChanges() {
        try (ConfigurationWriteLock wlock = this.acquireConfigurationWriteLock();){
            this.configurationHandler.dropAllSubmittedChanges();
        }
    }

    @Command(name="cancelSubmittedChangesForComponent", description="Drops the submitted changes for the given component", type=Command.CommandType.CONFIGURATION, category=Command.CommandCategory.CORE, level=1)
    public void dropSubmittedChangesForComponent(@Argument(allowedValueProvider="getAllConfigurableComponentsWithTrailingSlash", description="the component name") String name) {
        name = this.manipulateInputComponentName(name);
        try (ConfigurationWriteLock wlock = this.acquireConfigurationWriteLock();){
            this.configurationHandler.dropSubmittedChangesForComponent(name);
        }
    }

    @Command(description="Returns the current submitted changes for the given component", type=Command.CommandType.CONFIGURATION, category=Command.CommandCategory.CORE, level=1)
    public Map<String, String> getSubmittedChangesForComponent(@Argument(allowedValueProvider="getAllConfigurableComponentsWithTrailingSlash", description="the component name") String name) {
        name = this.manipulateInputComponentName(name);
        try (ConfigurationLock rlock = this.acquireConfigurationLock();){
            Map map = this.configurationHandler.getSubmittedChangesForComponent(name);
            return map;
        }
    }

    @Command(description="Returns the current submitted changes for each component", type=Command.CommandType.CONFIGURATION, category=Command.CommandCategory.CORE, level=1)
    public Map<String, Map<String, String>> getAllSubmittedChanges() {
        try (ConfigurationLock rlock = this.acquireConfigurationLock();){
            Map map = this.configurationHandler.getAllSubmittedChanges();
            return map;
        }
    }

    @Command(description="returns the categories of this subsystem", type=Command.CommandType.QUERY, category=Command.CommandCategory.CORE, level=0)
    public Set<String> getCategories() {
        return Collections.unmodifiableSet(this.categories);
    }

    List<String> getCategoriesList() {
        return new ArrayList<String>(this.getCategories());
    }

    @Command(description="returns the current values for a given component that belong to the specified categories", type=Command.CommandType.QUERY, category=Command.CommandCategory.CORE, level=0)
    public Map<String, String> getConfigurationParameterValuesForComponent(@Argument(allowedValueProvider="getAllConfigurableComponentsWithTrailingSlash") String componentName, String ... categories) {
        componentName = this.manipulateInputComponentName(componentName);
        this.verifyInputCategories(categories);
        try (ConfigurationLock rlock = this.acquireConfigurationLock();){
            HashSet<String> categorySet = new HashSet<String>();
            if (categories != null) {
                categorySet.addAll(Arrays.asList(categories));
            }
            Map map = this.configurationHandler.getCurrentValuesForComponent(componentName, categorySet);
            return map;
        }
    }

    private boolean isParameterConfigurable(@Argument(allowedValueProvider="getAllConfigurableComponentsWithTrailingSlash") String componentName, String parameterName) {
        componentName = this.manipulateInputComponentName(componentName);
        try (ConfigurationLock rlock = this.acquireConfigurationLock();){
            boolean bl = this.configurationHandler.isParameterConfigurable(componentName, parameterName);
            return bl;
        }
    }

    public boolean isParameterReadOnly(String componentName, String parameterName) {
        try (ConfigurationLock rlock = this.acquireConfigurationLock();){
            boolean bl = this.configurationHandler.isParameterReadOnly(componentName, parameterName);
            return bl;
        }
    }

    public ConfigurationLock acquireConfigurationLock() {
        return new ConfigurationLock();
    }

    public ConfigurationLock tryAcquireConfigurationLock(long time, TimeUnit unit) throws InterruptedException, TimeoutException {
        return new ConfigurationLock(time, unit);
    }

    public ConfigurationWriteLock acquireConfigurationWriteLock() {
        return new ConfigurationWriteLock();
    }

    public ConfigurationWriteLock tryAcquireConfigurationWriteLock(long time, TimeUnit unit) throws InterruptedException, TimeoutException {
        return new ConfigurationWriteLock(time, unit);
    }

    public ComponentConfigurationEnvironment getComponentConfigurationEnvironment(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Provided name cannot be null.");
        }
        ComponentConfigurationEnvironment environment = this.keyEnvironmentMap.get(name);
        if (environment == null) {
            throw new IllegalArgumentException("No Component with name \"" + name + "\" containing configuration parameters.");
        }
        return environment;
    }

    public void addConfigurationListener(ConfigurationListener listener) {
        this.configurationListeners.add(listener);
    }

    public void removeConfigurationListener(ConfigurationListener listener) {
        this.configurationListeners.remove(listener);
    }

    private void notifyConfigurationListeners(ConfigurationInfo newConfigurationInfo, ConfigurationInfo oldConfigurationInfo, ConfigurationListener.ConfigurationOperation co) {
        for (ConfigurationListener l : this.configurationListeners) {
            try {
                l.configurationChanged(newConfigurationInfo, oldConfigurationInfo, co);
            }
            catch (Exception e) {
                conf_sub_log.log(Level.WARNING, "ConfigurationListener exception", e);
            }
        }
    }

    private void updateStateAndSendStatusConfigurationInfo(ConfigurationInfo ci, ConfigurationListener.ConfigurationOperation co) {
        this.updateStateAndSendStatusConfigurationInfo(new Options(), ci, co);
    }

    private void updateStateAndSendStatusConfigurationInfo(Options options, ConfigurationInfo ci, ConfigurationListener.ConfigurationOperation co) {
        this.updateStateAndSendStatusConfigurationInfo(options, ci, co, true);
    }

    private void updateStateAndSendStatusConfigurationInfo(ConfigurationInfo ci, ConfigurationListener.ConfigurationOperation co, boolean notifyListeners) {
        this.updateStateAndSendStatusConfigurationInfo(new Options(), ci, co, notifyListeners);
    }

    private void updateStateAndSendStatusConfigurationInfo(Options options, ConfigurationInfo ci, ConfigurationListener.ConfigurationOperation co, boolean notifyListeners) {
        try (ConfigurationWriteLock wlock = this.acquireConfigurationWriteLock();){
            ConfigurationInfo previousConfigurationInfo = this.currentConfigInfo;
            this.currentConfigInfo = ci;
            this.currentView = this.extractConfigurationViewFromConfigurationInfo(this.currentConfigInfo);
            this.stateService.updateInternalState(new AgentState[]{this.currentConfigInfo.getConfigurationState()});
            this.currentDescription = this.currentConfigInfo.getConfigurationDescriptionObject();
            this.baseDescription = this.evaluateBaseDescription(this.currentDescription, this.defaultInitialDescription);
            this.fullConfigurationNeedsUpdating = true;
            if (notifyListeners) {
                this.notifyConfigurationListeners(this.currentConfigInfo, previousConfigurationInfo, co);
            }
            if (this.messagingService.isConnectedToTheBuses() && !options.hasOption(this.doNotPublishOption) && !this.stateService.isInState((Enum)PhaseState.INITIALIZING)) {
                this.publishConfigurationInfo(ConfigurationData.buildConfigurationData((ConfigurationInfo)ci, (List)ci.getLatestChanges(), (String)co.name()));
            }
            conf_sub_log.log(this.agent.getAgentInfo().getType().compareTo((Enum)AgentInfo.AgentType.CONSOLE) > 0 ? Level.INFO : Level.FINE, "Updated configuration description: \n{0}\n", this.getConfigurationDescription(new Options(), new String[0]));
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private byte[] gzipConfigurationData(ConfigurationData data) {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (GZIPOutputStream gzipOut = new GZIPOutputStream(bos);){
                try (ObjectOutputStream oos = new ObjectOutputStream(gzipOut);){
                    oos.writeObject(data);
                    oos.flush();
                }
                byArray = bos.toByteArray();
            }
            return byArray;
        }
        catch (IOException ioe) {
            throw new RuntimeException("Problem serializing the dictionaries.", ioe);
        }
    }

    private ConfigurationDescription evaluateBaseDescription(ConfigurationDescription current, ConfigurationDescription initial) {
        ConfigurationDescription base = new ConfigurationDescription(current.getCategoriesSet());
        for (String category : current.getCategoriesSet()) {
            CategoryDescription initialCategoryDescription = initial.getCategoryTag(category);
            CategoryDescription baseCategoryDescription = new CategoryDescription(category, this.getDefaultSourceForCategory(category));
            CategoryDescription currentCategoryDescription = current.getCategoryTag(category);
            for (SingleCategoryTag tag : currentCategoryDescription.getSingleCategoryTags()) {
                if (!initialCategoryDescription.containsSingleTag(tag)) continue;
                baseCategoryDescription.addOrUpdadateSingleTag(tag);
            }
            base.addCategoryTag(baseCategoryDescription);
        }
        return base;
    }

    public ConfigurationInfo.Builder buildConfigurationInfo(ConfigurationView newView) {
        try (ConfigurationWriteLock wlock = this.acquireConfigurationWriteLock();){
            ConfigurationInfo.Builder builder = this.buildConfigurationInfoInternal(newView, true);
            return builder;
        }
    }

    public ConfigurationInfo.Builder buildConfigurationInfo(ConfigurationView newView, boolean mustBeComplete) {
        try (ConfigurationWriteLock wlock = this.acquireConfigurationWriteLock();){
            ConfigurationInfo.Builder builder = this.buildConfigurationInfoInternal(newView, mustBeComplete);
            return builder;
        }
    }

    private ConfigurationInfo.Builder buildConfigurationInfoInternal(ConfigurationView newView, boolean mustBeComplete) {
        ConfigurationDescription configDesc = newView.getConfigurationDescription();
        ConfigurationDescription fullConfigDesc = ConfigurationDescription.fromConfigurationInfo((ConfigurationInfo)this.currentConfigInfo);
        if (configDesc != null) {
            for (Object category : configDesc.getCategoriesSet()) {
                fullConfigDesc.addCategoryTag(configDesc.getCategoryTag((String)category));
            }
        }
        if (configDesc == null) {
            configDesc = new ConfigurationDescription(this.categories);
        }
        ConfigurationDescription cd = new ConfigurationDescription(this.categories);
        for (String cat : this.currentConfigInfo.getCategorySet()) {
            if (fullConfigDesc.containsCategory(cat)) {
                CategoryDescription categoryTag = fullConfigDesc.getCategoryTag(cat);
                cd.addCategoryTag(categoryTag);
                continue;
            }
            throw new RuntimeException("Should not have got here!");
        }
        ConfigurationInfo.Builder ciBuilder = new ConfigurationInfo.Builder().setDescription(this.descriptionName);
        ConfigurationState nextState = ConfigurationState.CONFIGURED;
        for (Map.Entry entry : ConfigurationInfo.getParameterInfoGroupByCategory((List)this.currentConfigInfo.getAllParameterInfo()).entrySet()) {
            String category = (String)entry.getKey();
            boolean categoryCommitted = configDesc.containsCategory(category);
            boolean dirtyCat = false;
            for (ConfigurationParameterInfo cpi : (List)entry.getValue()) {
                boolean dirtyParm;
                ParameterPath path = ParameterPath.valueOf((String)cpi.getPathName());
                String currentValue = null;
                try {
                    currentValue = newView.getPathValue(path);
                }
                catch (Exception e) {
                    if (!mustBeComplete) continue;
                    throw e;
                }
                if (currentValue == null) continue;
                String configuredValue = categoryCommitted ? currentValue : cpi.getConfiguredValue();
                ciBuilder.addParameter(ParameterPath.valueOf((String)cpi.getPathName()), cpi.getActualType(), cpi.getCategoryName(), cpi.getDescription(), cpi.isFinal(), cpi.isReadOnly(), cpi.isBuild());
                boolean bl = dirtyParm = !cpi.isReadOnly() && !currentValue.equals(configuredValue);
                if (!currentValue.equals(this.currentConfigInfo.getCurrentValueForParameter(path.toString())) || dirtyParm != cpi.isDirty()) {
                    ciBuilder.addRecentChange(path.toString());
                }
                ciBuilder.updateParameter(ParameterPath.valueOf((String)cpi.getPathName()), configuredValue, currentValue, dirtyParm);
                if (!dirtyParm) continue;
                dirtyCat = true;
                nextState = ConfigurationState.DIRTY;
            }
            CategoryDescription categoryTag = cd.getCategoryTag(category);
            categoryTag.setHasChanges(dirtyCat);
        }
        if (!this.canGoToConfigured) {
            nextState = ConfigurationState.UNCONFIGURED;
        }
        return ciBuilder.setConfigurationState(nextState).setCCSTimeStamp(CCSTimeStamp.currentTime()).updateConfigurationDescription(cd.getFullDescriptionName(), cd.getDescriptionName());
    }

    ConfigurationView extractConfigurationViewFromCurrentConfigurationInfo() {
        try (ConfigurationLock rlock = this.acquireConfigurationLock();){
            ConfigurationView configurationView = this.extractConfigurationViewFromConfigurationInfo(this.currentConfigInfo);
            return configurationView;
        }
    }

    ConfigurationView extractConfigurationViewFromConfigurationInfo(ConfigurationInfo ci) {
        try (ConfigurationLock rlock = this.acquireConfigurationLock();){
            ConfigurationView configurationView = this.extractConfigurationViewFromConfigurationInfo(ci, Collections.emptySet());
            return configurationView;
        }
    }

    ConfigurationView extractConfigurationViewFromConfigurationInfo(ConfigurationInfo ci, Set<String> categories) {
        ConfigurationView cv = new ConfigurationView();
        try (ConfigurationLock rlock = this.acquireConfigurationLock();){
            List list = ci.getAllParameterInfo();
            for (ConfigurationParameterInfo cpi : list) {
                String parameterCategory;
                if (!categories.isEmpty() && !categories.contains(parameterCategory = this.configurationHandler.getParameterSet(cpi.getComponentName()).getConfigurationParameterHandler(cpi.getParameterName()).getCategory())) continue;
                cv.putParameterValue(cpi.getComponentName(), cpi.getParameterName(), cpi.getCurrentValue());
            }
        }
        ConfigurationDescription cd = ConfigurationDescription.fromConfigurationInfo((ConfigurationInfo)ci);
        cv.setConfigurationDescription(cd);
        return cv;
    }

    private void checkCategories(Set<String> categories) {
        for (String cat : categories) {
            if (this.categories.contains(cat)) continue;
            throw new IllegalArgumentException("The provided category \"" + cat + "\" does not exist. Valid categories are: " + this.categories);
        }
    }

    private void checkValidStates(boolean failIfNotEM) {
        if (this.configurationHandler == null) {
            throw new IllegalStateException("the configuration service is not initialized yet");
        }
        if (failIfNotEM && !this.agent.isInEngineeringMode()) {
            throw new IllegalStateException("Fine grained configuration actions are accepted only in engineering mode");
        }
    }

    private void checkForSubmittedChanges() {
        if (this.configurationHandler.hasSubmittedChanges()) {
            throw new RuntimeException("A load/save/change operation cannot be performed while there are outstanding uncommitted changes.\nTo view the submitted changes issue the command \"getAllSubmittedChanges\".\nTo allow load/save/change operation you can either commit the submitted changes with \"applySubmittedChanges\" or you can drop them by issuing command \"cancelAllSubmittedChanges\"");
        }
    }

    private String checkForSubmittedChangesForCategories(Options options, Set<String> catSet) {
        String headerText;
        boolean testRun = options.hasOption(this.testRunOption);
        boolean dropChanges = options.hasOption(this.dropChangesOption);
        Map submittedChanges = this.configurationHandler.getSubmittedChangesForCategories(catSet);
        if (submittedChanges.isEmpty()) {
            return null;
        }
        String string = headerText = dropChanges ? "Dropping the following uncommitted changes: \n" : "A load/save/change operation cannot be performed with the following uncommitted parameter changes.\n";
        if (testRun) {
            headerText = "TEST RUN: " + headerText;
        }
        StringBuilder sb = new StringBuilder(headerText);
        for (Map.Entry e : submittedChanges.entrySet()) {
            String category = (String)e.getKey();
            sb.append("\n\tCategory: ").append(category).append("\n");
            Map changesForCategory = (Map)e.getValue();
            for (Map.Entry e1 : changesForCategory.entrySet()) {
                sb.append("\t").append(e1.getKey()).append("=").append((String)e1.getValue()).append("\n");
            }
        }
        if (testRun) {
            return sb.toString();
        }
        if (dropChanges) {
            this.configurationHandler.dropSubmittedChangesForCategories(catSet);
            return sb.toString();
        }
        throw new RuntimeException(sb.toString());
    }

    private void handleException(RuntimeException ex, ConfigurationListener.ConfigurationOperation co) {
        if (!co.equals((Object)ConfigurationListener.ConfigurationOperation.LOAD)) {
            ConfigurationView view = this.configurationHandler.getLiveConfigurationView();
            this.updateStateAndSendStatusConfigurationInfo(this.buildConfigurationInfo(view).build(), co);
        }
        if (ex instanceof ConfigurationServiceException) {
            this.alertService.raiseAlert(CS_ALERT_1, AlertState.ALARM, ex.getMessage());
        } else if (ex instanceof BulkSettingException) {
            this.alertService.raiseAlert(CS_ALERT_2, AlertState.ALARM, ex.getMessage());
        }
        throw ex;
    }

    public List<ConfigurationParameterHandler> getCategoryParameters(String category) {
        try (ConfigurationLock rlock = this.acquireConfigurationLock();){
            ArrayList result = new ArrayList(this.configurationHandler.getCategoryHandler(category).getParameters());
            List<ConfigurationParameterHandler> list = Collections.unmodifiableList(result);
            return list;
        }
    }

    public ConfigurationParameterHandler getParameterByPath(ParameterPath path) {
        ConfigurationLock rlock = this.acquireConfigurationLock();
        try {
            ConfigurationParameterHandler configurationParameterHandler = this.configurationHandler.getParameterSet(path.getComponentName()).getConfigurationParameterHandler(path.getParameterName());
            if (rlock != null) {
                rlock.close();
            }
            return configurationParameterHandler;
        }
        catch (Throwable throwable) {
            try {
                if (rlock != null) {
                    try {
                        rlock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException("Problem fetching parameter for path " + path.toString(), e);
            }
        }
    }

    public boolean saveInitialConfiguration() {
        return this.saveInitialConfiguration;
    }

    public ConfigurationView getInitialView() {
        ConfigurationView result = new ConfigurationView();
        if (this.initialView != null) {
            result.putAll(this.initialView);
        }
        return result;
    }

    public ConfigurationDAOWrapper getConfigurationDAOWrapper() {
        return this.configurationDao;
    }

    public static Type convertTypeNameToType(String typeName) {
        boolean isArray;
        if (typeName.startsWith("class ")) {
            typeName = typeName.replace("class ", "");
        }
        if (isArray = typeName.endsWith("[]")) {
            typeName = typeName.replace("[]", "");
        }
        try {
            JavaType t = TypeFactory.defaultInstance().constructFromCanonical(typeName);
            return ConfigurationService.convertJavaType(t, isArray);
        }
        catch (Exception t) {
            try {
                Class<?> c = Class.forName(typeName);
                return c;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    static Type convertJavaType(JavaType t, boolean isArray) {
        if (isArray) {
            return Array.newInstance(t.getRawClass(), 0).getClass();
        }
        if (t.containedTypeCount() == 0) {
            return t.getRawClass();
        }
        return new ConvertedParameterizedType(t);
    }

    @Override
    public void dataProviderDictionaryUpdate(DataProviderDictionaryService.DataProviderDictionaryEvent evt) {
        String origin;
        if (evt.getEventType() == DataProviderDictionaryService.DataProviderDictionaryEvent.EventType.ADDED && this.buildClientConfigurationInfo && !this.staticConfigurationInfoMap.containsKey(origin = evt.getAgentInfo().getName())) {
            DataProviderDictionary dict = evt.getDictionary();
            ConfigurationInfo.Builder builder = new ConfigurationInfo.Builder();
            for (DataProviderInfo dpi : dict.getDataProviderInfos()) {
                if (!dpi.getAttributeValue(DataProviderInfo.Attribute.DATA_TYPE).equals(DataProviderInfo.Type.CONFIGURATION.name())) continue;
                ConfigurationParameterType configParType = ConfigurationParameterType.valueOf((String)dpi.getAttributeValue(DataProviderInfo.Attribute.CONFIG_TYPE));
                String fullPath = dpi.getFullPath();
                if (!fullPath.contains("/") && !fullPath.startsWith("/")) {
                    fullPath = "/" + fullPath;
                }
                ParameterPath pp = ParameterPath.valueOf((String)fullPath);
                String category = dpi.getAttributeValue(DataProviderInfo.Attribute.CONFIG_CATEGORY);
                String description = dpi.getAttributeValue(DataProviderInfo.Attribute.DESCRIPTION);
                String type = dpi.getAttributeValue(DataProviderInfo.Attribute.TYPE);
                Type t = ConfigurationService.convertTypeNameToType(type);
                builder.addParameter(pp, t, category, description, configParType == ConfigurationParameterType.FINAL, configParType == ConfigurationParameterType.READ_ONLY, configParType == ConfigurationParameterType.BUILD);
            }
            this.staticConfigurationInfoMap.put(origin, builder.build());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BusMessage preProcessMessage(BusMessage msg) {
        AgentInfo ai = msg.getOriginAgentInfo();
        String name = ai.getName();
        Object object = this.messageProcessing;
        synchronized (object) {
            if (msg instanceof StatusConfigurationData) {
                long startPreProcess = System.currentTimeMillis();
                String origin = msg.getOriginAgentInfo().getName();
                if (this.buildClientConfigurationInfo && !this.staticConfigurationInfoMap.containsKey(origin)) {
                    try {
                        this.dataDictionaryService.waitForAgentDictionary(ai, 1L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                long deltaWait = System.currentTimeMillis() - startPreProcess;
                conf_sub_log.log(Level.FINE, "*** Waiting for agent dictionary took {0} ms for agent {1}", new Object[]{deltaWait, name});
                ConfigurationInfo clientConfigInfo = this.staticConfigurationInfoMap.get(origin);
                if (clientConfigInfo != null) {
                    boolean onlyStaticInformation;
                    StatusConfigurationData statusConfigData = (StatusConfigurationData)msg;
                    boolean hasConfigInfoToPublish = false;
                    boolean bl = onlyStaticInformation = clientConfigInfo.getConfigurationDescription() == null;
                    if (onlyStaticInformation) {
                        if (statusConfigData.isFullDataPublication()) {
                            long startFullPublication = System.currentTimeMillis();
                            ConfigurationData configData = statusConfigData.getConfigurationData();
                            this.updateConfigurationInfoFromConfigurationData(clientConfigInfo, configData);
                            hasConfigInfoToPublish = true;
                            long delta = System.currentTimeMillis() - startFullPublication;
                            conf_sub_log.log(Level.FINE, "*** Filling full publication took {0} ms for agent {1}", new Object[]{delta, name});
                        }
                    } else {
                        ConfigurationData configData = statusConfigData.getConfigurationData();
                        long startPartialFill = System.currentTimeMillis();
                        this.updateConfigurationInfoFromConfigurationData(clientConfigInfo, configData);
                        hasConfigInfoToPublish = true;
                        long delta = System.currentTimeMillis() - startPartialFill;
                        conf_sub_log.log(Level.FINE, "*** Filling partial publication took {0} ms for agent {1}", new Object[]{delta, name});
                    }
                    if (hasConfigInfoToPublish) {
                        StatusConfigurationInfo statusInfo = new StatusConfigurationInfo(clientConfigInfo);
                        StateBundle sb = ((StatusConfigurationData)msg).getState();
                        if (sb != null) {
                            statusInfo.setState(sb);
                        }
                        long delta = System.currentTimeMillis() - startPreProcess;
                        conf_sub_log.log(Level.FINE, "*** Overall preProcessing of ConfigurationData took {0} ms to return object for agent {1}", new Object[]{delta, name});
                        return statusInfo;
                    }
                }
                long delta = System.currentTimeMillis() - startPreProcess;
                conf_sub_log.log(Level.FINE, "*** Overall preProcessing of ConfigurationData took {0} ms to return null for agent {1}", new Object[]{delta, name});
                return null;
            }
        }
        return msg;
    }

    private synchronized ConfigurationInfo updateConfigurationInfoFromConfigurationData(ConfigurationInfo ci, ConfigurationData configData) {
        ConfigurationInfo.Builder builder = new ConfigurationInfo.Builder(ci);
        builder.updateConfigurationDescription(configData.getFullConfigurationDescription(), configData.getConfigurationDescription());
        builder.setConfigurationState(configData.getConfigurationState());
        builder.setCCSTimeStamp(configData.getCCSTimeStamp());
        builder.setRecentChanges(configData.getLatestChanges());
        for (String configPath : configData.getCurrentValues().keySet()) {
            String currentValue = (String)configData.getCurrentValues().get(configPath);
            String configuredValue = (String)configData.getConfiguredValues().get(configPath);
            boolean isDirty = configuredValue != null;
            builder.updateParameter(ParameterPath.valueOf((String)configPath), isDirty ? configuredValue : currentValue, currentValue, isDirty);
        }
        for (String category : configData.getCategories()) {
            builder.updateCategoryChecksum(category, Long.valueOf(configData.getCategoryChecksum(category)));
        }
        return ci;
    }

    public Bus getBus() {
        return Bus.STATUS;
    }

    public void disconnected(AgentInfo ... agents) {
        if (this.buildClientConfigurationInfo) {
            for (AgentInfo a : agents) {
                this.staticConfigurationInfoMap.remove(a.getName());
            }
        }
    }

    public String getDefaultSourceForCategory(String category) {
        String catSpecificDef = this.defaultCategorySources.computeIfAbsent(category, cat -> SingleCategoryTag.getDefaultSourceForCategory((String)category));
        return catSpecificDef;
    }

    public final void requestConfigurationDataIfNeededForAgent(String agentName) {
        if (!this.staticConfigurationInfoMap.containsKey(agentName)) {
            CommandRequest dataPublicationRequest = new CommandRequest(agentName, "publishConfigurationInfo");
            this.cmu.sendAsynchronousCommand(dataPublicationRequest);
        } else {
            this.agent.getScheduler().execute(() -> {
                Object object = this.messageProcessing;
                synchronized (object) {
                    ConfigurationInfo clientConfigInfo = this.staticConfigurationInfoMap.get(agentName);
                    if (clientConfigInfo != null) {
                        StatusConfigurationInfo statusInfo = new StatusConfigurationInfo(clientConfigInfo);
                        StateBundle sb = this.stateService.getStateBundleForAgent(agentName);
                        if (sb != null) {
                            statusInfo.setState(sb);
                        }
                        AgentInfo ai = null;
                        for (AgentInfo info : this.messagingService.getMessagingAccess().getAgentPresenceManager().listConnectedAgents()) {
                            if (!info.getName().equals(agentName)) continue;
                            ai = info;
                            break;
                        }
                        if (ai != null) {
                            statusInfo.setOriginAgentInfo(ai);
                            this.agent.getMessagingAccess().getApplicationLayer().getMessagingAccessLayer().getBusAccess(Bus.STATUS).processBusMessage((BusMessage)statusInfo);
                        }
                    }
                }
            });
        }
    }

    public class ConfigurationLock
    implements AutoCloseable {
        public final Lock readLock;

        private ConfigurationLock(long time, TimeUnit unit) throws InterruptedException, TimeoutException {
            this.readLock = ConfigurationService.this.configLock.readLock();
            if (!this.readLock.tryLock(time, unit)) {
                throw new TimeoutException("Could not acquire a reader lock within the given time.");
            }
        }

        private ConfigurationLock() {
            this.readLock = ConfigurationService.this.configLock.readLock();
            this.readLock.lock();
        }

        @Override
        public void close() {
            this.readLock.unlock();
        }
    }

    public class ConfigurationWriteLock
    implements AutoCloseable {
        public final Lock writeLock;

        private ConfigurationWriteLock(long time, TimeUnit unit) throws InterruptedException, TimeoutException {
            this.writeLock = ConfigurationService.this.configLock.writeLock();
            if (!this.writeLock.tryLock(time, unit)) {
                throw new TimeoutException("Could not acquire a writer lock within the given time.");
            }
        }

        private ConfigurationWriteLock() {
            this.writeLock = ConfigurationService.this.configLock.writeLock();
            this.writeLock.lock();
        }

        @Override
        public void close() {
            this.writeLock.unlock();
        }
    }

    public static class ConvertedParameterizedType
    implements ParameterizedType {
        private final Type[] actualTypeArguments;
        private final Type rawType;
        private final String toString;

        ConvertedParameterizedType(JavaType type) {
            this.rawType = type.getRawClass();
            this.actualTypeArguments = new Type[type.containedTypeCount()];
            for (int i = 0; i < type.containedTypeCount(); ++i) {
                this.actualTypeArguments[i] = ConfigurationService.convertJavaType(type.containedType(i), false);
            }
            StringBuilder sb = new StringBuilder(this.rawType.getTypeName());
            int nTypes = this.actualTypeArguments.length;
            if (nTypes > 0) {
                sb.append("<");
            }
            int count = 0;
            for (Type t : this.actualTypeArguments) {
                sb.append(t.getTypeName());
                if (++count >= nTypes) continue;
                sb.append(",");
            }
            if (nTypes > 0) {
                sb.append(">");
            }
            this.toString = sb.toString();
        }

        @Override
        public Type[] getActualTypeArguments() {
            return this.actualTypeArguments;
        }

        @Override
        public Type getOwnerType() {
            return this.rawType;
        }

        @Override
        public Type getRawType() {
            return this.rawType;
        }

        public String toString() {
            return this.toString;
        }
    }
}

