/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.demo.gui.configurationview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.subsystem.demo.gui.configurationview.ButtonTabComponent;
import org.lsst.ccs.subsystem.demo.gui.configurationview.SubsystemConfigurationViewPanel;

public class SubsystemConfigurationViewTopPanel
extends JPanel {
    private static final long serialVersionUID = 1249803483389190647L;
    private final AgentMessagingLayer aml;
    private final JComboBox<String> subsystemList = new JComboBox();
    private final JButton refresh = new JButton("refresh");
    private final JTabbedPane tabbedPane = new JTabbedPane();

    public SubsystemConfigurationViewTopPanel(AgentMessagingLayer aml) {
        super(new BorderLayout());
        this.aml = aml;
        this.subsystemList.addActionListener(ae -> this.openConfigurationPane((String)this.subsystemList.getSelectedItem()));
        this.updateSubsystemList();
        this.refresh.addActionListener(ae -> this.updateSubsystemList());
        JPanel head = new JPanel(new FlowLayout());
        head.add(this.subsystemList);
        head.add(this.refresh);
        this.add((Component)head, "North");
        this.add((Component)this.tabbedPane, "Center");
    }

    private void updateSubsystemList() {
        this.subsystemList.removeAllItems();
        this.subsystemList.addItem(null);
        List l = this.aml.getAgentPresenceManager().listConnectedAgents();
        for (AgentInfo ai : l) {
            if (ai.getType() != AgentInfo.AgentType.WORKER) continue;
            this.subsystemList.addItem(ai.getName());
        }
    }

    private void openConfigurationPane(String name) {
        if (name == null) {
            return;
        }
        Integer index = this.tabbedPane.indexOfTab(name);
        if (index < 0) {
            SubsystemConfigurationViewPanel comp = new SubsystemConfigurationViewPanel(this.aml, name);
            this.tabbedPane.add(name, comp);
            index = this.tabbedPane.indexOfComponent(comp);
            ButtonTabComponent btc = new ButtonTabComponent(this.tabbedPane);
            this.tabbedPane.setTabComponentAt(index, new ButtonTabComponent(this.tabbedPane));
            comp.initGui();
        }
        this.tabbedPane.setSelectedIndex(index);
    }
}

