/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.services.aggregator;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.AgentLock;
import org.lsst.ccs.bus.data.AgentLockInfo;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.bus.states.StateBundle;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.filter.AgentChannelsFilter;
import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;
import org.lsst.ccs.gconsole.services.aggregator.AgentHandle;
import org.lsst.ccs.gconsole.services.aggregator.AgentStatusListener;
import org.lsst.ccs.gconsole.services.aggregator.ChannelSelector;
import org.lsst.ccs.gconsole.services.aggregator.MutableAgentStatusEvent;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.services.AgentLockService;
import org.lsst.ccs.services.AgentLoginService;
import org.lsst.ccs.services.DataProviderDictionaryService;
import org.lsst.ccs.utilities.logging.Logger;

public class AgentStatusAggregator {
    final ThreadPoolExecutor exec;
    final ArrayList<GlobalListenerHandle> listeners = new ArrayList(0);
    volatile Logger logger;
    private final AgentPresenceListener agentPresenceListener;
    private final StatusMessageListener statusMessageListener;
    private final DataProviderDictionaryService.DataProviderDictionaryListener dictionaryListener;
    private final AgentLockService.AgentLockUpdateListener lockListener;
    private final AgentLoginService.AgentLoginUpdateListener loginListener;
    private final ConcurrentHashMap<String, Instant> times = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, AgentHandle> agentHandles = new ConcurrentHashMap();

    public AgentStatusAggregator() {
        ThreadFactory threadFactory = run -> {
            Thread thread = new Thread(run, "AgentStatusAggregator");
            thread.setDaemon(true);
            return thread;
        };
        this.exec = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue(), threadFactory){

            @Override
            public void execute(Runnable command) {
                try {
                    super.execute(command);
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    // empty catch block
                }
            }
        };
        this.agentPresenceListener = new AgentPresenceListener(){

            public void disconnected(AgentInfo ... agents) {
                AgentStatusAggregator.this.exec.execute(() -> {
                    for (AgentInfo agent : agents) {
                        if (AgentStatusAggregator.this.ignoreAgent(agent)) continue;
                        AgentStatusAggregator.this.processDisconnect(agent.getName());
                    }
                });
            }
        };
        this.statusMessageListener = message -> {
            AgentInfo info = message.getOriginAgentInfo();
            if (!this.ignoreAgent(info)) {
                String agentName = message.getOriginAgentInfo().getName();
                this.times.put(agentName, Instant.now());
                this.exec.execute(() -> this.processStatusMessage(message));
            }
        };
        this.dictionaryListener = e -> {
            if (e.getEventType() == DataProviderDictionaryService.DataProviderDictionaryEvent.EventType.ADDED && !this.ignoreAgent(e.getAgentInfo())) {
                this.exec.execute(() -> this.processDictionaryEvent(e));
            }
        };
        this.lockListener = new AgentLockService.AgentLockUpdateListener(){

            public void onAgentHeldLockUpdate(String agentName, AgentLock lock) {
                AgentStatusAggregator.this.exec.execute(() -> {
                    AgentHandle handle = (AgentHandle)AgentStatusAggregator.this.agentHandles.get(agentName);
                    if (handle != null) {
                        handle.onLockEvent(lock);
                    }
                });
            }

            public void onGlobalLockUpdate(String agentName, String owner, AgentLock lock) {
                if (lock instanceof AgentLockInfo) {
                    switch (((AgentLockInfo)lock).getStatus()) {
                        case RELEASED: 
                        case REJECTED: {
                            lock = null;
                            break;
                        }
                        case REQUESTED: {
                            return;
                        }
                    }
                }
                AgentLock theLock = lock;
                AgentStatusAggregator.this.exec.execute(() -> {
                    AgentHandle handle = (AgentHandle)AgentStatusAggregator.this.agentHandles.get(agentName);
                    if (handle != null) {
                        handle.onLockEvent(theLock);
                    }
                });
            }
        };
        this.loginListener = new AgentLoginService.AgentLoginUpdateListener(){

            public void onAgentLoginUpdate(String oldUserId, String newUserId) {
                if (!Objects.equals(oldUserId, newUserId)) {
                    AgentStatusAggregator.this.exec.execute(() -> AgentStatusAggregator.this.agentHandles.values().forEach(handle -> handle.onLoginEvent(newUserId)));
                }
            }
        };
    }

    public void initialize() {
        Console agent = Console.getConsole();
        this.logger = agent.getLogger();
        AgentMessagingLayer messagingAccess = agent.getMessagingAccess();
        messagingAccess.addStatusMessageListener(this.statusMessageListener);
        messagingAccess.getAgentPresenceManager().addAgentPresenceListener(this.agentPresenceListener);
        ((DataProviderDictionaryService)agent.getAgentService(DataProviderDictionaryService.class)).addDataProviderDictionaryListener(this.dictionaryListener);
        ((AgentLockService)agent.getAgentService(AgentLockService.class)).addAgentLockUpdateListener(this.lockListener);
        ((AgentLoginService)agent.getAgentService(AgentLoginService.class)).addAgentLoginUpdateListener(this.loginListener);
    }

    public void shutdown() {
        this.exec.shutdownNow();
    }

    public List<AgentInfo> getAgents() {
        return this.agentHandles.values().stream().map(a -> a.getAgent()).collect(Collectors.toList());
    }

    public AgentInfo getAgent(String agentName) {
        AgentHandle data = this.agentHandles.get(agentName);
        return data == null ? null : data.getAgent();
    }

    public boolean hasAgent(String agentName) {
        return this.agentHandles.get(agentName) != null;
    }

    public List<AgentChannel> getDictionaryChannels(List<String> agents, List<String> channelSelectors) {
        List<ChannelSelector> selectors = ChannelSelector.compile(channelSelectors);
        ArrayList<AgentChannel> out = new ArrayList<AgentChannel>();
        for (AgentHandle agentHandle : this.agentHandles.values()) {
            List<AgentChannel> channels = agentHandle.getDictionaryChannels();
            ChannelSelector.filter(agents, selectors, channels, out);
        }
        return out;
    }

    public AgentChannel getChannel(String path) {
        int i = path.indexOf("/");
        if (i == -1) {
            return null;
        }
        String agentName = path.substring(0, i);
        AgentHandle agentHandle = this.agentHandles.get(agentName);
        return agentHandle == null ? null : agentHandle.getChannel(path);
    }

    public StateBundle getAgentState(String agentName) {
        AgentHandle agentHandle = this.agentHandles.get(agentName);
        return agentHandle == null ? null : agentHandle.getState();
    }

    public void addListener(AgentStatusListener listener, AgentChannelsFilter filter) {
        this.addListener(listener, filter.getAgents(), filter.getOriginChannels());
    }

    public void addListener(AgentStatusListener listener, Collection<String> agents, Collection<String> channels) {
        ArrayList<String> finalAgents = agents == null ? null : new ArrayList<String>(agents);
        ArrayList<String> finalChannels = channels == null ? null : new ArrayList<String>(channels);
        this.exec.submit(() -> this.executeAddListener(listener, finalAgents, finalChannels));
    }

    public void removeListener(AgentStatusListener listener) {
        this.exec.submit(() -> this.executeRemoveListener(listener));
    }

    private void executeAddListener(AgentStatusListener listener, List<String> agents, List<String> channels) {
        GlobalListenerHandle globalHandle = new GlobalListenerHandle(listener, agents, channels);
        this.listeners.add(globalHandle);
        MutableAgentStatusEvent event = new MutableAgentStatusEvent(this);
        for (AgentHandle agentHandle : this.agentHandles.values()) {
            agentHandle.addListener(globalHandle, event);
        }
        if (!event.isEmpty()) {
            event.validate();
            try {
                listener.configure(event);
            }
            catch (RuntimeException x) {
                Console.getConsole().getLogger().warn((Object)("Error processing status aggregator event by " + listener.getClass()), (Throwable)x);
            }
        }
    }

    private void executeRemoveListener(AgentStatusListener listener) {
        Set removed = Collections.newSetFromMap(new IdentityHashMap());
        Iterator<GlobalListenerHandle> it = this.listeners.iterator();
        while (it.hasNext()) {
            GlobalListenerHandle global = it.next();
            if (global.listener != listener) continue;
            it.remove();
            if (removed.contains(global)) continue;
            removed.add(global);
            for (AgentHandle agentHandle : this.agentHandles.values()) {
                agentHandle.removeListener(global);
            }
        }
    }

    private void processStatusMessage(StatusMessage message) {
        AgentInfo agentInfo = message.getOriginAgentInfo();
        String agentName = agentInfo.getName();
        if (message.getState().isInState((Enum)PhaseState.OFF_LINE)) {
            this.processDisconnect(agentName);
            return;
        }
        AgentHandle agentHandle = this.agentHandles.get(agentName);
        if (agentHandle == null) {
            agentHandle = new AgentHandle(agentInfo, this);
            this.agentHandles.put(agentName, agentHandle);
        }
        agentHandle.onMessage(message);
    }

    private void processDisconnect(String agentName) {
        AgentHandle agentHandle = this.agentHandles.remove(agentName);
        if (agentHandle != null) {
            agentHandle.onDisconnect();
        }
    }

    private void processDictionaryEvent(DataProviderDictionaryService.DataProviderDictionaryEvent e) {
        AgentInfo agent = e.getAgentInfo();
        AgentHandle agentHandle = this.agentHandles.get(agent.getName());
        if (agentHandle == null) {
            agentHandle = new AgentHandle(agent, this);
            this.agentHandles.put(agent.getName(), agentHandle);
        }
        agentHandle.onDictionary(e.getDictionary());
    }

    private boolean ignoreAgent(AgentInfo agent) {
        return agent == null || agent.getName() == null || agent.getType() == AgentInfo.AgentType.CONSOLE || agent.getType() == AgentInfo.AgentType.LISTENER;
    }

    final class GlobalListenerHandle {
        final AgentStatusListener listener;
        final List<String> agents;
        final List<ChannelSelector> channelSelectors;

        GlobalListenerHandle(AgentStatusListener listener, List<String> agents, List<String> channels) {
            this.listener = listener;
            this.agents = agents;
            this.channelSelectors = ChannelSelector.compile(channels);
        }
    }
}

