/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.trending;

import java.awt.Component;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import org.lsst.ccs.gconsole.base.Const;

public class ApplyDialog {
    private final Set<What> what;
    private final Where where;

    private ApplyDialog(Set<What> what, Where where) {
        this.what = what;
        this.where = where;
    }

    public static ApplyDialog apply(Component parent) {
        ApplyDialog out;
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setAlignmentX(0.0f);
        Box row = Box.createHorizontalBox();
        row.setAlignmentX(0.0f);
        row.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(" Apply "), BorderFactory.createEmptyBorder(5, 10, 5, 10)));
        JCheckBox rangeBox = new JCheckBox("Time Range");
        rangeBox.setSelected(true);
        row.add(rangeBox);
        row.add(Box.createRigidArea(Const.HDIM));
        JCheckBox typeBox = new JCheckBox("Data type");
        row.add(typeBox);
        row.add(Box.createHorizontalGlue());
        panel.add(row);
        rangeBox.addActionListener(e -> {
            if (!rangeBox.isSelected()) {
                typeBox.setSelected(true);
            }
        });
        typeBox.addActionListener(e -> {
            if (!typeBox.isSelected()) {
                rangeBox.setSelected(true);
            }
        });
        row = Box.createHorizontalBox();
        row.setAlignmentX(0.0f);
        row.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(" To "), BorderFactory.createEmptyBorder(5, 10, 5, 10)));
        ButtonGroup group = new ButtonGroup();
        JRadioButton plotRadio = new JRadioButton("Plot");
        group.add(plotRadio);
        row.add(plotRadio);
        row.add(Box.createRigidArea(Const.HDIM));
        JRadioButton pageRadio = new JRadioButton("Page");
        group.add(pageRadio);
        row.add(pageRadio);
        row.add(Box.createRigidArea(Const.HDIM));
        JRadioButton allRadio = new JRadioButton("All");
        group.add(allRadio);
        row.add(allRadio);
        pageRadio.setSelected(true);
        row.add(Box.createHorizontalGlue());
        panel.add(row);
        int response = JOptionPane.showConfirmDialog(parent, panel, "Apply time range and/or data type settings", 2, -1);
        if (response == 0) {
            EnumSet<What> what = EnumSet.noneOf(What.class);
            if (rangeBox.isSelected()) {
                what.add(What.TIME_RANGE);
            }
            if (typeBox.isSelected()) {
                what.add(What.DATA_TYPE);
            }
            Where where = plotRadio.isSelected() ? Where.PLOT : (pageRadio.isSelected() ? Where.PAGE : Where.ALL);
            out = new ApplyDialog(what, where);
        } else {
            out = new ApplyDialog(null, null);
        }
        return out;
    }

    public Set<What> getWhat() {
        return Collections.unmodifiableSet(this.what);
    }

    public Where getWhere() {
        return this.where;
    }

    public boolean isCancelled() {
        return this.what == null;
    }

    public String toString() {
        return "Apply " + this.what + " to " + (Object)((Object)this.where) + ".";
    }

    public static void main(String ... args) {
        SwingUtilities.invokeLater(() -> {
            ApplyDialog tw;
            do {
                tw = ApplyDialog.apply(null);
                System.out.println(tw);
            } while (!tw.isCancelled());
        });
    }

    public static enum Where {
        PLOT,
        PAGE,
        ALL;

    }

    public static enum What {
        TIME_RANGE,
        DATA_TYPE;

    }
}

