/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.services;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.lsst.ccs.bus.data.DataProviderDictionary;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

class DataProviderDictionaryImpl
implements DataProviderDictionary {
    private static final long serialVersionUID = 5717561561765845L;
    @Deprecated
    private final Map<String, List<DataProviderInfo>> groups = new HashMap<String, List<DataProviderInfo>>();
    private final Map<String, DataProviderInfo> pathMap = new HashMap<String, DataProviderInfo>();
    private final List<DataProviderInfo> dataProviderInfos = new ArrayList<DataProviderInfo>();
    @Deprecated
    private final transient CCSTimeStamp ccsTimeStamp = null;
    private static final Logger LOG = Logger.getLogger(DataProviderDictionaryImpl.class.getName());

    DataProviderDictionaryImpl() {
    }

    void addDataProviderInfo(DataProviderInfo dpd) {
        String path;
        String group;
        List<DataProviderInfo> l;
        if (!this.dataProviderInfos.contains(dpd)) {
            this.dataProviderInfos.add(dpd);
        }
        if ((l = this.groups.get(group = dpd.getPath())) == null) {
            l = new ArrayList<DataProviderInfo>();
            this.groups.put(group, l);
        }
        if (!l.contains(dpd)) {
            l.add(dpd);
        }
        if (this.pathMap.containsKey(path = dpd.getFullPath())) {
            if (!dpd.equals((Object)this.pathMap.get(path))) {
                throw new RuntimeException("Cannot register DataProviderInfo for " + path + " " + dpd + ". One entry for that path already exists: " + this.pathMap.get(path));
            }
        } else {
            this.pathMap.put(path, dpd);
        }
    }

    @Deprecated
    public List<DataProviderInfo> getDataProviderDescriptionsForGroup(String group) {
        return this.groups.get(group);
    }

    @Deprecated
    public Set<String> getGroups() {
        HashSet<String> result = new HashSet<String>();
        result.addAll(this.groups.keySet());
        return result;
    }

    public List<DataProviderInfo> getDataProviderInfos() {
        return this.dataProviderInfos;
    }

    @Deprecated
    public CCSTimeStamp getCCSTimeStamp() {
        return CCSTimeStamp.currentTime();
    }

    public DataProviderInfo getDataProviderInfoForPath(String path) {
        return this.pathMap.get(path);
    }
}

