/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.AbstractDict;
import org.python.core.ArgParser;
import org.python.core.Py;
import org.python.core.PyDictProxy;
import org.python.core.PyList;
import org.python.core.PyModule$PyExposer;
import org.python.core.PyModuleDerived;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PySystemState;
import org.python.core.PyType;
import org.python.core.Traverseproc;
import org.python.core.Visitproc;
import org.python.core.imp;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;

@ExposedType(name="module")
public class PyModule
extends PyObject
implements Traverseproc {
    private final PyObject moduleDoc = new PyString("module(name[, doc])\n\nCreate a module object.\nThe name must be a string; the optional doc argument can have any type.");
    public PyObject __dict__;

    public PyModule() {
    }

    public PyModule(PyType subType) {
        super(subType);
    }

    public PyModule(PyType subType, String name) {
        super(subType);
        this.module___init__(new PyString(name), Py.None);
    }

    public PyModule(String name) {
        this(name, null);
    }

    public PyModule(String name, PyObject dict) {
        this.__dict__ = dict;
        this.module___init__(new PyString(name), Py.None);
    }

    @ExposedNew
    final void module___init__(PyObject[] args, String[] keywords) {
        ArgParser ap = new ArgParser("__init__", args, keywords, new String[]{"name", "doc"});
        PyObject name = ap.getPyObject(0);
        PyObject docs = ap.getPyObject(1, Py.None);
        this.module___init__(name, docs);
    }

    private void module___init__(PyObject name, PyObject doc) {
        this.ensureDict();
        this.__dict__.__setitem__("__name__", name);
        this.__dict__.__setitem__("__doc__", doc);
        if (name.equals(new PyString("__main__"))) {
            this.__dict__.__setitem__("__builtins__", Py.getSystemState().modules.__finditem__("__builtin__"));
            this.__dict__.__setitem__("__package__", Py.None);
        }
    }

    @Override
    public PyObject fastGetDict() {
        return this.__dict__;
    }

    @Override
    public PyObject getDict() {
        return this.__dict__;
    }

    @Override
    public void setDict(PyObject newDict) {
        throw Py.TypeError("readonly attribute");
    }

    @Override
    public void delDict() {
        throw Py.TypeError("readonly attribute");
    }

    @Override
    protected PyObject impAttr(String name) {
        String fullName = this.getFullName(name);
        if (fullName != null) {
            PyObject attr = this.findSubModule(name, fullName);
            if (attr == null) {
                attr = PySystemState.packageManager.lookupName(fullName);
            }
            return this.addedSubModule(name, fullName, attr);
        }
        return null;
    }

    private PyObject findSubModule(String name, String fullName) {
        PyObject attr = null;
        if (fullName != null && (attr = Py.getSystemState().modules.__finditem__(fullName)) == null) {
            PyObject path = this.__dict__.__finditem__("__path__");
            if (path == null) {
                attr = imp.find_module(name, fullName, new PyList());
            } else if (path instanceof PyList) {
                attr = imp.find_module(name, fullName, (PyList)path);
            } else if (path != Py.None) {
                throw Py.TypeError("__path__ must be list or None");
            }
        }
        return attr;
    }

    private PyObject addedSubModule(String name, String fullName, PyObject attr) {
        if (attr != null) {
            PyObject entry;
            if (fullName != null && (entry = Py.getSystemState().modules.__finditem__(fullName)) != null) {
                attr = entry;
            }
            this.__dict__.__setitem__(name, attr);
        }
        return attr;
    }

    private String getFullName(String name) {
        PyObject pyName;
        if (this.__dict__ != null && (pyName = this.__dict__.__finditem__("__name__")) != null && name != null && name.length() > 0) {
            return (pyName.__str__().toString() + '.' + name).intern();
        }
        return null;
    }

    @Override
    public PyObject __findattr_ex__(String name) {
        String fullName;
        PyObject attr = super.__findattr_ex__(name);
        if (attr == null && (fullName = this.getFullName(name)) != null) {
            attr = PySystemState.packageManager.lookupName(fullName);
            attr = this.addedSubModule(name, fullName, attr);
        }
        return attr;
    }

    @Override
    public void __setattr__(String name, PyObject value) {
        this.module___setattr__(name, value);
    }

    final void module___setattr__(String name, PyObject value) {
        if (name != "__dict__") {
            this.ensureDict();
        }
        super.__setattr__(name, value);
    }

    @Override
    public void __delattr__(String name) {
        this.module___delattr__(name);
    }

    final void module___delattr__(String name) {
        super.__delattr__(name);
    }

    @Override
    public String toString() {
        return this.module_toString();
    }

    final String module_toString() {
        PyObject name = null;
        PyObject filename = null;
        if (this.__dict__ != null) {
            name = this.__dict__.__finditem__("__name__");
            filename = this.__dict__.__finditem__("__file__");
        }
        if (name == null) {
            name = new PyString("?");
        }
        if (filename == null) {
            return String.format("<module '%s' (built-in)>", name);
        }
        return String.format("<module '%s' from '%s'>", name, filename);
    }

    @Override
    public PyObject __dir__() {
        PyObject d = this instanceof PyModuleDerived ? this.__findattr_ex__("__dict__") : this.__dict__;
        if (d == null || !(d instanceof AbstractDict) && !(d instanceof PyDictProxy)) {
            throw Py.TypeError(String.format("%.200s.__dict__ is not a dictionary", this.getType().fastGetName().toLowerCase()));
        }
        return d.invoke("keys");
    }

    private void ensureDict() {
        if (this.__dict__ == null) {
            this.__dict__ = new PyStringMap();
        }
    }

    public <T> T newJ(Class<T> jcls, Object ... args) {
        return Py.newJ(this, jcls, args);
    }

    public <T> T newJ(Class<T> jcls, String[] keywords, Object ... args) {
        return Py.newJ(this, jcls, keywords, args);
    }

    @Override
    public int traverse(Visitproc visit, Object arg) {
        return this.__dict__ == null ? 0 : visit.visit(this.__dict__, arg);
    }

    @Override
    public boolean refersDirectlyTo(PyObject ob) {
        return ob != null && ob == this.__dict__;
    }

    static {
        PyType.addBuilder(PyModule.class, new PyModule$PyExposer());
    }
}

