/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.demo.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Future;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.ConfigurationParameterInfo;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.utilities.logging.Logger;

public class DemoConfigurableSubsystemParameterGenericGUI
extends JPanel {
    private final Map<String, ComponentPanel> componentPanelMap = new TreeMap<String, ComponentPanel>();
    private final JPanel componentsPanel;
    private final JPanel buttonPanel = new JPanel(new FlowLayout(1));
    private final JButton submitAllButton = new JButton("Submit All");
    private final JButton commitButton = new JButton("Commit All");
    private final ConcurrentMessagingUtils cmu;
    private final String destination;

    public DemoConfigurableSubsystemParameterGenericGUI(ConcurrentMessagingUtils cmu, String dest) {
        super(new BorderLayout());
        this.cmu = cmu;
        this.destination = dest;
        this.componentsPanel = new JPanel();
        this.componentsPanel.setLayout(new BoxLayout(this.componentsPanel, 1));
        this.add((Component)new JScrollPane(this.componentsPanel), "Center");
        this.buttonPanel.add(this.submitAllButton);
        this.add((Component)this.buttonPanel, "South");
        this.submitAllButton.addActionListener(e -> {
            for (ComponentPanel cp : this.componentPanelMap.values()) {
                cp.submitChanges();
            }
        });
        this.commitButton.addActionListener(e -> new CommandWorker(this, new CommandRequest(this.destination, "commitBulkChange")).execute());
        this.buttonPanel.add(this.commitButton);
    }

    public void initializeWithConfigInfo(ConfigurationInfo configInfo) {
        TreeMap mapByComponentName = new TreeMap(ConfigurationInfo.getParameterInfoGroupByComponent((List)configInfo.getAllParameterInfo()));
        for (Map.Entry entry : mapByComponentName.entrySet()) {
            ComponentPanel componentPanel = this.componentPanelMap.get(entry.getKey());
            if (componentPanel == null) {
                componentPanel = new ComponentPanel((String)entry.getKey());
                this.componentPanelMap.put((String)entry.getKey(), componentPanel);
                this.componentsPanel.add(componentPanel);
            }
            componentPanel.initializeWithConfigInfo((List)entry.getValue());
        }
    }

    public void updateWithConfigInfo(List<ConfigurationParameterInfo> latestChanges) {
        Map mapByComponentName = ConfigurationInfo.getParameterInfoGroupByComponent(latestChanges);
        for (Map.Entry entry : mapByComponentName.entrySet()) {
            String componentName = (String)entry.getKey();
            this.componentPanelMap.get(componentName).updateWithConfigInfo((List)entry.getValue());
        }
    }

    void reset() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DemoConfigurableSubsystemParameterGenericGUI.this.componentsPanel.removeAll();
                DemoConfigurableSubsystemParameterGenericGUI.this.componentPanelMap.clear();
                DemoConfigurableSubsystemParameterGenericGUI.this.revalidate();
                DemoConfigurableSubsystemParameterGenericGUI.this.repaint();
            }
        });
    }

    private class ComponentPanel
    extends JPanel {
        private final String componentName;
        private final Map<String, ParameterWidgets> parametersMap;
        private final JPanel parametersPanel;
        private final JButton submitChangesButton;

        private ComponentPanel(String componentName) {
            super(new BorderLayout());
            this.parametersMap = new TreeMap<String, ParameterWidgets>();
            this.parametersPanel = new JPanel(new GridBagLayout());
            this.submitChangesButton = new JButton("submit changes for component");
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK), componentName));
            this.componentName = componentName;
            this.add((Component)this.parametersPanel, "Center");
            JPanel buttonPanel = new JPanel(new FlowLayout(3));
            buttonPanel.add(this.submitChangesButton);
            this.add((Component)buttonPanel, "South");
        }

        private void initializeWithConfigInfo(List<ConfigurationParameterInfo> parmList) {
            for (ConfigurationParameterInfo parmInfo : parmList) {
                this.parametersMap.put(parmInfo.getParameterName(), new ParameterWidgets(parmInfo, this.componentName));
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    int parmCount = 0;
                    GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 10, 2);
                    for (ParameterWidgets parmWidgets : ComponentPanel.this.parametersMap.values()) {
                        gbc.gridx = 0;
                        gbc.gridy = parmCount++;
                        gbc.weightx = 0.0;
                        ComponentPanel.this.parametersPanel.add((Component)parmWidgets, gbc);
                    }
                }
            });
            this.submitChangesButton.addActionListener(e -> this.submitChanges());
        }

        private void updateWithConfigInfo(final List<ConfigurationParameterInfo> recentChanges) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    for (ConfigurationParameterInfo parmInfo : recentChanges) {
                        ((ParameterWidgets)ComponentPanel.this.parametersMap.get(parmInfo.getParameterName())).updateParameterWidget(parmInfo);
                    }
                }
            });
        }

        private void submitChanges() {
            HashMap<String, String> res = new HashMap<String, String>();
            for (ParameterWidgets parmWidgets : this.parametersMap.values()) {
                String text = parmWidgets.getTextField().getText();
                if (text.isEmpty()) continue;
                res.put(parmWidgets.getParameterName(), text);
            }
            new CommandWorker(this, new CommandRequest(DemoConfigurableSubsystemParameterGenericGUI.this.destination, "submitChanges", new Object[]{this.componentName, res})).execute();
        }
    }

    private class CommandWorker
    extends SwingWorker {
        private final Container parent;
        private final CommandRequest commandRequest;

        private CommandWorker(Container parent, CommandRequest commandRequest) {
            this.parent = parent;
            this.commandRequest = commandRequest;
        }

        protected Object doInBackground() throws Exception {
            Future future = DemoConfigurableSubsystemParameterGenericGUI.this.cmu.sendAsynchronousCommand(this.commandRequest);
            return future.get();
        }

        @Override
        protected void done() {
            try {
                Object res = this.get();
                String textRes = "";
                if (res == null) {
                    textRes = "OK : VOID";
                } else if (res instanceof Exception) {
                    StringWriter stackTraceWriter = new StringWriter();
                    ((Throwable)res).printStackTrace(new PrintWriter(stackTraceWriter));
                    textRes = stackTraceWriter.toString();
                } else {
                    textRes = res.toString();
                }
                if (res instanceof Exception) {
                    JOptionPane.showMessageDialog(this.parent, textRes);
                }
            }
            catch (Exception ex) {
                Logger.getLogger((String)"org.lsst.ccs.subsystem.demo.gui").error((Object)ex);
            }
        }
    }

    private class ParameterWidgets
    extends JPanel {
        private final Font myFont;
        private final Font changeFont;
        private final String parameterName;
        private final JTextField textField;
        private boolean dirty;
        private final String componentName;

        private ParameterWidgets(ConfigurationParameterInfo parmInfo, String componentName) {
            this(parmInfo.getParameterName(), parmInfo.getCurrentValue(), componentName);
            SwingUtilities.invokeLater(() -> this.updateParameterWidget(parmInfo));
        }

        private ParameterWidgets(String parameterName, String currentValue, String componentName) {
            super(new GridBagLayout());
            this.myFont = new Font("Helvetica", 0, 12);
            this.changeFont = new Font("Helvetica", 1, 12);
            this.parameterName = parameterName;
            this.componentName = componentName;
            GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 10, 2);
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.weightx = 0.0;
            this.add((Component)new JLabel(componentName + "/" + parameterName), gbc);
            gbc.gridx = 1;
            this.textField = new JTextField(currentValue);
            this.textField.setFont(this.myFont);
            this.add((Component)this.textField, gbc);
            this.textField.addActionListener(e -> this.changeParameterValue());
        }

        private void changeParameterValue() {
            new CommandWorker(this, new CommandRequest(DemoConfigurableSubsystemParameterGenericGUI.this.destination, "change", new Object[]{this.componentName, this.parameterName, this.textField.getText()})).execute();
        }

        public final void updateParameterWidget(ConfigurationParameterInfo parmInfo) {
            if (parmInfo.isDirty()) {
                this.textField.setFont(this.changeFont);
                this.textField.setForeground(Color.blue);
            } else {
                this.textField.setFont(this.myFont);
                this.textField.setForeground(Color.black);
            }
            if (!parmInfo.getCurrentValue().equals(this.textField.getText())) {
                this.textField.setText(parmInfo.getCurrentValue());
            }
        }

        public String getParameterName() {
            return this.parameterName;
        }

        public JTextField getTextField() {
            return this.textField;
        }

        public boolean isDirty() {
            return this.dirty;
        }
    }
}

