/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.trending.timeselection;

import java.awt.Dimension;
import java.awt.Window;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.lsst.ccs.gconsole.plugins.trending.timeselection.TimeWindow;
import org.lsst.ccs.gconsole.util.swing.DateTimeSelector;
import org.lsst.ccs.gconsole.util.swing.DurationSelector;

public final class TimeWindowDialog
extends JPanel {
    private final JPanel startPanel;
    private final JPanel endPanel;
    private final JLabel beforeLabel;
    private final JLabel afterLabel;
    private final JLabel startDuraLabel;
    private final JLabel endDuraLabel;
    private final DateTimeSelector startChooser;
    private final DateTimeSelector endChooser;
    private final DurationSelector startDuraChooser;
    private final DurationSelector endDuraChooser;
    private final ButtonGroup startGroup;
    private final ButtonGroup endGroup;
    private final JRadioButton startFixedButton;
    private final JRadioButton startDuraButton;
    private final JRadioButton endFixedButton;
    private final JRadioButton endDuraButton;
    private final JRadioButton endNowButton;
    private final JTextField nameField;
    private final JCheckBox saveCheck;
    private TimeWindow range;
    private TimeWindow outRange;
    private final JButton okButton;
    private ZoneId zone = ZoneId.systemDefault();
    private long[] current;

    private TimeWindowDialog(TimeWindow seed) {
        this.range = new TimeWindow(seed);
        this.okButton = new JButton("  OK  ");
        this.setLayout(new BoxLayout(this, 1));
        this.startPanel = new JPanel();
        this.startPanel.setLayout(new BoxLayout(this.startPanel, 1));
        this.startPanel.setAlignmentX(0.0f);
        this.startPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(" START "), BorderFactory.createEmptyBorder(5, 10, 5, 10)));
        Box box = Box.createHorizontalBox();
        this.startGroup = new ButtonGroup();
        this.startFixedButton = new JRadioButton("Specific time: ");
        this.startGroup.add(this.startFixedButton);
        box.add(this.startFixedButton);
        box.add(Box.createRigidArea(new Dimension(10, 0)));
        this.startChooser = new DateTimeSelector();
        box.add(this.startChooser);
        this.startChooser.setToolTipText("Select date and time for the start of the time window");
        box.add(Box.createRigidArea(new Dimension(10, 0)));
        box.add(Box.createHorizontalGlue());
        this.startPanel.add(box);
        this.startPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        box = Box.createHorizontalBox();
        this.add(box);
        this.startDuraButton = new JRadioButton("");
        this.startGroup.add(this.startDuraButton);
        box.add(this.startDuraButton);
        this.startDuraChooser = new DurationSelector();
        box.add(this.startDuraChooser);
        this.startDuraChooser.setToolTipText("Select time window duration");
        box.add(Box.createRigidArea(new Dimension(10, 0)));
        this.beforeLabel = new JLabel("before END.");
        this.startDuraLabel = new JLabel("before END.");
        box.add(this.startDuraLabel);
        box.add(Box.createRigidArea(new Dimension(10, 0)));
        box.add(Box.createHorizontalGlue());
        this.startPanel.add(box);
        this.startPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        this.add(this.startPanel);
        this.add(Box.createRigidArea(new Dimension(0, 10)));
        this.endPanel = new JPanel();
        this.endPanel.setLayout(new BoxLayout(this.endPanel, 1));
        this.endPanel.setAlignmentX(0.0f);
        this.endPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(" END "), BorderFactory.createEmptyBorder(5, 10, 5, 10)));
        box = Box.createHorizontalBox();
        this.endGroup = new ButtonGroup();
        this.endFixedButton = new JRadioButton("Specific time: ");
        this.endGroup.add(this.endFixedButton);
        box.add(this.endFixedButton);
        box.add(Box.createRigidArea(new Dimension(10, 0)));
        this.endChooser = new DateTimeSelector();
        box.add(this.endChooser);
        this.endChooser.setToolTipText("Select date and time for the end of the time window");
        box.add(Box.createRigidArea(new Dimension(10, 0)));
        box.add(Box.createHorizontalGlue());
        this.endPanel.add(box);
        this.endPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        box = Box.createHorizontalBox();
        this.add(box);
        this.endDuraButton = new JRadioButton("");
        this.endGroup.add(this.endDuraButton);
        box.add(this.endDuraButton);
        box.add(Box.createRigidArea(new Dimension(10, 0)));
        this.endDuraChooser = new DurationSelector(1, ChronoUnit.DAYS);
        this.endDuraChooser.setAmountLimits(1, Integer.MAX_VALUE);
        this.endDuraChooser.setToolTipText("Select time window duration");
        box.add(this.endDuraChooser);
        box.add(Box.createRigidArea(new Dimension(10, 0)));
        this.afterLabel = new JLabel("after START.");
        this.endDuraLabel = new JLabel("after START.");
        box.add(this.endDuraLabel);
        box.add(Box.createRigidArea(new Dimension(10, 0)));
        box.add(Box.createHorizontalGlue());
        this.endPanel.add(box);
        this.endPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        box = Box.createHorizontalBox();
        this.add(box);
        this.endNowButton = new JRadioButton("Current time (re-evaluated on refresh)");
        this.endGroup.add(this.endNowButton);
        box.add(this.endNowButton);
        box.add(Box.createRigidArea(new Dimension(10, 0)));
        box.add(Box.createHorizontalGlue());
        this.endPanel.add(box);
        this.endPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        this.add(this.endPanel);
        this.add(Box.createRigidArea(new Dimension(0, 10)));
        Box saveBox = Box.createVerticalBox();
        saveBox.setAlignmentX(0.0f);
        saveBox.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(" Remember As "), BorderFactory.createEmptyBorder(5, 10, 5, 10)));
        this.nameField = new JTextField();
        this.nameField.setColumns(30);
        saveBox.add(this.nameField);
        saveBox.add(Box.createRigidArea(new Dimension(0, 5)));
        this.saveCheck = new JCheckBox("Remember between sessions");
        saveBox.add(this.saveCheck);
        this.add(saveBox);
        this.nameField.addCaretListener(e -> this.saveCheck.setEnabled(!this.nameField.getText().trim().isEmpty()));
        this.init();
        this.startFixedButton.addActionListener(this::onUserAction);
        this.startDuraButton.addActionListener(this::onUserAction);
        this.endFixedButton.addActionListener(this::onUserAction);
        this.endDuraButton.addActionListener(this::onUserAction);
        this.endNowButton.addActionListener(this::onUserAction);
        this.startChooser.addListener(this::onUserAction);
        this.startDuraChooser.addListener(this::onUserAction);
        this.endChooser.addListener(this::onUserAction);
        this.endDuraChooser.addListener(this::onUserAction);
    }

    public static TimeWindow defineTimeWindow(JComponent parent, TimeWindow seed) {
        TimeWindowDialog tsp = new TimeWindowDialog(seed);
        tsp.okButton.addActionListener(e -> {
            tsp.outRange = tsp.getRange();
            Window w = SwingUtilities.getWindowAncestor(tsp);
            if (w != null) {
                w.setVisible(false);
            }
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(e -> {
            Window w = SwingUtilities.getWindowAncestor(tsp);
            if (w != null) {
                w.setVisible(false);
            }
        });
        JOptionPane.showOptionDialog(parent, tsp, "Select time range", 2, -1, null, new Object[]{tsp.okButton, cancelButton}, null);
        return tsp.outRange;
    }

    private TimeWindow getRange() {
        boolean persistent;
        if (this.current == null) {
            return null;
        }
        String name = this.nameField.getText().trim();
        boolean bl = persistent = !name.isEmpty() && this.saveCheck.isSelected();
        if (this.range == null) {
            this.range = new TimeWindow(name, this.current[0], this.current[1], persistent);
        } else {
            this.range.set(name, this.current[0], this.current[1], persistent);
        }
        return this.range;
    }

    private void init() {
        TimeWindow window = this.range == null ? new TimeWindow("", "now - 86400", "now", false) : this.range;
        long[] bounds = window.getBounds();
        long start = bounds[0] / 1000L;
        long end = bounds[1] / 1000L;
        if (end == 0L) {
            this.endNowButton.setSelected(true);
            this.endChooser.set(null);
            this.endDuraChooser.set(0L);
            if (start > 0L) {
                this.startFixedButton.setSelected(true);
                this.startChooser.set(this.toLocal(start));
                this.startDuraChooser.set(0L);
            } else {
                this.startDuraButton.setSelected(true);
                this.startChooser.set(null);
                this.startDuraChooser.set(-start);
            }
        } else if (end > 0L) {
            this.endFixedButton.setSelected(true);
            this.endChooser.set(this.toLocal(end));
            if (start > 0L) {
                this.startFixedButton.setSelected(true);
                this.startChooser.set(this.toLocal(start));
                long dura = end - start;
                this.startDuraChooser.set(dura);
                this.endDuraChooser.set(dura);
            } else {
                this.startChooser.set(this.toLocal(end + start));
                this.startDuraButton.setSelected(true);
                this.startDuraChooser.set(-start);
                this.endDuraChooser.set(-start);
            }
        } else {
            this.startFixedButton.setSelected(true);
            this.startChooser.set(this.toLocal(start));
            this.startDuraChooser.set(-end);
            this.endDuraButton.setSelected(true);
            this.endChooser.set(this.toLocal(start - end));
            this.endDuraChooser.set(-end);
        }
        this.onUserAction(null);
        this.saveCheck.setSelected(window.isPersistent());
        String name = window.getName();
        if (name != null && !name.isEmpty()) {
            this.nameField.setText(name);
            this.saveCheck.setEnabled(true);
        } else {
            this.saveCheck.setEnabled(false);
        }
    }

    private void onUserAction(Object source) {
        String message;
        block70: {
            LocalDateTime start = this.startChooser.get();
            LocalDateTime end = this.endChooser.get();
            long duraStart = this.startDuraChooser.get();
            long duraEnd = this.endDuraChooser.get();
            message = null;
            this.current = new long[]{0L, 0L};
            try {
                long dura = 0L;
                if (duraStart == duraEnd) {
                    dura = duraStart;
                } else if (this.startDuraButton.isSelected()) {
                    dura = duraStart;
                    this.endDuraChooser.set(dura);
                } else if (this.endDuraButton.isSelected()) {
                    dura = duraEnd;
                    this.startDuraChooser.set(dura);
                } else {
                    this.startDuraChooser.set(0L);
                    this.endDuraChooser.set(0L);
                }
                if (this.startFixedButton.isSelected()) {
                    this.startChooser.setEnabled(true);
                    this.startDuraChooser.setEnabled(false);
                    this.beforeLabel.setEnabled(false);
                    this.endDuraButton.setEnabled(true);
                    this.endDuraLabel.setEnabled(true);
                } else {
                    this.startChooser.setEnabled(false);
                    this.startDuraChooser.setEnabled(true);
                    this.beforeLabel.setEnabled(true);
                    this.endDuraButton.setEnabled(false);
                    this.endDuraLabel.setEnabled(false);
                }
                if (this.endFixedButton.isSelected()) {
                    this.endChooser.setEnabled(true);
                    this.endDuraChooser.setEnabled(false);
                    this.afterLabel.setEnabled(false);
                    this.startDuraButton.setEnabled(true);
                    this.startDuraLabel.setEnabled(true);
                } else if (this.endDuraButton.isSelected()) {
                    this.endChooser.setEnabled(false);
                    this.endDuraChooser.setEnabled(true);
                    this.afterLabel.setEnabled(true);
                    this.startDuraButton.setEnabled(false);
                    this.startDuraLabel.setEnabled(false);
                } else {
                    this.endChooser.setEnabled(false);
                    this.endDuraChooser.setEnabled(false);
                    this.afterLabel.setEnabled(false);
                    this.startDuraButton.setEnabled(true);
                    this.startDuraLabel.setEnabled(true);
                    this.endChooser.set(null);
                }
                if (this.endNowButton.isSelected()) {
                    if (this.startFixedButton.isSelected()) {
                        this.startDuraChooser.set(0L);
                        this.endDuraChooser.set(0L);
                        if (start == null) {
                            if (dura == 0L) {
                                message = "Select START";
                            } else {
                                start = this.toLocal(System.currentTimeMillis() / 1000L - dura);
                                this.startChooser.set(start);
                            }
                        }
                        this.current[0] = this.toEpochSecond(start);
                    } else {
                        if (dura == 0L) {
                            if (start == null) {
                                message = "Select duration";
                            } else {
                                start = null;
                                this.startChooser.set(start);
                                dura = this.secondsBetween(start, LocalDateTime.now(this.zone));
                                if (dura < 1L) {
                                    dura = 0L;
                                    message = "Select duration";
                                } else {
                                    this.startDuraChooser.set(dura);
                                    this.endDuraChooser.set(dura);
                                }
                            }
                        } else {
                            start = null;
                            this.startChooser.set(start);
                        }
                        this.current[0] = -dura;
                    }
                } else if (this.endFixedButton.isSelected() && this.startFixedButton.isSelected()) {
                    if (start == null) {
                        if (end == null) {
                            this.startDuraChooser.set(0L);
                            this.endDuraChooser.set(0L);
                            message = "Select START and END";
                        } else if (dura == 0L) {
                            message = "Select START";
                        } else {
                            start = end.minusSeconds(dura);
                            this.startChooser.set(start);
                        }
                    } else if (end == null) {
                        if (dura == 0L) {
                            message = "Select END";
                        } else {
                            end = start.plusSeconds(dura);
                            this.endChooser.set(end);
                        }
                    } else {
                        dura = this.secondsBetween(start, end);
                        if (dura < 1L) {
                            dura = 0L;
                            message = "Negative duration";
                        }
                        this.startDuraChooser.set(dura);
                        this.endDuraChooser.set(dura);
                    }
                    if (message == null) {
                        this.current[0] = this.toEpochSecond(start);
                        this.current[1] = this.toEpochSecond(end);
                    }
                } else if (this.endDuraButton.isSelected()) {
                    if (start == null) {
                        if (dura == 0L) {
                            message = "Select START";
                        } else if (end == null) {
                            message = "Select START and END";
                        } else {
                            start = end.minusSeconds(dura);
                            this.startChooser.set(start);
                        }
                    } else if (dura == 0L) {
                        if (end == null) {
                            message = "Select END";
                        } else {
                            dura = this.secondsBetween(start, end);
                            if (dura < 1L) {
                                dura = 0L;
                                message = "Negative duration";
                            }
                            this.startDuraChooser.set(dura);
                            this.endDuraChooser.set(dura);
                        }
                    } else {
                        end = start.plusSeconds(dura);
                        this.endChooser.set(end);
                    }
                    if (message == null) {
                        this.current[0] = this.toEpochSecond(start);
                        this.current[1] = -dura;
                    }
                } else {
                    if (end == null) {
                        if (dura == 0L) {
                            message = "Select END";
                        } else if (start == null) {
                            message = "Select START and END";
                        } else {
                            end = start.plusSeconds(dura);
                            this.endChooser.set(end);
                        }
                    } else if (dura == 0L) {
                        if (start == null) {
                            message = "Select START";
                        } else {
                            dura = this.secondsBetween(start, end);
                            if (dura < 1L) {
                                dura = 0L;
                                message = "Negative duration";
                            }
                            this.startDuraChooser.set(dura);
                            this.endDuraChooser.set(dura);
                        }
                    } else {
                        start = end.minusSeconds(dura);
                        this.startChooser.set(start);
                    }
                    if (message == null) {
                        this.current[0] = -dura;
                        this.current[1] = this.toEpochSecond(end);
                    }
                }
                if (start != null && LocalDateTime.now(this.zone).isBefore(start)) {
                    message = "START in the future is not allowed";
                }
            }
            catch (Exception x) {
                message = x.getMessage();
                if (message != null) break block70;
                message = x.toString();
            }
        }
        this.okButton.setToolTipText(message);
        if (message == null) {
            this.okButton.setEnabled(true);
        } else {
            this.okButton.setEnabled(false);
            this.current = null;
        }
    }

    private LocalDateTime toLocal(long seconds) {
        return LocalDateTime.ofInstant(Instant.ofEpochSecond(seconds), this.zone);
    }

    private long toEpochSecond(LocalDateTime dateTime) {
        return dateTime.atZone(this.zone).toEpochSecond();
    }

    private long secondsBetween(LocalDateTime start, LocalDateTime end) {
        return Duration.between(start, end).toMillis() / 1000L;
    }

    public static void main(String ... args) {
        SwingUtilities.invokeLater(() -> {
            TimeWindow tw = null;
            do {
                tw = TimeWindowDialog.defineTimeWindow(null, tw);
                System.out.println(tw);
            } while (tw != null);
        });
    }
}

