/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.plugin.web;

import jas.hist.DataSource;
import jas.hist.JASHist;
import jas.hist.JASHistData;
import jas.hist.XYDataSource;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.freehep.application.studio.Studio;
import org.freehep.jas.services.HTMLComponentFactory;
import org.freehep.jas.util.IgnoreCase;
import org.freehep.util.FreeHEPLookup;
import org.freehep.util.commanddispatcher.CommandSource;
import org.freehep.util.commanddispatcher.CommandSourceAdapter;
import org.freehep.util.images.ImageHandler;

class DefaultHTMLComponentFactory
implements HTMLComponentFactory {
    private static final String[] classes = new String[]{"MemoryPlot", "CommandButton", "CheckBoxButton", "TestPlot"};

    DefaultHTMLComponentFactory() {
    }

    void init(Studio app) {
        FreeHEPLookup lookup = app.getLookup();
        for (int i = 0; i < classes.length; ++i) {
            lookup.add((Object)this, classes[i]);
        }
    }

    @Override
    public JComponent getComponent(String name, Map attributes) {
        if (name.equals("MemoryPlot")) {
            JASHist plot = new JASHist();
            plot.setTitle("Java Memory Usage");
            plot.setDataAreaBorderType(3);
            plot.getYAxis().setLabel("MBytes");
            plot.getXAxis().setLabel("Time (seconds)");
            plot.setAllowUserInteraction(false);
            if (IgnoreCase.containsIgnoreCase(attributes, "WIDTH") || IgnoreCase.containsIgnoreCase(attributes, "HEIGHT")) {
                try {
                    String wStr = (String)IgnoreCase.getIgnoreCase(attributes, "WIDTH");
                    int w = Integer.parseInt(wStr);
                    String hStr = (String)IgnoreCase.getIgnoreCase(attributes, "HEIGHT");
                    int h = Integer.parseInt(hStr);
                    plot.setSize(w, h);
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
            return plot;
        }
        if (name.equals("TestPlot")) {
            JASHist plot = new JASHist();
            JASHistData data = plot.addData((DataSource)new TestDataSource());
            plot.setTitle("Test XY Plot");
            plot.setDataAreaBorderType(3);
            plot.getYAxis().setLabel("Y");
            plot.getXAxis().setLabel("X");
            plot.setAllowUserInteraction(true);
            data.show(true);
            return plot;
        }
        if (name.equals("CommandButton")) {
            return new CommandButton(attributes);
        }
        if (name.equals("CheckBoxButton")) {
            return new CheckBoxButton(attributes);
        }
        throw new RuntimeException("DefaultHTMLComponentFactory does not know about class: " + name);
    }

    private static void setButtonProperties(AbstractButton b, Map attributes) {
        String tooltip;
        URL base = (URL)IgnoreCase.getIgnoreCase(attributes, "BASEURL");
        String text = (String)IgnoreCase.getIgnoreCase(attributes, "TEXT");
        if (text != null) {
            b.setText(text);
        }
        if ((tooltip = (String)IgnoreCase.getIgnoreCase(attributes, "TOOLTIPTEXT")) != null) {
            b.setToolTipText(tooltip);
        }
        String icon = (String)IgnoreCase.getIgnoreCase(attributes, "ICON");
        try {
            if (icon != null) {
                b.setIcon(ImageHandler.getIcon((URL)new URL(base, icon)));
            }
        }
        catch (MalformedURLException xx) {
            IllegalArgumentException x = new IllegalArgumentException("Bad URL: " + icon);
            x.initCause(xx);
            throw x;
        }
        String action = (String)IgnoreCase.getIgnoreCase(attributes, "ACTIONCOMMAND");
        if (action != null) {
            b.setActionCommand(action);
        }
    }

    private static class TestDataSource
    implements XYDataSource {
        private double[] x = new double[]{1.0, 2.0, 3.0, 4.0, 5.0};
        private double[] y = new double[]{10.0, 8.0, 6.0, 8.0, 10.0};

        private TestDataSource() {
        }

        public int getAxisType() {
            return 1;
        }

        public double getMinusError(int index) {
            return 0.0;
        }

        public int getNPoints() {
            return this.x.length;
        }

        public double getPlusError(int index) {
            return 0.0;
        }

        public String getTitle() {
            return "TestPlot Title";
        }

        public double getX(int index) {
            return this.x[index];
        }

        public double getY(int index) {
            return this.y[index];
        }
    }

    private static class CheckBoxButton
    extends JCheckBox {
        private Studio app;

        CheckBoxButton(Map attributes) {
            this.app = (Studio)IgnoreCase.getIgnoreCase(attributes, "STUDIO");
            DefaultHTMLComponentFactory.setButtonProperties(this, attributes);
        }

        @Override
        public void addNotify() {
            this.app.getCommandTargetManager().add((CommandSource)new CommandSourceAdapter((AbstractButton)this));
            super.addNotify();
        }

        @Override
        public void removeNotify() {
            this.app.getCommandTargetManager().remove((CommandSource)new CommandSourceAdapter((AbstractButton)this));
            super.removeNotify();
        }
    }

    private static class CommandButton
    extends JButton {
        private Studio app;

        CommandButton(Map attributes) {
            this.app = (Studio)IgnoreCase.getIgnoreCase(attributes, "STUDIO");
            DefaultHTMLComponentFactory.setButtonProperties(this, attributes);
        }

        @Override
        public void addNotify() {
            this.app.getCommandTargetManager().add((CommandSource)new CommandSourceAdapter((AbstractButton)this));
            super.addNotify();
        }

        @Override
        public void removeNotify() {
            this.app.getCommandTargetManager().remove((CommandSource)new CommandSourceAdapter((AbstractButton)this));
            super.removeNotify();
        }
    }
}

