/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.application;

import java.awt.FlowLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.freehep.application.Stoppable;
import org.freehep.util.images.ImageHandler;

public class ProgressMeter
extends JPanel {
    private AsnycListener listener = new AsnycListener();
    private JLabel m_stopButton;
    private Stoppable m_stop;
    private BoundedRangeModel m_model;
    private DefaultBoundedRangeModel m_realModel = new DefaultBoundedRangeModel();
    private JProgressBar m_meter = new JProgressBar(this.m_realModel);

    public ProgressMeter() {
        this(true);
    }

    public ProgressMeter(boolean showStopButton) {
        super(new FlowLayout(2, 5, 0));
        this.setBorder(BorderFactory.createBevelBorder(1));
        Icon icon = ImageHandler.getIcon((String)"/toolbarButtonGraphics/general/Stop16.gif", this.getClass());
        this.m_stopButton = new JLabel(icon);
        this.m_stopButton.setEnabled(false);
        this.m_stopButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Stoppable stop = ProgressMeter.this.m_stop;
                if (stop != null) {
                    stop.stop();
                }
            }
        });
        this.m_meter.setBorderPainted(false);
        this.add(this.m_meter);
        this.add(this.m_stopButton);
        this.m_stopButton.setVisible(showStopButton);
        this.setAlignmentX(0.9f);
    }

    public void setShowStopButton(boolean showStopButton) {
        this.m_stopButton.setVisible(showStopButton);
    }

    public void setModel(BoundedRangeModel model) {
        if (this.m_model != null) {
            this.m_model.removeChangeListener(this.listener);
        }
        this.m_model = model;
        if (this.m_model != null) {
            this.m_model.addChangeListener(this.listener);
            this.setProgress(this.m_model);
        } else {
            this.m_realModel.setRangeProperties(0, 0, 0, 0, false);
        }
    }

    public void setStoppable(Stoppable stop) {
        if (stop == null) {
            this.setModel(null);
            this.m_stopButton.setEnabled(false);
            this.m_stopButton.repaint();
            this.m_stop = stop;
        } else {
            this.m_stop = stop;
            this.setModel(stop.getModel());
            this.m_stopButton.setEnabled(true);
            this.m_stopButton.repaint();
        }
    }

    public BoundedRangeModel getModel() {
        return this.m_model;
    }

    public void setIndeterminate(boolean ind) {
        this.m_meter.setIndeterminate(ind);
    }

    public boolean isIndeterminate() {
        return this.m_meter.isIndeterminate();
    }

    public void setStopEnabled(boolean enabled) {
        this.m_stopButton.setEnabled(enabled);
    }

    public boolean getStopEnabled() {
        return this.m_stopButton.isEnabled();
    }

    private void setProgress(BoundedRangeModel model) {
        this.m_realModel.setRangeProperties(model.getValue(), model.getExtent(), model.getMinimum(), model.getMaximum(), model.getValueIsAdjusting());
    }

    private class AsnycListener
    implements ChangeListener {
        private AsnycListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            final BoundedRangeModel model = (BoundedRangeModel)e.getSource();
            if (SwingUtilities.isEventDispatchThread()) {
                ProgressMeter.this.setProgress(model);
            } else {
                Runnable run = new Runnable(){

                    @Override
                    public void run() {
                        ProgressMeter.this.setProgress(model);
                    }
                };
                SwingUtilities.invokeLater(run);
            }
        }
    }
}

