/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.trending;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.lsst.ccs.localdb.statusdb.server.ChannelMetaData;

public class TrendData {
    static final String VALUE_KEY = "value";
    private final long[] times;
    private final Map<String, double[]> values;
    private final long[] timeRange;
    private final boolean raw;
    private final Map<String, ArrayList<MetaValue>> meta;

    TrendData(long[] times, Map<String, double[]> onPointValues, Map<String, ArrayList<MetaValue>> offPointMetadata, long[] timeRange, boolean raw) {
        this.times = times;
        this.values = onPointValues;
        this.timeRange = timeRange;
        this.raw = raw;
        this.meta = offPointMetadata;
    }

    public long[] getTimes() {
        return this.times;
    }

    public double[] getValues() {
        return this.values.get(VALUE_KEY);
    }

    public long[] getTimes(String key) {
        if (this.values.containsKey(key)) {
            return this.times;
        }
        List metaList = this.meta.get(key);
        if (metaList == null) {
            return null;
        }
        int n = metaList.size();
        long[] out = new long[n * 2];
        for (int i = 0; i < n; ++i) {
            int k = 2 * i;
            MetaValue mp = (MetaValue)metaList.get(i);
            out[k] = mp.getStart();
            out[k + 1] = mp.getStop();
        }
        return out;
    }

    public double[] getValues(String key) {
        double[] out = this.values.get(key);
        if (out == null) {
            List metaList = this.meta.get(key);
            if (metaList == null) {
                return null;
            }
            int n = metaList.size();
            out = new double[n * 2];
            try {
                for (int i = 0; i < n; ++i) {
                    double v;
                    int k = 2 * i;
                    out[k] = v = ((MetaValue)metaList.get(i)).getDoubleValue();
                    out[k + 1] = v;
                }
            }
            catch (NumberFormatException x) {
                return null;
            }
        }
        return out;
    }

    public String[] getMetadata(String key) {
        ArrayList<MetaValue> metaList = this.meta.get(key);
        if (metaList == null) {
            return null;
        }
        int n = metaList.size();
        String[] out = new String[n * 2];
        for (int i = 0; i < n; ++i) {
            int k = 2 * i;
            MetaValue mp = metaList.get(i);
            out[k] = mp.getValue();
            out[k + 1] = mp.getValue();
        }
        return out;
    }

    public String getSingleValueMetadata(String key) {
        ArrayList<MetaValue> metaList = this.meta.get(key);
        if (metaList == null || metaList.isEmpty()) {
            return null;
        }
        String out = metaList.get(0).getValue();
        for (int i = 1; i < metaList.size(); ++i) {
            if (Objects.equals(out, metaList.get(i).getValue())) continue;
            return null;
        }
        return out;
    }

    public Set<String> getOnPointKeys() {
        HashSet<String> out = new HashSet<String>(this.values.keySet());
        return out;
    }

    public long getLowT() {
        return this.times == null || this.times.length == 0 ? -1L : this.times[0];
    }

    public long getHighT() {
        return this.times == null || this.times.length == 0 ? -1L : this.times[this.times.length - 1];
    }

    public long[] getTimeRange() {
        return this.timeRange;
    }

    public boolean isRaw() {
        return this.raw;
    }

    Map<String, ArrayList<MetaValue>> getOffPointMetadata() {
        return this.meta;
    }

    static class MetaValue {
        private final long start;
        private final long stop;
        private final String value;

        MetaValue(long start, long stop, String value) {
            this.start = start;
            this.stop = stop;
            this.value = value;
        }

        long getStart() {
            return this.start;
        }

        long getStop() {
            return this.stop;
        }

        String getValue() {
            return this.value;
        }

        double getDoubleValue() {
            return Double.parseDouble(this.value);
        }

        static MetaValue trim(MetaValue in, long begin, long end) {
            if (in.start >= end || in.stop <= begin) {
                return null;
            }
            if (in.start < begin || in.stop > end) {
                return new MetaValue(Math.max(in.start, begin), Math.min(in.stop, end), in.value);
            }
            return in;
        }

        static MetaValue trim(ChannelMetaData in, long begin, long end) {
            long start = in.getTstart();
            long stop = in.getTstop();
            if (stop == -1L) {
                stop = Long.MAX_VALUE;
            }
            if (start >= end || stop <= begin) {
                return null;
            }
            String value = in.getValue();
            if (value == null) {
                return null;
            }
            return new MetaValue(Math.max(start, begin), Math.min(stop, end), value);
        }

        static MetaValue merge(MetaValue prev, MetaValue next) {
            if (!prev.value.equals(next.value)) {
                return null;
            }
            if (prev.stop >= next.start || prev.stop + 1L == next.start) {
                return new MetaValue(prev.start, next.stop, prev.value);
            }
            return null;
        }
    }
}

