package org.lsst.ccs.subsystem.demo.gui.plugins;

import java.time.Duration;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.StatusConfigurationInfo;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.base.panel.Panel;
import org.lsst.ccs.gconsole.base.panel.PanelManager;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystem.demo.gui.DemoConfigurableSubsystemParameterGenericGUI;
import org.lsst.ccs.utilities.logging.Logger;

/**
 * A plugin for the Demo Configurable Subsystem.
 * @author The lSST CCS Team
 */
@org.lsst.ccs.gconsole.annotations.Plugin(name="Demo Configurable plugin", description="A Demo Configurable plugin")
public class DemoConfigurableSubsystemPlugin extends ConsolePlugin implements AgentPresenceListener, StatusMessageListener {

    private DemoConfigurableSubsystemParameterGenericGUI page;
    private ConcurrentMessagingUtils cmu;
    
    @Override
    public void initialize() {
        cmu = new ConcurrentMessagingUtils(getConsole().getMessagingAccess());
        getConsole().getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener(this);
    }
    

    @Override
    public void connected(AgentInfo... agents) {
        for ( AgentInfo agent : agents ) {
            if (agent.getName().equals("demo-configurable-subsystem")) {
                startConfiguration(agent.getName());
            }
        }
    }

    @Override
    public void disconnected(AgentInfo... agents) {
        for ( AgentInfo agent : agents ) {
            if (agent.getName().equals("demo-configurable-subsystem")) {
                stopConfiguration();
            }
        }
    }
    
    private void startConfiguration(String dest) {
        page = new DemoConfigurableSubsystemParameterGenericGUI(cmu, dest);
        SwingUtilities.invokeLater(() -> {
            try {
                ConfigurationInfo ci = (ConfigurationInfo)cmu.sendSynchronousCommand(new CommandRequest(dest, "getConfigurationInfo"), Duration.ofSeconds(5));
                page.initializeWithConfigInfo(ci);
                
                PanelManager pm = getConsole().getPanelManager();
                pm.open(page, "Demo Configurable Subsystem GUI");
                pm.addListener(e -> {
                    if (e.hasKey(Panel.OPEN) && (Boolean) e.getNewValue() == false) {
                        stopConfiguration();
                    }
                });
                
                getConsole().getMessagingAccess().addStatusMessageListener(this,
                        BusMessageFilterFactory.messageOrigin(dest).and(BusMessageFilterFactory.embeddedObjectClass(ConfigurationInfo.class)));
                
            } catch (Exception ex) {
                Logger.getLogger("org.lsst.ccs.subsystem.demo.gui.plugins").error(ex);
            }
        });
    }
    
    private void stopConfiguration() {
        getConsole().getMessagingAccess().removeStatusMessageListener(this);
        getConsole().getPanelManager().close(page);
        page = null;
    }

    @Override
    public void onStatusMessage(StatusMessage msg) {
        page.updateWithConfigInfo(((StatusConfigurationInfo)msg).getConfigurationInfo().getLatestChanges());

    }
    
    
    
    
}
