package org.lsst.ccs.subsystem.demo.gui.plugins.monitor;

import javax.swing.JComponent;
import org.lsst.ccs.bus.data.AgentCategory;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.plugins.monitor.ConfigView;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorView;
import org.lsst.ccs.gconsole.services.optpage.OptionalPage;
import org.lsst.ccs.gconsole.plugins.monitor.SectionedTableView;
import org.lsst.ccs.gconsole.plugins.monitor.TabbedView;

/**
 * Graphical console plugin that demonstrates the use of the monitoring framework.
 *
 * @author onoprien
 */
@Plugin(name = "LSST CCS Plugin Monitoring Demo",
        id="mon-demo",
        description="The graphical console plugin that demonstrates the use of the monitoring framework.",
        loadAtStart = false)
public class MonitoringDemoPlugin extends ConsolePlugin {
       
    private final OptionalPage demoMonitoringOptionalPage = new DemoMonitoringOptionalPage();

    @Override
    public void initialize() {
        Console.getConsole().getOptionalPageService().add(demoMonitoringOptionalPage);
    }

    static class DemoMonitoringOptionalPage implements OptionalPage {

        @Override
        public boolean isAutoOpen() {
            return false;
        }        
        
        @Override
        public String getPage(AgentInfo agent) {
            if (agent.getAgentProperty(AgentCategory.AGENT_CATEGORY_PROPERTY,"").equals("demo") ) {
                return "CCS Subsystems/"+agent.getName()+"/Monitoring";
            }
            return null;
        }

        @Override
        public JComponent open(AgentInfo agent, JComponent existingComponent) {
            TabbedView tabView = new TabbedView();
            tabView.setViewFactory(name -> new SectionedTableView());
            MonitorView view = ConfigView.decorateView(tabView);
            DemoFilter monitorFilter = new DemoFilter(agent.getName());
            view.setFilter(monitorFilter);
            view.install();
            view.getPanel().setName(agent.getName()+" Monitoring");
            return view.getPanel();
        }

    
    }
    
}
