/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.monitor;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import org.lsst.ccs.gconsole.annotations.services.persist.Create;
import org.lsst.ccs.gconsole.plugins.monitor.AbstractMonitorView;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorDisplay;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorField;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorTable;
import org.lsst.ccs.gconsole.plugins.monitor.SectionedTable;
import org.lsst.ccs.gconsole.services.persist.Persistable;

public class SectionedTableView
extends AbstractMonitorView {
    public static final String CREATOR_PATH = "Built-In/Basic/Sectioned Table";
    private Descriptor descriptor;
    private final JScrollPane scrollPane = new JScrollPane();
    private SectionedTable table;

    @Create(category="MonitorView", name="Sectioned Table View", path="Built-In/Basic/Sectioned Table", description="Monitoring view that displays data channels in a table. The table is divided into collapsible sections corresponding to pages defined by the filter associated with this view.")
    public SectionedTableView() {
        this.descriptor = new Descriptor();
        this.scrollPane.add(new MonitorDisplay.EMPTY());
    }

    @Override
    public JComponent getPanel() {
        return this.scrollPane;
    }

    @Override
    protected void resetChannels() {
        ArrayList<MonitorField> fields;
        List<String> attributes = this.getFilter() == null ? null : this.getFilter().getFields(false);
        ArrayList<MonitorField> arrayList = fields = attributes == null ? MonitorTable.DEFAULT_FIELDS : new ArrayList<MonitorField>(MonitorField.getDefaultFields(attributes));
        if (this.table != null) {
            this.updateDescriptor();
            this.table.destroy();
        }
        this.table = SectionedTable.getInstance(this.data.entrySet(), fields, this.getDescriptor().getTable());
        if (this.formatter != null) {
            this.table.setFormat(this.formatter);
        }
        this.scrollPane.setViewportView(this.table.getTable());
        this.scrollPane.revalidate();
    }

    @Override
    public Descriptor save() {
        this.updateDescriptor();
        return this.descriptor.clone();
    }

    @Override
    public void restore(Persistable.Descriptor descriptor) {
        if (descriptor instanceof Descriptor) {
            this.descriptor = (Descriptor)descriptor.clone();
        }
    }

    @Override
    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    private void updateDescriptor() {
        if (this.table != null) {
            this.descriptor.setTable(this.table.save());
        }
    }

    public static class Descriptor
    extends AbstractMonitorView.Descriptor {
        private SectionedTable.Descriptor table;

        public SectionedTable.Descriptor getTable() {
            return this.table;
        }

        public void setTable(SectionedTable.Descriptor table) {
            this.table = table;
        }

        @Override
        public Descriptor clone() {
            Descriptor desc = (Descriptor)super.clone();
            if (this.table != null) {
                this.table = this.table.clone();
            }
            return desc;
        }
    }
}

