/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.util.Util;

public class PingPongDatagram {
    MulticastSocket mcast_sock;
    static final SocketAddress MCAST_GROUP;
    Log log = LogFactory.getLog(PingPongDatagram.class);
    static final byte PING = 1;
    static final byte PONG = 2;
    static final byte[] PING_REQ;
    static final byte[] PONG_RSP;
    long start = 0L;

    public void start() throws Exception {
        this.mcast_sock = new MulticastSocket(7500);
        this.mcast_sock.joinGroup(MCAST_GROUP, NetworkInterface.getByName("192.168.1.5"));
        Receiver receiver = new Receiver();
        receiver.start();
        while (true) {
            Util.keyPress("enter to ping");
            DatagramPacket packet = new DatagramPacket(PING_REQ, 0, PING_REQ.length, MCAST_GROUP);
            this.start = System.nanoTime();
            this.mcast_sock.send(packet);
        }
    }

    public static void main(String[] args) throws Exception {
        new PingPongDatagram().start();
    }

    static {
        PING_REQ = new byte[]{1};
        PONG_RSP = new byte[]{2};
        MCAST_GROUP = new InetSocketAddress("239.5.5.5", 7500);
    }

    class Receiver
    extends Thread {
        byte[] buf = new byte[1];

        Receiver() {
        }

        @Override
        public void run() {
            while (true) {
                DatagramPacket packet = new DatagramPacket(this.buf, 0, this.buf.length);
                try {
                    PingPongDatagram.this.mcast_sock.receive(packet);
                    SocketAddress sender = packet.getSocketAddress();
                    byte type = packet.getData()[0];
                    switch (type) {
                        case 1: {
                            DatagramPacket rsp = new DatagramPacket(PONG_RSP, 0, PONG_RSP.length, MCAST_GROUP);
                            PingPongDatagram.this.mcast_sock.send(rsp);
                            break;
                        }
                        case 2: {
                            long rtt = System.nanoTime() - PingPongDatagram.this.start;
                            double ms = (double)rtt / 1000.0 / 1000.0;
                            System.out.printf("RTT for %s: %.2f ms\n", sender, ms);
                            break;
                        }
                        default: {
                            System.err.println("type " + type + " unknown");
                            break;
                        }
                    }
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

