/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.plugin.tree;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import org.freehep.jas.flavors.ObjectFlavor;
import org.freehep.jas.plugin.tree.DefaultFTreeNode;
import org.freehep.jas.plugin.tree.FTreeNode;

public class FTreeNodeTransferable
implements Transferable {
    private Hashtable flavorDataHash = new Hashtable();

    protected FTreeNodeTransferable(DefaultFTreeNode[] nodes) {
        for (int i = 0; i < nodes.length; ++i) {
            DefaultFTreeNode n = nodes[i];
            Class type = n.type();
            this.addDataForClass(FTreeNode.class, n);
            this.addDataForClass(type, n.objectForClass(type));
        }
    }

    @Override
    public Object getTransferData(DataFlavor f) throws UnsupportedFlavorException, IOException {
        if (this.flavorDataHash.containsKey(f)) {
            return this.flavorDataHash.get(f);
        }
        throw new UnsupportedFlavorException(f);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] flavors = new DataFlavor[this.flavorDataHash.size()];
        Iterator iter = this.flavorDataHash.keySet().iterator();
        int count = 0;
        while (iter.hasNext()) {
            flavors[count++] = (DataFlavor)iter.next();
        }
        return flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor f) {
        return this.flavorDataHash.containsKey(f);
    }

    public void clear() {
        this.flavorDataHash.clear();
    }

    public void addDataForClass(Class clazz, Object data) {
        this.flavorDataHash.put(new ObjectFlavor(clazz), data);
    }
}

