/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.codegen.bean;

import com.mchange.v2.codegen.CodegenUtils;
import com.mchange.v2.codegen.bean.BeangenUtils;
import com.mchange.v2.codegen.bean.CloneableExtension;
import com.mchange.v2.codegen.bean.Property;
import com.mchange.v2.codegen.bean.PropertyBeanGenerator;
import com.mchange.v2.codegen.bean.SerializableExtension;
import com.mchange.v2.codegen.bean.SimplePropertyBeanGenerator;
import com.mchange.v2.codegen.bean.SimplePropertyMask;
import com.mchange.v2.codegen.bean.WrapperClassInfo;
import java.io.IOException;
import java.lang.reflect.Modifier;

public class InnerBeanPropertyBeanGenerator
extends SimplePropertyBeanGenerator {
    String innerBeanClassName;
    int inner_bean_member_modifiers = 4;
    int inner_bean_accessor_modifiers = 4;
    int inner_bean_replacer_modifiers = 4;
    String innerBeanInitializationExpression = null;

    public void setInnerBeanClassName(String innerBeanClassName) {
        this.innerBeanClassName = innerBeanClassName;
    }

    public String getInnerBeanClassName() {
        return this.innerBeanClassName;
    }

    private String defaultInnerBeanInitializationExpression() {
        return "new " + this.innerBeanClassName + "()";
    }

    private String findInnerBeanClassName() {
        return this.innerBeanClassName == null ? "InnerBean" : this.innerBeanClassName;
    }

    private String findInnerBeanInitializationExpression() {
        return this.innerBeanInitializationExpression == null ? this.defaultInnerBeanInitializationExpression() : this.innerBeanInitializationExpression;
    }

    private int findInnerClassModifiers() {
        int out = 8;
        if (Modifier.isPublic(this.inner_bean_accessor_modifiers) || Modifier.isPublic(this.inner_bean_replacer_modifiers)) {
            out |= 1;
        } else if (Modifier.isProtected(this.inner_bean_accessor_modifiers) || Modifier.isProtected(this.inner_bean_replacer_modifiers)) {
            out |= 4;
        } else if (Modifier.isPrivate(this.inner_bean_accessor_modifiers) && Modifier.isPrivate(this.inner_bean_replacer_modifiers)) {
            out |= 2;
        }
        return out;
    }

    private void writeSyntheticInnerBeanClass() throws IOException {
        int num_props = this.props.length;
        Property[] maskedProps = new Property[num_props];
        for (int i = 0; i < num_props; ++i) {
            maskedProps[i] = new SimplePropertyMask(this.props[i]){

                public int getVariableModifiers() {
                    return 130;
                }
            };
        }
        WrapperClassInfo ci = new WrapperClassInfo(this.info){

            public String getClassName() {
                return "InnerBean";
            }

            public int getModifiers() {
                return InnerBeanPropertyBeanGenerator.this.findInnerClassModifiers();
            }
        };
        this.createInnerGenerator().generate(ci, maskedProps, this.iw);
    }

    protected PropertyBeanGenerator createInnerGenerator() {
        SimplePropertyBeanGenerator innerGenerator = new SimplePropertyBeanGenerator();
        innerGenerator.setInner(true);
        innerGenerator.addExtension(new SerializableExtension());
        CloneableExtension ce = new CloneableExtension();
        ce.setExceptionSwallowing(true);
        innerGenerator.addExtension(ce);
        return innerGenerator;
    }

    protected void writeOtherVariables() throws IOException {
        this.iw.println(CodegenUtils.getModifierString(this.inner_bean_member_modifiers) + ' ' + this.findInnerBeanClassName() + " innerBean = " + this.findInnerBeanInitializationExpression() + ';');
        this.iw.println();
        this.iw.println(CodegenUtils.getModifierString(this.inner_bean_accessor_modifiers) + ' ' + this.findInnerBeanClassName() + " accessInnerBean()");
        this.iw.println("{ return innerBean; }");
    }

    protected void writeOtherFunctions() throws IOException {
        this.iw.print(CodegenUtils.getModifierString(this.inner_bean_replacer_modifiers) + ' ' + this.findInnerBeanClassName() + " replaceInnerBean( " + this.findInnerBeanClassName() + " innerBean )");
        if (this.constrainedProperties()) {
            this.iw.println(" throws PropertyVetoException");
        } else {
            this.iw.println();
        }
        this.iw.println("{");
        this.iw.upIndent();
        this.iw.println("beforeReplaceInnerBean();");
        this.iw.println("this.innerBean = innerBean;");
        this.iw.println("afterReplaceInnerBean();");
        this.iw.downIndent();
        this.iw.println("}");
        this.iw.println();
        boolean is_abstract = Modifier.isAbstract(this.info.getModifiers());
        this.iw.print("protected ");
        if (is_abstract) {
            this.iw.print("abstract ");
        }
        this.iw.print("void beforeReplaceInnerBean()");
        if (this.constrainedProperties()) {
            this.iw.print(" throws PropertyVetoException");
        }
        if (is_abstract) {
            this.iw.println(';');
        } else {
            this.iw.println(" {} //hook method for subclasses");
        }
        this.iw.println();
        this.iw.print("protected ");
        if (is_abstract) {
            this.iw.print("abstract ");
        }
        this.iw.print("void afterReplaceInnerBean()");
        if (is_abstract) {
            this.iw.println(';');
        } else {
            this.iw.println(" {} //hook method for subclasses");
        }
        this.iw.println();
        BeangenUtils.writeExplicitDefaultConstructor(1, this.info, this.iw);
        this.iw.println();
        this.iw.println("public " + this.info.getClassName() + "(" + this.findInnerBeanClassName() + " innerBean)");
        this.iw.println("{ this.innerBean = innerBean; }");
    }

    protected void writeOtherClasses() throws IOException {
        if (this.innerBeanClassName == null) {
            this.writeSyntheticInnerBeanClass();
        }
    }

    protected void writePropertyVariable(Property prop) throws IOException {
    }

    protected void writePropertyGetter(Property prop, Class propType) throws IOException {
        String stn = prop.getSimpleTypeName();
        String pfx = "boolean".equals(stn) ? "is" : "get";
        String methodName = pfx + BeangenUtils.capitalize(prop.getName());
        this.iw.print(CodegenUtils.getModifierString(prop.getGetterModifiers()));
        this.iw.println(' ' + prop.getSimpleTypeName() + ' ' + methodName + "()");
        this.iw.println('{');
        this.iw.upIndent();
        this.iw.println(stn + ' ' + prop.getName() + " = innerBean." + methodName + "();");
        String retVal = this.getGetterDefensiveCopyExpression(prop, propType);
        if (retVal == null) {
            retVal = prop.getName();
        }
        this.iw.println("return " + retVal + ';');
        this.iw.downIndent();
        this.iw.println('}');
    }

    protected void writePropertySetter(Property prop, Class propType) throws IOException {
        String stn = prop.getSimpleTypeName();
        String pfx = "boolean".equals(stn) ? "is" : "get";
        String setVal = this.getSetterDefensiveCopyExpression(prop, propType);
        if (setVal == null) {
            setVal = prop.getName();
        }
        String getExpression = "innerBean." + pfx + BeangenUtils.capitalize(prop.getName()) + "()";
        String setStatement = "innerBean.set" + BeangenUtils.capitalize(prop.getName()) + "( " + setVal + " );";
        BeangenUtils.writePropertySetterWithGetExpressionSetStatement(prop, getExpression, setStatement, this.iw);
    }
}

