/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.monitor;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.filter.AgentChannelsFilter;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorField;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorFormat;
import org.lsst.ccs.gconsole.services.aggregator.AgentStatusListener;

public interface MonitorView
extends AgentStatusListener {
    public static final String CATEGORY = "MonitorView";
    public static final MonitorField DEFAULT_GROUP_FIELD = MonitorField.AVERAGE_VALUE;
    public static final MonitorField[] AVAILABLE_GROUP_FIELDS = new MonitorField[]{MonitorField.AVERAGE_VALUE, MonitorField.MAX_VALUE, MonitorField.MIN_VALUE, MonitorField.MEDIAN_VALUE};

    public JComponent getPanel();

    default public String getName() {
        JComponent panel = this.getPanel();
        return panel == null ? "" : panel.getName();
    }

    default public void setName(String name) {
        JComponent panel = this.getPanel();
        if (panel != null) {
            panel.setName(name);
        }
    }

    public AgentChannelsFilter getFilter();

    public void setFilter(AgentChannelsFilter var1);

    default public MonitorFormat getFormater() {
        return null;
    }

    default public void setFormatter(MonitorFormat formatter) {
    }

    default public boolean isEmpty() {
        return false;
    }

    default public String getGroup(String displayPath) {
        int i = displayPath.lastIndexOf("/");
        return displayPath.substring(i + 1);
    }

    default public List<String> getGroups() {
        AgentChannelsFilter filter = this.getFilter();
        if (filter == null) {
            return null;
        }
        List<String> channels = filter.getDisplayChannels();
        if (channels == null) {
            return null;
        }
        LinkedHashSet groups = new LinkedHashSet();
        channels.forEach(displayPath -> {
            String group = this.getGroup((String)displayPath);
            if (group != null) {
                groups.add(group);
            }
        });
        return new ArrayList<String>(groups);
    }

    default public List<MonitorField> getFields() {
        AgentChannelsFilter filter = this.getFilter();
        if (filter == null) {
            return null;
        }
        List<String> channels = filter.getDisplayChannels();
        if (channels == null) {
            return null;
        }
        List<String> fields = filter.getFields(true);
        if (fields == null || fields.size() != channels.size()) {
            return null;
        }
        return fields.stream().map(s -> this.stringToField((String)s)).collect(Collectors.toList());
    }

    default public MonitorField stringToField(String field) {
        for (MonitorField mf : AVAILABLE_GROUP_FIELDS) {
            if (!mf.toString().equals(field)) continue;
            return mf;
        }
        return DEFAULT_GROUP_FIELD;
    }

    default public String fieldToString(MonitorField field) {
        return field.toString();
    }

    default public void install() {
        AgentChannelsFilter filter = this.getFilter();
        if (filter == null) {
            filter = AgentChannelsFilter.ALL;
            this.setFilter(filter);
        }
        Console.getConsole().getStatusAggregator().addListener(this, filter);
    }

    default public void uninstall() {
        Console.getConsole().getStatusAggregator().removeListener(this);
    }
}

