/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

public class SingleCategoryTag {
    private final String category;
    private final String source;
    private final String tag;
    private final String version;
    public static final String DEFAULT_VERSION = "d";

    public SingleCategoryTag(String source, String tag, String category) {
        this(source, tag, category, DEFAULT_VERSION);
    }

    public SingleCategoryTag(String source, String tag, String category, String version) {
        this.category = category;
        this.source = source;
        this.tag = tag;
        this.version = version;
        if (category == null) {
            throw new RuntimeException("Cannot build a SingleCategory object with a null category!!");
        }
        if (tag == null) {
            throw new RuntimeException("Cannot build a SingleCategory object with a null tag!!");
        }
    }

    public SingleCategoryTag(SingleCategoryTag t) {
        this(t, t.version);
    }

    public SingleCategoryTag(SingleCategoryTag t, String version) {
        this(t.source, t.tag, t.category, version);
    }

    public String getCategory() {
        return this.category;
    }

    public String getSource() {
        return this.source;
    }

    public String getTag() {
        return this.tag;
    }

    public String getVersion() {
        return this.version;
    }

    public String toString() {
        return this.category + ":" + this.toStringNoCategory();
    }

    public String toStringNoCategory() {
        String sourceStr = this.source != null && !this.source.isEmpty() ? "{" + this.source + "}" : "";
        return sourceStr + this.tag + "(" + this.version + ")";
    }

    public boolean equals(Object obj) {
        if (obj instanceof SingleCategoryTag) {
            SingleCategoryTag t = (SingleCategoryTag)obj;
            if (t.tag.equals(this.tag) && t.category.equals(this.category)) {
                if (this.source == null) {
                    return t.source == null;
                }
                return this.source.equals(t.source);
            }
        }
        return false;
    }

    public int hashCode() {
        return this.tag.hashCode() + (this.source != null ? 23 * this.source.hashCode() : 0) + 154 * this.category.hashCode();
    }
}

