/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.config.SingleCategoryTag;

public class SingleCategoryTagData {
    private static final Logger LOG = Logger.getLogger(SingleCategoryTagData.class.getName());
    private final SingleCategoryTag singleCategoryTag;
    private final Map<String, String> comments = new HashMap<String, String>();
    private final LinkedHashMap<String, String> data = new LinkedHashMap();

    public SingleCategoryTagData(SingleCategoryTag singleCategoryTag) {
        this.singleCategoryTag = singleCategoryTag;
    }

    public SingleCategoryTagData(SingleCategoryTagData singleCategoryTagData) {
        this.singleCategoryTag = new SingleCategoryTag(singleCategoryTagData.singleCategoryTag);
        this.comments.putAll(singleCategoryTagData.comments);
        this.data.putAll(singleCategoryTagData.data);
    }

    public SingleCategoryTagData(SingleCategoryTag singleCategoryTag, Properties initialProperties) {
        this.singleCategoryTag = singleCategoryTag;
        if (initialProperties != null) {
            for (String name : initialProperties.stringPropertyNames()) {
                this.data.put(name, initialProperties.getProperty(name));
            }
        }
    }

    public SingleCategoryTag getSingleCategoryTag() {
        return this.singleCategoryTag;
    }

    public Map<String, String> getConfigurationData() {
        return this.data;
    }

    public String getCommentParameter(String prop) {
        return this.comments.get(prop);
    }

    public void load(InputStream is) throws IOException {
        if (is == null) {
            return;
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
            String comment = "";
            while (reader.ready()) {
                String line = reader.readLine();
                String trimmedLine = line.trim();
                if (trimmedLine.startsWith("#") || trimmedLine.startsWith("!")) {
                    comment = comment + line + "\n";
                    continue;
                }
                int propertyEnd = trimmedLine.indexOf("=");
                if (propertyEnd < 0) {
                    propertyEnd = trimmedLine.indexOf(":");
                }
                if (propertyEnd < 0) {
                    propertyEnd = trimmedLine.length() - 1;
                }
                if (propertyEnd < 0) {
                    if (trimmedLine.isEmpty()) continue;
                    LOG.log(Level.WARNING, "Skipping line {0}", line);
                    continue;
                }
                String propertyKey = trimmedLine.substring(0, propertyEnd).trim();
                if (!comment.isEmpty()) {
                    this.comments.put(propertyKey, comment);
                    comment = "";
                }
                String propertyValue = trimmedLine.substring(propertyEnd + 1).trim();
                this.data.put(propertyKey, propertyValue);
            }
        }
        this.comments.keySet().stream().filter(prop -> !this.data.containsKey(prop)).forEachOrdered(prop -> {
            throw new RuntimeException("Property name " + prop + " does not exist for comment " + this.comments.get(prop));
        });
    }

    public String fullDataString() {
        StringBuilder result = new StringBuilder();
        this.data.keySet().forEach(prop -> {
            String comment = this.getCommentParameter((String)prop);
            if (comment != null) {
                result.append(comment);
            }
            result.append((String)prop).append("=").append(this.data.get(prop)).append("\n");
        });
        return result.toString();
    }
}

