/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.plotter.style.editor;

import hep.aida.IAnalysisFactory;
import hep.aida.IBaseHistogram;
import hep.aida.IDataPoint;
import hep.aida.IDataPointSet;
import hep.aida.IHistogram1D;
import hep.aida.IHistogram2D;
import hep.aida.IPlotter;
import hep.aida.IPlotterRegion;
import hep.aida.IPlotterStyle;
import hep.aida.ref.plotter.DummyPlotter;
import hep.aida.ref.plotter.PlotterRegion;
import hep.aida.ref.plotter.style.editor.ConfigurePreviewPanel;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class StylePreviewCreator {
    private static final Class[] possibleTypes = new Class[]{IHistogram1D.class, IHistogram2D.class, IDataPointSet.class};
    private IPlotter plotter;
    private IHistogram1D hist1D;
    private IHistogram2D hist2D;
    private IDataPointSet dps;
    private int nEvents1D = 1000;
    private int nx1D = 50;
    private double xMin1D = 0.0;
    private double xMax1D = 100.0;
    private int nEvents2D = 1000;
    private int nx2D = 50;
    private double xMin2D = 0.0;
    private double xMax2D = 100.0;
    private int ny2D = 50;
    private double yMin2D = 0.0;
    private double yMax2D = 100.0;
    private int nEventsDps2D = 20;
    private double xMinDps2D = 1.0;
    private double xMaxDps2D = 21.0;
    private double yMinDps2D = 10.0;
    private double yMaxDps2D = 210.0;
    private JComponent previewPanel;
    private Dimension previewPanelDimension = new Dimension(-1, -1);
    private Logger styleLogger = Logger.getLogger("hep.aida.ref.plotter.style.editor");

    public static Class[] getPossiblePreviewTypes() {
        return possibleTypes;
    }

    public StylePreviewCreator() {
        this(null);
    }

    public StylePreviewCreator(ConfigurePreviewPanel configurePanel) {
        this.setupPreviewCreator(configurePanel);
        this.init();
    }

    public void setupPreviewCreator(ConfigurePreviewPanel configurePanel) {
        if (configurePanel == null) {
            configurePanel = new ConfigurePreviewPanel();
        }
        this.readConfigurePanel(configurePanel);
        this.init();
    }

    private void readConfigurePanel(ConfigurePreviewPanel configurePanel) {
        boolean fit = configurePanel.previewFitRegion;
        Dimension d = null;
        d = !fit ? new Dimension(configurePanel.previewWidth, configurePanel.previewHeight) : new Dimension(-1, -1);
        this.setPreviewPanelDimension(d);
        this.nEvents1D = configurePanel.nEvents1D;
        this.nx1D = configurePanel.nx1D;
        this.xMin1D = configurePanel.xMin1D;
        this.xMax1D = configurePanel.xMax1D;
        this.nEvents2D = configurePanel.nEvents2D;
        this.nx2D = configurePanel.nx2D;
        this.ny2D = configurePanel.ny2D;
        this.xMin2D = configurePanel.xMin2D;
        this.xMax2D = configurePanel.xMax2D;
        this.yMin2D = configurePanel.yMin2D;
        this.yMax2D = configurePanel.yMax2D;
        this.nEventsDps2D = configurePanel.nEventsDps2D;
        this.xMinDps2D = configurePanel.xMinDps2D;
        this.xMaxDps2D = configurePanel.xMaxDps2D;
        this.yMinDps2D = configurePanel.yMinDps2D;
        this.yMaxDps2D = configurePanel.yMaxDps2D;
    }

    private void init() {
        if (this.plotter != null) {
            this.plotter.clearRegions();
        }
        IAnalysisFactory af = IAnalysisFactory.create();
        this.plotter = af.createPlotterFactory().create();
        this.plotter.createRegions(1);
        try {
            int i;
            this.hist1D = af.createHistogramFactory(null).createHistogram1D("Histogram 1D", this.nx1D, this.xMin1D, this.xMax1D);
            this.hist2D = af.createHistogramFactory(null).createHistogram2D("Histogram 2D", this.nx2D, this.xMin2D, this.xMax2D, this.ny2D, this.yMin2D, this.yMax2D);
            this.dps = af.createDataPointSetFactory(null).create("DataPointSet", 2);
            Random rand = new Random();
            double x = 0.0;
            double y = 0.0;
            double xMean = (this.xMax1D + this.xMin1D) / 2.0;
            double xk = (this.xMax1D - this.xMin1D) / 6.0;
            for (int i2 = 0; i2 < this.nEvents1D; ++i2) {
                x = xMean + xk * rand.nextGaussian();
                this.hist1D.fill(x);
            }
            xMean = (this.xMax2D + this.xMin2D) / 2.0;
            xk = (this.xMax2D - this.xMin2D) / 6.0;
            double yMean = (this.yMax2D + this.yMin2D) / 2.0;
            double yk = (this.yMax2D - this.yMin2D) / 6.0;
            for (i = 0; i < this.nEvents2D; ++i) {
                x = xMean + xk * rand.nextGaussian();
                y = yMean + yk * rand.nextGaussian();
                this.hist2D.fill(x, y);
            }
            xk = (this.xMaxDps2D - this.xMinDps2D) / (double)this.nEventsDps2D;
            yk = (this.yMaxDps2D - this.yMinDps2D) / (double)this.nEventsDps2D;
            for (i = 0; i < this.nEventsDps2D; ++i) {
                x = xk * (double)i + this.xMinDps2D;
                y = yk * (double)i + this.yMinDps2D;
                y = i < this.nEventsDps2D - 1 ? (y += 0.5 * rand.nextGaussian()) : (y -= 0.5 * rand.nextGaussian());
                IDataPoint point = this.dps.addPoint();
                point.coordinate(0).setValue(x);
                point.coordinate(0).setErrorMinus(Math.sqrt(x));
                point.coordinate(0).setErrorPlus(Math.sqrt(x));
                point.coordinate(1).setValue(y);
                point.coordinate(1).setErrorMinus(Math.sqrt(y));
                point.coordinate(1).setErrorPlus(Math.sqrt(y));
            }
            this.plotter.region(0).plot((IBaseHistogram)this.hist1D);
        }
        catch (Exception e) {
            this.styleLogger.info("Can not create sample histograms for the preview panel");
            this.styleLogger.log(Level.FINE, null, e);
        }
    }

    public JComponent getPreviewPanel(IPlotterStyle style, Class type) {
        String options = "USE_EXACT_STYLE";
        try {
            this.plotter.region(0).clear();
            if (type == IHistogram1D.class) {
                this.plotter.region(0).plot((IBaseHistogram)this.hist1D, style, options);
            } else if (type == IHistogram2D.class) {
                this.plotter.region(0).plot((IBaseHistogram)this.hist2D, style, options);
            } else if (type == IDataPointSet.class) {
                this.plotter.region(0).plot(this.dps, style, options);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.styleLogger.info("Can not create preview panel for type: " + type);
            this.styleLogger.log(Level.FINE, "", e);
        }
        if (this.plotter instanceof DummyPlotter) {
            IPlotterRegion region = this.plotter.region(0);
            if (region instanceof PlotterRegion) {
                ((PlotterRegion)region).getPlot().setAllowUserInteraction(true);
            }
            this.previewPanel = ((DummyPlotter)this.plotter).panel();
        }
        if (this.previewPanel != null) {
            if (this.previewPanelDimension.width > 0 && this.previewPanelDimension.height > 0) {
                this.previewPanel.setPreferredSize(this.previewPanelDimension);
            }
            this.previewPanel.setBorder(BorderFactory.createEtchedBorder(1));
        }
        return this.previewPanel;
    }

    public Dimension getPreviewPanelDimensiont() {
        return this.previewPanelDimension;
    }

    public void setPreviewPanelDimension(Dimension d) {
        this.previewPanelDimension = d;
    }

    public static void main(String[] args) throws Exception {
        JFrame frame = new JFrame("PropertySheet");
        frame.getContentPane().setLayout(new BorderLayout());
        IPlotterStyle style = IAnalysisFactory.create().createPlotterFactory().createPlotterStyle();
        StylePreviewCreator spc = new StylePreviewCreator();
        frame.getContentPane().add("Center", spc.getPreviewPanel(style, possibleTypes[0]));
        frame.setDefaultCloseOperation(3);
        frame.pack();
        frame.setSize(600, 500);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation((d.width - frame.getSize().width) / 2, (d.height - frame.getSize().height) / 2);
        frame.setVisible(true);
    }

    class UpdateThread
    extends Thread {
        IHistogram1D h;
        IPlotterStyle ps;
        Random rand = new Random();
        String scaling = "lin";

        public UpdateThread(IHistogram1D hist, IPlotterStyle ps) {
            this.h = hist;
            this.ps = ps;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(4000L);
                        this.scaling = this.scaling.equals("lin") ? "log" : "lin";
                        this.ps.yAxisStyle().setScaling(this.scaling);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

