/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.freehep.application.mdi.PageManager;
import org.freehep.application.studio.Studio;
import org.openide.util.Lookup;

class GeneralPreferences
extends JPanel {
    private JCheckBox jCheckBox2;
    private JCheckBox jCheckBox3;
    private JCheckBox jCheckBox4;
    private JComboBox jComboBox1;
    private JComboBox jComboBox2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private Studio app;

    GeneralPreferences(Studio app) {
        this.app = app;
        this.initComponents();
    }

    private void initComponents() {
        this.jCheckBox2 = new JCheckBox();
        this.jCheckBox3 = new JCheckBox();
        this.jCheckBox4 = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.jComboBox1 = new JComboBox();
        UIManager.LookAndFeelInfo[] info = UIManager.getInstalledLookAndFeels();
        String currentName = UIManager.getLookAndFeel().getName();
        for (int i = 0; i < info.length; ++i) {
            this.jComboBox1.addItem(info[i]);
            if (!currentName.equals(info[i].getName())) continue;
            this.jComboBox1.setSelectedIndex(i);
        }
        this.jLabel2 = new JLabel();
        this.jComboBox2 = new JComboBox();
        PageManager pm = this.app.getPageManager();
        Lookup.Template template = new Lookup.Template(PageManager.class);
        Lookup.Result result = this.app.getLookup().lookup(template);
        for (Lookup.Item item : result.allItems()) {
            this.jComboBox2.addItem(item.getId());
            if (item.getInstance() != pm) continue;
            this.jComboBox2.setSelectedItem(item.getId());
        }
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(new Insets(10, 10, 10, 10)));
        this.jCheckBox2.setSelected(true);
        this.jCheckBox2.setText("Show Memory Usage");
        this.jCheckBox2.setEnabled(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jCheckBox2, gridBagConstraints);
        this.jCheckBox3.setSelected(this.app.getShowToolBar());
        this.jCheckBox3.setText("Show Tool Bar");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jCheckBox3, gridBagConstraints);
        this.jCheckBox4.setSelected(this.app.getShowStatusBar());
        this.jCheckBox4.setText("Show Status Bar");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jCheckBox4, gridBagConstraints);
        this.jLabel1.setLabelFor(this.jComboBox1);
        this.jLabel1.setText("Look and Feel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jComboBox1.setRenderer(new LAFRenderer());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jComboBox1, gridBagConstraints);
        this.jLabel2.setLabelFor(this.jComboBox2);
        this.jLabel2.setText("Window Manager");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jComboBox2, gridBagConstraints);
    }

    boolean apply() {
        UIManager.LookAndFeelInfo info = (UIManager.LookAndFeelInfo)this.jComboBox1.getSelectedItem();
        this.app.setLookAndFeel(info.getClassName());
        String managerName = this.jComboBox2.getSelectedItem().toString();
        Lookup.Template template = new Lookup.Template(PageManager.class, managerName, null);
        Lookup.Result result = this.app.getLookup().lookup(template);
        PageManager manager = (PageManager)result.allInstances().iterator().next();
        this.app.setPageManager(manager);
        this.app.getUserProperties().setProperty("pageManagerName", managerName);
        this.app.setShowToolBar(this.jCheckBox3.isSelected());
        this.app.setShowStatusBar(this.jCheckBox4.isSelected());
        return true;
    }

    private static class LAFRenderer
    extends DefaultListCellRenderer {
        private LAFRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            return super.getListCellRendererComponent((JList<?>)list, ((UIManager.LookAndFeelInfo)value).getName(), index, isSelected, cellHasFocus);
        }
    }
}

