/*
 * Decompiled with CFR 0.152.
 */
package org.influxdb;

import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.BiConsumer;
import org.influxdb.InfluxDB;
import org.influxdb.dto.Point;

public final class BatchOptions
implements Cloneable {
    public static final BatchOptions DEFAULTS = new BatchOptions();
    public static final int DEFAULT_BATCH_ACTIONS_LIMIT = 1000;
    public static final int DEFAULT_BATCH_INTERVAL_DURATION = 1000;
    public static final int DEFAULT_JITTER_INTERVAL_DURATION = 0;
    public static final int DEFAULT_BUFFER_LIMIT = 10000;
    private int actions = 1000;
    private int flushDuration = 1000;
    private int jitterDuration = 0;
    private int bufferLimit = 10000;
    private ThreadFactory threadFactory = Executors.defaultThreadFactory();
    BiConsumer<Iterable<Point>, Throwable> exceptionHandler = (points, throwable) -> {};
    private InfluxDB.ConsistencyLevel consistency = InfluxDB.ConsistencyLevel.ONE;

    private BatchOptions() {
    }

    public BatchOptions actions(int actions) {
        BatchOptions clone = this.getClone();
        clone.actions = actions;
        return clone;
    }

    public BatchOptions flushDuration(int flushDuration) {
        BatchOptions clone = this.getClone();
        clone.flushDuration = flushDuration;
        return clone;
    }

    public BatchOptions jitterDuration(int jitterDuration) {
        BatchOptions clone = this.getClone();
        clone.jitterDuration = jitterDuration;
        return clone;
    }

    public BatchOptions bufferLimit(int bufferLimit) {
        BatchOptions clone = this.getClone();
        clone.bufferLimit = bufferLimit;
        return clone;
    }

    public BatchOptions threadFactory(ThreadFactory threadFactory) {
        BatchOptions clone = this.getClone();
        clone.threadFactory = threadFactory;
        return clone;
    }

    public BatchOptions exceptionHandler(BiConsumer<Iterable<Point>, Throwable> exceptionHandler) {
        BatchOptions clone = this.getClone();
        clone.exceptionHandler = exceptionHandler;
        return clone;
    }

    public BatchOptions consistency(InfluxDB.ConsistencyLevel consistency) {
        BatchOptions clone = this.getClone();
        clone.consistency = consistency;
        return clone;
    }

    public int getActions() {
        return this.actions;
    }

    public int getFlushDuration() {
        return this.flushDuration;
    }

    public int getJitterDuration() {
        return this.jitterDuration;
    }

    public int getBufferLimit() {
        return this.bufferLimit;
    }

    public ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public BiConsumer<Iterable<Point>, Throwable> getExceptionHandler() {
        return this.exceptionHandler;
    }

    public InfluxDB.ConsistencyLevel getConsistency() {
        return this.consistency;
    }

    private BatchOptions getClone() {
        try {
            return (BatchOptions)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

