/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.trending;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ThreadPoolExecutor;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.lsst.ccs.gconsole.plugins.trending.LsstTrendingPlugin;
import org.lsst.ccs.gconsole.plugins.trending.Trend;
import org.lsst.ccs.gconsole.plugins.trending.TrendData;
import org.lsst.ccs.gconsole.plugins.trending.TrendingPreferences;
import org.lsst.ccs.gconsole.plugins.trending.timeselection.TimeWindow;
import org.lsst.ccs.gconsole.plugins.trending.timeselection.TimeWindowSelector;
import org.lsst.ccs.gconsole.services.rest.LsstRestService;
import org.lsst.ccs.localdb.statusdb.server.ChannelMetaData;
import org.lsst.ccs.localdb.statusdb.server.DataChannel;
import org.lsst.ccs.localdb.statusdb.server.Datas;
import org.lsst.ccs.localdb.statusdb.server.TrendingData;
import org.lsst.ccs.localdb.statusdb.server.TrendingResult;
import org.lsst.ccs.utilities.logging.Logger;

public class RestSource {
    private final LsstTrendingPlugin plugin;
    private final TrendingPreferences pref;
    private final LsstRestService restService;
    private final ThreadPoolExecutor dataFetcher;
    private final Logger logger;
    private final Map<String, DataChannel> channels = new LinkedHashMap<String, DataChannel>();
    private volatile int begin;
    private final CopyOnWriteArrayList<ChangeListener> listeners = new CopyOnWriteArrayList();
    private final TimeWindowSelector.Listener timeListener;
    private final ChangeListener restListener;

    RestSource(LsstTrendingPlugin plugin) {
        this.plugin = plugin;
        this.pref = plugin.getPreferences();
        this.restService = (LsstRestService)plugin.getConsole().getConsoleLookup().lookup(LsstRestService.class);
        this.dataFetcher = plugin.getExecutor();
        this.logger = plugin.getConsole().getLogger();
        this.timeListener = event -> this.onTimeWindowChange(event.getTimeWindow());
        this.restListener = event -> this.onRestServerChange();
    }

    void start() {
        this.plugin.getTimeWindowSelector().addListener(this.timeListener);
        this.restService.addListener(this.restListener);
        this.onTimeWindowChange(this.plugin.getSelectedTimeWindow());
    }

    void stop() {
        TimeWindowSelector ts = this.plugin.getTimeWindowSelector();
        if (ts != null) {
            ts.removeListener(this.timeListener);
        }
        this.restService.removeListener(this.restListener);
    }

    public void refresh() {
        this.dataFetcher.execute(this::refreshChannelList);
    }

    private void onRestServerChange() {
        this.refresh();
    }

    private void onTimeWindowChange(TimeWindow timeWindow) {
        int time = timeWindow == null ? 86400 : (int)Math.max(86400L, (System.currentTimeMillis() - timeWindow.getLowerEdge()) / 1000L + 3600L);
        if (time != this.begin) {
            this.begin = time;
            this.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshChannelList() {
        List<Object> cc;
        try {
            DataChannel.DataChannelList channelList = this.restService.getChannelList(this.begin);
            cc = channelList == null || channelList.list == null || channelList.list.isEmpty() ? Collections.emptyList() : channelList.list;
        }
        catch (RuntimeException e) {
            this.logger.warn((Object)"Unable to retrieve the list of channels from the REST server.");
            cc = Collections.emptyList();
        }
        Map<String, DataChannel> map = this.channels;
        synchronized (map) {
            if (this.channels.size() != cc.size()) {
                this.channels.clear();
                cc.forEach(c -> this.channels.put(String.join((CharSequence)"/", c.getPath()), (DataChannel)c));
                this.fireEvent();
            }
        }
    }

    public void addListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void removeAllListeners() {
        this.listeners.clear();
    }

    protected void fireEvent() {
        SwingUtilities.invokeLater(() -> {
            ChangeEvent event = new ChangeEvent(this);
            this.listeners.forEach(listener -> {
                block2: {
                    try {
                        listener.stateChanged(event);
                    }
                    catch (RuntimeException x) {
                        if (this.logger == null) break block2;
                        this.logger.error((Object)(listener + " threw an exception while processing RestSource event"), (Throwable)x);
                    }
                }
            });
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getChannels() {
        Map<String, DataChannel> map = this.channels;
        synchronized (map) {
            return new ArrayList<String>(this.channels.keySet());
        }
    }

    public TrendData get(String path, long begin, long end, EnumSet<Trend.Meta> metadata, TrendData history) {
        HashSet offPoint;
        HashSet<String> onPoint;
        Datas datas;
        int nBins = this.pref.getNBins();
        String flavor = nBins > 0 ? (this.pref.isUseRawData() ? null : "stat") : (this.pref.isUseRawData() ? "raw" : "stat");
        try {
            datas = this.restService.getData(begin, end, flavor, nBins, path);
        }
        catch (RuntimeException x) {
            return null;
        }
        if (datas == null) {
            return null;
        }
        TrendingResult result = datas.getDataArray()[0].getTrendingResult();
        if (metadata == null) {
            onPoint = null;
            offPoint = null;
        } else {
            onPoint = new HashSet<String>();
            onPoint.add("value");
            offPoint = new HashSet();
            metadata.forEach(m -> {
                if (m.isOnPoint()) {
                    onPoint.addAll(m.getKeys());
                } else {
                    offPoint.addAll(m.getKeys());
                }
            });
        }
        HashMap<String, long[]> times = new HashMap<String, long[]>();
        HashMap<String, double[]> values = new HashMap<String, double[]>();
        long lowEdge = begin;
        long highEdge = end;
        TrendingData[] dataArray = result.getTrendingDataArray();
        if (dataArray != null) {
            int n = dataArray.length;
            long[] time = new long[n];
            times.put("value", time);
            for (int i = 0; i < n; ++i) {
                TrendingData td = dataArray[i];
                time[i] = td.getAxisvalue().getValue();
                for (TrendingData.DataValue dv : td.getDatavalue()) {
                    String key2 = dv.getName();
                    if (onPoint != null && !onPoint.contains(key2)) continue;
                    double[] valueArray = (double[])values.get(key2);
                    if (valueArray == null) {
                        valueArray = new double[n];
                        values.put(key2, valueArray);
                    }
                    valueArray[i] = dv.getValue();
                }
            }
        }
        List metaList = result.getChannelMetadata();
        HashMap<String, ArrayList> metaMap = new HashMap<String, ArrayList>();
        for (ChannelMetaData meta : metaList) {
            String key3 = meta.getName();
            if (offPoint != null && !offPoint.contains(key3)) continue;
            try {
                ArrayList<MetaPoint> ps = (ArrayList<MetaPoint>)metaMap.get(key3);
                if (ps == null) {
                    ps = new ArrayList<MetaPoint>();
                    metaMap.put(key3, ps);
                }
                double value = Double.parseDouble(meta.getValue());
                long start = meta.getTstart();
                long stop = meta.getTstop();
                if (start > highEdge && start != -1L || stop < lowEdge && stop != -1L) continue;
                if (start < lowEdge) {
                    start = lowEdge;
                }
                ps.add(new MetaPoint(start, value));
                if (stop > highEdge || stop == -1L) {
                    stop = highEdge;
                }
                ps.add(new MetaPoint(stop, value));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        metaMap.forEach((key, points) -> {
            int n = points.size();
            long[] t = new long[n];
            double[] v = new double[n];
            for (int i = 0; i < n; ++i) {
                MetaPoint p = (MetaPoint)points.get(i);
                t[i] = p.time;
                v[i] = p.value;
            }
            times.put((String)key, t);
            values.put((String)key, v);
        });
        return new TrendData(times, values, new long[]{begin, end});
    }

    private static class MetaPoint {
        long time;
        double value;

        MetaPoint(long t, double v) {
            this.time = t;
            this.value = v;
        }
    }
}

