/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.services.aggregator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.gconsole.services.aggregator.MutableAgentChannel;

class AgentChannelsDictionary {
    private final ArrayList<MutableAgentChannel> channels;
    private Map<String, String> key2path;

    AgentChannelsDictionary(List<MutableAgentChannel> channels) {
        this.channels = new ArrayList<MutableAgentChannel>(channels);
        HashMap map = new HashMap();
        channels.forEach(c -> {
            String path;
            String key = (String)c.get("_key_");
            if (key != null && !(path = c.getLocalPath()).equals(key)) {
                map.put(key, path);
            }
        });
        this.key2path = map.isEmpty() ? Collections.emptyMap() : map;
    }

    List<MutableAgentChannel> getAllChannels() {
        return Collections.unmodifiableList(this.channels);
    }

    MutableAgentChannel getChannelByPath(String innerPath) {
        for (MutableAgentChannel chan : this.channels) {
            if (!chan.getLocalPath().equals(innerPath)) continue;
            return chan;
        }
        return null;
    }

    String getPathFromTrendingKey(String key) {
        return this.key2path.getOrDefault(key, key);
    }

    void add(MutableAgentChannel channel) {
        String path;
        String key = (String)channel.get("_key_");
        if (key != null && !(path = channel.getLocalPath()).equals(key)) {
            if (this.key2path.isEmpty()) {
                this.key2path = new HashMap<String, String>();
            }
            this.key2path.put(key, path);
        }
        this.channels.ensureCapacity(this.channels.size() + 1);
        this.channels.add(channel);
    }
}

