/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.commandbrowser;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.AgentLock;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.plugins.commandbrowser.LsstCommandBrowserPlugin;
import org.lsst.ccs.gconsole.util.ThreadUtil;
import org.lsst.ccs.services.AgentCommandDictionaryService;
import org.lsst.ccs.services.AgentLockService;

class AgentStatus
implements Serializable {
    private final String name;
    private AgentInfo info;
    private final LsstCommandBrowserPlugin plugin;
    private final AgentLockService lockService;
    private final AgentCommandDictionaryService.AgentCommandDictionaryListener dictionaryListener;
    final Map<String, Dictionary> dictionaries = new HashMap<String, Dictionary>();
    private AgentLock lock;
    private int level;
    private boolean online;
    private boolean adjusting;
    private final CopyOnWriteArrayList<ChangeListener> listeners = new CopyOnWriteArrayList();
    private final ChangeEvent changeEvent = new ChangeEvent(this);

    AgentStatus(String agent) {
        this.name = agent;
        this.plugin = Console.getConsole().getSingleton(LsstCommandBrowserPlugin.class);
        this.lockService = (AgentLockService)Console.getConsole().getAgentService(AgentLockService.class);
        this.dictionaryListener = e -> {
            if (this.name.equals(e.getAgentInfo().getName())) {
                ThreadUtil.invokeLater(() -> {
                    switch (e.getEventType()) {
                        case ADDED: {
                            this.online = true;
                            this.info = e.getAgentInfo();
                            this.dictionaries.clear();
                            this.dictionaries.putAll(e.getDictionary());
                            break;
                        }
                        case REMOVED: {
                            this.online = false;
                            this.dictionaries.clear();
                            break;
                        }
                        case UPDATED: {
                            this.lock = this.lockService.getLockForAgent(this.name);
                            this.level = this.lockService.getLevelForAgent(this.name);
                        }
                    }
                    this.listeners.forEach(listener -> listener.stateChanged(this.changeEvent));
                });
            }
        };
        this.online = false;
    }

    AgentStatus(AgentInfo agentInfo) {
        this(agentInfo.getName());
        this.info = agentInfo;
        this.online = true;
    }

    void init() {
        ((AgentCommandDictionaryService)Console.getConsole().getAgentService(AgentCommandDictionaryService.class)).addAgentCommandDictionaryListener(this.dictionaryListener);
    }

    void shutdown() {
        ((AgentCommandDictionaryService)Console.getConsole().getAgentService(AgentCommandDictionaryService.class)).removeAgentCommandDictionaryListener(this.dictionaryListener);
    }

    public String getName() {
        return this.name;
    }

    AgentInfo getInfo() {
        return this.info;
    }

    AgentLock getLock() {
        return this.lock;
    }

    int getLevel() {
        return this.level;
    }

    boolean isAdjusting() {
        return this.adjusting;
    }

    Map<String, Dictionary> getDictionaries() {
        return this.dictionaries;
    }

    boolean isOnline() {
        return this.online;
    }

    boolean isLockedByMe() {
        return this.lock != null && this.lock.getAgentName().equals(Console.getConsole().getAgentInfo().getName());
    }

    void setLock(final boolean locked) {
        this.adjusting = true;
        this.notifyListeners();
        new SwingWorker<Object, Object>(){

            @Override
            protected Object doInBackground() throws Exception {
                if (locked) {
                    AgentStatus.this.lockService.lockAgent(AgentStatus.this.name);
                } else {
                    AgentStatus.this.lockService.unlockAgent(AgentStatus.this.name);
                }
                return null;
            }

            @Override
            protected void done() {
                try {
                    this.get();
                }
                catch (InterruptedException x) {
                    Console.getConsole().error("Unable to " + (locked ? "" : "un") + "lock the " + AgentStatus.this.name + " subsystem.");
                }
                catch (ExecutionException x) {
                    try {
                        Console.getConsole().error("Unable to " + (locked ? "" : "un") + "lock the " + AgentStatus.this.name + " subsystem.", (Exception)x.getCause());
                    }
                    catch (ClassCastException xx) {
                        Console.getConsole().error("Unable to " + (locked ? "" : "un") + "lock the " + AgentStatus.this.name + " subsystem.", x);
                    }
                }
                AgentStatus.this.adjusting = false;
                AgentStatus.this.notifyListeners();
            }
        }.execute();
    }

    public void setLevel(final int level) {
        this.adjusting = true;
        this.notifyListeners();
        new SwingWorker<Object, Object>(){

            @Override
            protected Object doInBackground() throws Exception {
                AgentStatus.this.lockService.setLevelForAgent(AgentStatus.this.name, level);
                return null;
            }

            @Override
            protected void done() {
                try {
                    this.get();
                }
                catch (InterruptedException x) {
                    Console.getConsole().error("Unable to set level " + level + " for " + AgentStatus.this.name + " subsystem.");
                }
                catch (ExecutionException x) {
                    try {
                        Console.getConsole().error("Unable to set level " + level + " for " + AgentStatus.this.name + " subsystem.", (Exception)x.getCause());
                    }
                    catch (ClassCastException xx) {
                        Console.getConsole().error("Unable to set level " + level + " for " + AgentStatus.this.name + " subsystem.", x);
                    }
                }
                AgentStatus.this.adjusting = false;
                AgentStatus.this.notifyListeners();
            }
        }.execute();
    }

    public boolean addListener(ChangeListener listener) {
        return this.listeners.addIfAbsent(listener);
    }

    public boolean removeListener(ChangeListener listener) {
        return this.listeners.remove(listener);
    }

    public boolean removeAllListeners() {
        boolean out = !this.listeners.isEmpty();
        this.listeners.clear();
        return out;
    }

    private void notifyListeners() {
        this.listeners.forEach(listener -> listener.stateChanged(this.changeEvent));
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AgentStatus) {
            return this.name.equals(((AgentStatus)obj).name);
        }
        return false;
    }
}

