/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.tracer;

import java.awt.event.ActionEvent;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.freehep.application.mdi.PageListener;
import org.freehep.jas.plugin.console.Console;
import org.freehep.jas.plugin.console.ConsoleService;
import org.freehep.swing.popup.HasPopupItems;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.plugins.tracer.FilterEditor;
import org.lsst.ccs.gconsole.plugins.tracer.FilterRegistry;
import org.lsst.ccs.gconsole.plugins.tracer.MessageFilter;
import org.lsst.ccs.gconsole.plugins.tracer.Tracer;
import org.lsst.ccs.gconsole.plugins.tracer.TracerWriter;
import org.lsst.ccs.gconsole.plugins.tracer.filters.StandardMessageFilter;
import org.lsst.ccs.gconsole.services.aggregator.AgentStatusEvent;
import org.lsst.ccs.gconsole.services.aggregator.AgentStatusListener;

@Plugin(name="LSST Tracer Plugin", id="tracer", description="LSST CCS alert notification service.")
public class LsstTracerPlugin
extends ConsolePlugin {
    private final String defaultTracerName = "Messages";
    private final FilterRegistry filterRegistry = new FilterRegistry(this);
    private final Action newFilterAction;
    private final Action defaultFilterAction = new AbstractAction("Default"){

        @Override
        public void actionPerformed(ActionEvent e) {
            LsstTracerPlugin.this.createTracer("Messages", new StandardMessageFilter.Default());
        }
    };
    private final Action loadFilterAction;
    private final AgentStatusListener agentConnectionListener;

    public LsstTracerPlugin() {
        this.newFilterAction = new AbstractAction("New filter\u2026"){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilterEditor.showDialog(null, null, LsstTracerPlugin.this, LsstTracerPlugin.this.createTracer("Messages"));
            }
        };
        this.loadFilterAction = new AbstractAction("Load filter..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessageFilter filter = LsstTracerPlugin.this.filterRegistry.selectFilter(null);
                if (filter != null) {
                    LsstTracerPlugin.this.createTracer(filter.getName(), filter);
                }
            }
        };
        this.agentConnectionListener = new AgentStatusListener(){

            @Override
            public void connect(AgentStatusEvent event) {
                final AgentInfo agent = event.getSource();
                AbstractAction action = new AbstractAction(agent.getName()){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        LsstTracerPlugin.this.createTracer(agent.getName(), new StandardMessageFilter.Default(agent.getName()));
                    }
                };
                org.lsst.ccs.gconsole.base.Console.getConsole().addMenu(action, null, "400: CCS Tools :-1:2", "Message Viewer:100:100", "Subsystems:1");
            }

            @Override
            public void disconnect(AgentStatusEvent event) {
                AgentInfo agent = event.getSource();
                org.lsst.ccs.gconsole.base.Console.getConsole().removeMenu(" CCS Tools ", "Message Viewer", "Subsystems", agent.getName());
            }
        };
    }

    @Override
    public void initialize() {
        this.getServices().addMenu(this.defaultFilterAction, "400: CCS Tools :-1:2", "Message Viewer:1");
        this.getServices().addMenu(this.newFilterAction, "400: CCS Tools :-1:2", "Message Viewer:2");
        this.getServices().addMenu(this.loadFilterAction, "400: CCS Tools :-1:2", "Message Viewer:3");
    }

    @Override
    public void start() {
        this.filterRegistry.init();
        org.lsst.ccs.gconsole.base.Console.getConsole().getStatusAggregator().addListener(this.agentConnectionListener, null, Collections.emptyList());
    }

    @Override
    public void stop() {
        org.lsst.ccs.gconsole.base.Console.getConsole().getStatusAggregator().removeListener(this.agentConnectionListener);
    }

    public FilterRegistry getFilterRegistry() {
        return this.filterRegistry;
    }

    public Tracer createTracer(String name) {
        return this.createTracer(name, (MessageFilter)null);
    }

    public Tracer createTracer(String name, String filterName) {
        return this.createTracer(name, this.filterRegistry.getFilter(filterName));
    }

    public Tracer createTracer(String name, MessageFilter filter) {
        ConsoleService cs = (ConsoleService)this.getConsole().getConsoleLookup().lookup(ConsoleService.class);
        Tracer tracer = null;
        if (cs != null) {
            tracer = new Tracer(this, filter);
            Console console = cs.createConsole(name, null, (HasPopupItems)tracer);
            TracerWriter pw = new TracerWriter(console);
            cs.getPageContextForConsole(console).addPageListener((PageListener)tracer);
            tracer.start(pw);
        }
        return tracer;
    }
}

