/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.Query;
import org.hibernate.Session;
import org.lsst.ccs.localdb.statusdb.BatchPersister;
import org.lsst.ccs.localdb.statusdb.CloseMetaData;
import org.lsst.ccs.localdb.statusdb.model.MetaDataData;

public class MetaDataPersister
extends BatchPersister<Object> {
    private Map<String, MetaDataData> metadataToClose;

    public MetaDataPersister() {
        super(3000, false);
    }

    @Override
    public void persist(Object obj, Session sess) {
        this.checkInitialization(sess);
        if (obj instanceof MetaDataData) {
            this.persistMetaData((MetaDataData)obj, sess);
        } else if (obj instanceof CloseMetaData) {
            this.closeMetaData((CloseMetaData)obj, sess);
        }
    }

    private void persistMetaData(MetaDataData md, Session sess) {
        MetaDataData oldMetaData = this.metadataToClose.get(this.getMetaDataDataUniqueKey(md));
        if (oldMetaData != null) {
            if (oldMetaData.getValue().equals(md.getValue())) {
                return;
            }
            oldMetaData.setEndTime(md.getStartTime());
            this.metadataToClose.remove(this.getMetaDataDataUniqueKey(md));
            sess.update((Object)oldMetaData);
        }
        this.metadataToClose.put(this.getMetaDataDataUniqueKey(md), md);
        sess.persist((Object)md);
    }

    private void closeMetaData(CloseMetaData cmd, Session sess) {
        long time = System.currentTimeMillis();
        for (MetaDataData md : this.metadataToClose.values()) {
            if (!md.getDataGroup().getAgentName().equals(cmd.agentName)) continue;
            md.setEndTime(time);
            this.metadataToClose.remove(this.getMetaDataDataUniqueKey(md));
            sess.update((Object)md);
        }
    }

    private synchronized void checkInitialization(Session sess) {
        if (this.metadataToClose == null) {
            this.metadataToClose = new ConcurrentHashMap<String, MetaDataData>();
            log.info((Object)"Loading metadata to be closed");
            Query q = sess.createQuery("from MetaDataData md where endTime = -1 order by startTime desc");
            List res = q.list();
            for (MetaDataData md : res) {
                String uniqueKey = this.getMetaDataDataUniqueKey(md);
                MetaDataData existingMetaData = this.metadataToClose.get(uniqueKey);
                if (existingMetaData != null) {
                    log.warn((Object)("Duplicate metadata entry for " + uniqueKey + ". This should not have happened."));
                    md.setEndTime(existingMetaData.getStartTime());
                    sess.update((Object)md);
                    continue;
                }
                this.metadataToClose.put(uniqueKey, md);
            }
            log.info((Object)("Loaded " + this.metadataToClose.size() + " metadata entries to close."));
        }
    }

    private String getMetaDataDataUniqueKey(MetaDataData md) {
        return md.getDataGroup().getId() + "-" + md.getName();
    }
}

