package org.lsst.ccs.subsystem.demo.gui.plugins.monitor;

import org.lsst.ccs.gconsole.base.filter.GenericFilter;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorField;

/**
 * Demo monitoring filter.
 *
 * @author onoprien
 */
public class DemoFilter  extends GenericFilter {

    private final String agentName;
    
    public final static String FIELDS = 
        MonitorField.VALUE.getKey()+","+
        MonitorField.UNITS.getKey()+","+
        MonitorField.LOW_ALARM.getKey()+","+
        MonitorField.LOW_WARN.getKey()+","+
        MonitorField.ALERT_LOW.getKey()+","+
        MonitorField.HIGH_WARN.getKey()+","+
        MonitorField.HIGH_ALARM.getKey()+","+
        MonitorField.ALERT_HIGH.getKey()+","+
        MonitorField.NAME.getKey()+","+
        MonitorField.DESCR.getKey();
    
    
    public DemoFilter(String agentName) {
        super("Demo",agentName,"/main/", "", true, FIELDS);
        this.agentName = agentName;
    }
    
    @Override
    public String getOriginPath(String displayPath) {
        return agentName+"/"+ displayPath.replace("//", "/");
    }

    @Override
    public String getDisplayPath(String originPath) {
        int i1 = originPath.indexOf("/");
        int i2 = originPath.indexOf("/", i1+1);
        if (i1 == -1 || i2 == -1) return null;
        String displayPath = originPath.substring(i1 + 1, i2) +"//"+ originPath.substring(i2 + 1);
        return displayPath;
    }

}
