/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.monitor;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.bus.states.DataProviderState;
import org.lsst.ccs.bus.states.StateBundle;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.description.ComponentNode;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.monitor.Alarm;
import org.lsst.ccs.monitor.CalcDevice;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.AgentService;
import org.lsst.ccs.services.DataProviderDictionaryService;
import org.lsst.ccs.services.HasDataProviderInfos;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class Monitor
implements HasLifecycle,
HasDataProviderInfos,
AgentService {
    static final String LIMITS = "Limits";
    @LookupField(strategy=LookupField.Strategy.TREE)
    private final Map<String, Device> devcMap = new HashMap<String, Device>();
    @LookupField(strategy=LookupField.Strategy.TREE)
    private final Map<String, Channel> chanMap = new LinkedHashMap<String, Channel>();
    @LookupField(strategy=LookupField.Strategy.TREE)
    private final Map<String, Alarm> alarmMap = new HashMap<String, Alarm>();
    @LookupField(strategy=LookupField.Strategy.TREE)
    private DataProviderDictionaryService dataProviderDictionaryService;
    protected Logger log;
    @LookupField(strategy=LookupField.Strategy.TOP)
    Agent subsys;
    @LookupField(strategy=LookupField.Strategy.TREE)
    List<Alarm> monitorAlarms = new ArrayList<Alarm>();
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskService;
    private boolean readyToPublish = false;
    private int numChans;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private List<Channel> chanData = new ArrayList<Channel>();
    private volatile boolean doPublishData;
    private final Object publshDataLockObject = new Object();
    private boolean useFullPath = false;
    public static final String MONITOR_CHECK_TASK = "monitor-check";
    public static final String MONITOR_UPDATE_TASK = "monitor-update";
    public static final String MONITOR_PUBLISH_TASK = "monitor-publish";
    private StateBundle currentState = new StateBundle(new Enum[0]);

    @Override
    public String getAgentServiceName() {
        return "monitorService";
    }

    @Override
    public boolean startForAgent(AgentInfo agentInfo) {
        return agentInfo.isAgentWorkerOrService();
    }

    @Override
    public void start() {
        this.readyToPublish = true;
        this.useFullPath = "true".equals(this.subsys.getAgentInfo().getAgentProperty("org.lsst.ccs.use.full.paths", "false").toLowerCase());
    }

    @Override
    public void build() {
        if (this.devcMap.size() > 0) {
            this.periodicTaskService.scheduleAgentPeriodicTask(new AgentPeriodicTask(MONITOR_UPDATE_TASK, () -> {
                this.readSensors();
                this.updateState();
            }).withPeriod(Duration.ofMillis(1000L)));
            this.periodicTaskService.scheduleAgentPeriodicTask(new AgentPeriodicTask(MONITOR_CHECK_TASK, () -> {
                for (String devName : this.getDeviceNames()) {
                    this.getDevice(devName).checkOnline();
                }
            }).withPeriod(Duration.ofMillis(10000L)));
            this.periodicTaskService.scheduleAgentPeriodicTask(new AgentPeriodicTask(MONITOR_PUBLISH_TASK, () -> {
                Object object = this.publshDataLockObject;
                synchronized (object) {
                    this.doPublishData = true;
                }
            }).withPeriod(Duration.ofMillis(10000L)));
            ComponentNode monitorNode = this.subsys.getComponentLookup().getComponentNodeForObject((Object)this);
            this.subsys.getComponentLookup().addComponentNodeToLookup(monitorNode, new ComponentNode("Calc", (Object)new CalcDevice()));
            AlarmHandler defaultHandler = new AlarmHandler(){

                @Override
                public boolean processAlarm(int event, int parm, String cause, String name) {
                    AlertState state;
                    switch (event) {
                        case 0: {
                            state = AlertState.ALARM;
                            break;
                        }
                        case 1: {
                            state = AlertState.WARNING;
                            break;
                        }
                        case 2: {
                            state = AlertState.WARNING;
                            break;
                        }
                        case 3: {
                            state = AlertState.NOMINAL;
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unkwnown event value " + event);
                        }
                    }
                    Monitor.this.alertService.raiseAlert(new Alert("MonitorAlert" + parm, name), state, "Automatic Monitor Alert\n" + cause);
                    return true;
                }

                @Override
                public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState state) {
                    String idStr = alert.getAlertId().replace("MonitorAlert", "");
                    try {
                        int id = Integer.parseInt(idStr);
                        Alarm a = this.getAlarmById(id);
                        if (a != null) {
                            return a.canClearState() ? ClearAlertHandler.ClearAlertCode.CLEAR_ALERT : ClearAlertHandler.ClearAlertCode.DONT_CLEAR_ALERT;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    return ClearAlertHandler.ClearAlertCode.UNKNOWN_ALERT;
                }
            };
            this.subsys.getComponentLookup().addComponentNodeToLookup(monitorNode, new ComponentNode("defaultAlarmHandler", (Object)defaultHandler));
        }
    }

    @Override
    public void init() {
        if (this.devcMap.size() > 0) {
            this.log = Logger.getLogger((String)(this.subsys.getLogger().getName() + ".monitor"));
            this.log.finest((Object)"Initializing monitor framework");
        }
    }

    int getChannelId(Channel ch) {
        return this.chanData.indexOf(ch);
    }

    private void readSensors() {
        for (Device devc : this.devcMap.values()) {
            devc.readSensors();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateState() {
        StateBundle sb = new StateBundle(new Enum[0]);
        for (Channel ch : this.chanData) {
            ch.checkLimits();
            sb.setComponentState(ch.getPath(), new Enum[]{ch.getState()});
        }
        StateBundle diffState = sb.diffState(this.currentState);
        this.currentState = sb;
        Map statesMap = diffState.getComponentsWithState(DataProviderState.class);
        for (Alarm alarm : this.alarmMap.values()) {
            alarm.setState();
        }
        Object object = this.publshDataLockObject;
        synchronized (object) {
            if (this.doPublishData || !statesMap.isEmpty()) {
                KeyValueDataList dataList = new KeyValueDataList();
                for (Channel ch : this.chanData) {
                    double value;
                    if (!this.doPublishData && !statesMap.containsKey(ch.getPath())) continue;
                    CCSTimeStamp ts = ch.getCCSTimeStamp();
                    if (ts != null && !Double.isNaN(value = ch.getValue())) {
                        dataList.addData(this.useFullPath ? ch.getPath() : ch.getName(), (Serializable)Double.valueOf(value), ts);
                    }
                    this.dataProviderDictionaryService.addMetadataForObject(dataList, DataProviderInfo.Attribute.STATE.getName(), ch.getState().name(), ch);
                }
                if (!dataList.getListOfKeyValueData().isEmpty() && this.readyToPublish) {
                    this.log.debug((Object)("Publishing Monitor data for " + this.subsys.getName() + " key: " + dataList.getKey() + " entries: " + dataList.getListOfKeyValueData().size()));
                    this.subsys.publishSubsystemDataOnStatusBus((KeyValueData)dataList);
                }
                this.doPublishData = false;
            }
        }
    }

    public Device getDevice(String name) {
        return this.devcMap.get(name);
    }

    @Command(type=Command.CommandType.QUERY, description="Get the list of all devices")
    public List<String> getDeviceNames() {
        return new ArrayList<String>(this.devcMap.keySet());
    }

    public Alarm getAlarm(String name) {
        return this.alarmMap.get(name);
    }

    public Channel getChannel(String name) {
        return this.chanMap.get(name);
    }

    public Channel getChannel(int id) {
        return this.chanData.get(id);
    }

    public int getChannelId(String name) {
        Channel chan = this.chanMap.get(name);
        return chan == null ? -1 : chan.getId();
    }

    public int getNumChans() {
        return this.numChans;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the list of channel names")
    public List<String> getChannelNames() {
        return new ArrayList<String>(this.chanMap.keySet());
    }

    @Command(type=Command.CommandType.QUERY, description="Get a channel value")
    public Double getChannelValue(String name) {
        Channel chan = this.chanMap.get(name);
        return chan == null ? null : Double.valueOf(chan.getValue());
    }

    @Command(type=Command.CommandType.QUERY, description="Read a channel value")
    public Double readChannelValue(String name) {
        Channel chan = this.chanMap.get(name);
        if (chan != null) {
            return chan.readSensor();
        }
        return null;
    }

    @Override
    public List<DataProviderInfo> getDataProviderInfos() {
        ArrayList<DataProviderInfo> list = new ArrayList<DataProviderInfo>();
        for (Channel ch : this.chanData) {
            String trendingKey;
            ComponentNode channelComponentNode = this.subsys.getComponentLookup().getComponentNodeForObject((Object)ch);
            this.useFullPath = "true".equals(this.subsys.getAgentInfo().getAgentProperty("org.lsst.ccs.use.full.paths", "false").toLowerCase());
            String string = trendingKey = this.useFullPath ? channelComponentNode.getPath() : channelComponentNode.getKey();
            if (trendingKey.startsWith("/")) {
                trendingKey = trendingKey.substring(1);
            }
            DataProviderInfo dataProviderInfo = new DataProviderInfo(channelComponentNode.getPath(), DataProviderInfo.Type.MONITORING, trendingKey);
            dataProviderInfo.addAttribute(DataProviderInfo.Attribute.UNITS, ch.getUnits());
            dataProviderInfo.addAttribute(DataProviderInfo.Attribute.FORMAT, ch.getFormat());
            dataProviderInfo.addAttribute(DataProviderInfo.Attribute.DESCRIPTION, ch.getDescription());
            dataProviderInfo.addAttribute(DataProviderInfo.Attribute.PAGE, String.valueOf(ch.getPageId()));
            dataProviderInfo.addAttribute(DataProviderInfo.Attribute.ALARMHI, ch.getAlarmNameHi());
            dataProviderInfo.addAttribute(DataProviderInfo.Attribute.ALARMLO, ch.getAlarmNameLo());
            list.add(dataProviderInfo);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publishDataProviderCurrentData() {
        Object object = this.publshDataLockObject;
        synchronized (object) {
            this.doPublishData = true;
        }
    }

    public static interface AlarmHandler
    extends ClearAlertHandler {
        @LookupField(strategy=LookupField.Strategy.TREE)
        public static final List<Alarm> alarms = new ArrayList<Alarm>();

        default public boolean processAlarm(int event, int parm, String cause, String alarmName) {
            return false;
        }

        @Override
        default public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState state) {
            return ClearAlertHandler.ClearAlertCode.UNKNOWN_ALERT;
        }

        default public Alarm getAlarmById(int id) {
            for (Alarm alarm : alarms) {
                if (alarm.eventParm != id) continue;
                return alarm;
            }
            return null;
        }
    }
}

