/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.commandbrowser;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.function.Consumer;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.ComponentDescriptor;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.base.panel.Panel;
import org.lsst.ccs.gconsole.plugins.commandbrowser.Browser;
import org.lsst.ccs.gconsole.plugins.commandbrowser.BrowserFull;
import org.lsst.ccs.gconsole.plugins.commandbrowser.BrowserOneSubsystem;
import org.lsst.ccs.gconsole.services.aggregator.AgentStatusEvent;
import org.lsst.ccs.gconsole.services.aggregator.AgentStatusListener;
import org.lsst.ccs.gconsole.services.persist.DataPanelDescriptor;
import org.lsst.ccs.gconsole.util.ThreadUtil;

@Plugin(name="LSST Commands Browser Plugin", id="command", description="LSST Commands Browser allows listing available commands for a subsystem and executing them.", shortDescription="LSST Remote Subsystem Commands Browser")
public class LsstCommandBrowserPlugin
extends ConsolePlugin {
    public static String[] DEFAULT_TYPES = new String[]{"WORKER", "SERVICE", "MCM", "OCS_BRIDGE", "LOCK_MANAGER"};
    private final ArrayList<Browser> browsers = new ArrayList(0);
    private final AgentStatusListener agentConnectionListener = new AgentStatusListener(){

        @Override
        public void connect(AgentStatusEvent event) {
            final AgentInfo agent = event.getSource();
            AgentInfo.AgentType type = agent.getType();
            if (!AgentInfo.AgentType.CONSOLE.equals((Object)type) && !AgentInfo.AgentType.LISTENER.equals((Object)type)) {
                AbstractAction action = new AbstractAction(agent.getName()){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String agentName = agent.getName();
                        LsstCommandBrowserPlugin.this.createBrowser("Commands:" + agentName, agentName);
                    }
                };
                Console.getConsole().addMenu(action, null, "400: CCS Tools :-1:5", "Command Browser:100:100", "Subsystems:1");
            }
        }

        @Override
        public void disconnect(AgentStatusEvent event) {
            AgentInfo agent = event.getSource();
            Console.getConsole().removeMenu(" CCS Tools ", "Command Browser", "Subsystems", agent.getName());
        }
    };

    @Override
    public void initialize() {
        AbstractAction newDictionaryAction = new AbstractAction("Browse..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                BrowserFull.Descriptor descriptor = new BrowserFull.Descriptor();
                descriptor.setName("Commands");
                descriptor.setFilterTypes(DEFAULT_TYPES);
                LsstCommandBrowserPlugin.this.createBrowser(descriptor);
            }
        };
        this.getServices().addMenu(newDictionaryAction, "400: CCS Tools :-1:5", "Command Browser:0");
    }

    @Override
    public void start() {
        Console.getConsole().getStatusAggregator().addListener(this.agentConnectionListener, null, Collections.emptyList());
    }

    @Override
    public void stop() {
        Console.getConsole().getStatusAggregator().removeListener(this.agentConnectionListener);
    }

    public void createBrowser(String name, String subsystem) {
        Browser.Descriptor descriptor;
        if (subsystem == null) {
            descriptor = new BrowserFull.Descriptor();
        } else {
            descriptor = new BrowserOneSubsystem.Descriptor();
            descriptor.setAgent(subsystem);
        }
        descriptor.setName(name);
        this.createBrowser(descriptor);
    }

    public void createBrowser(Browser.Descriptor descriptor) {
        ThreadUtil.invokeLater(() -> {
            HashMap<String, Serializable> data;
            Browser browser;
            if (descriptor instanceof BrowserFull.Descriptor) {
                browser = new BrowserFull();
            } else if (descriptor instanceof BrowserOneSubsystem.Descriptor) {
                browser = new BrowserOneSubsystem();
            } else {
                this.getConsole().getLogger().error((Object)("Unknown type of command browser descriptor: " + descriptor));
                return;
            }
            browser.restore(descriptor);
            HashMap<Object, Object> par = new HashMap<Object, Object>();
            DataPanelDescriptor panDesc = descriptor.getPage();
            if (panDesc != null && panDesc.isOpen() && (data = panDesc.getData()) != null) {
                par.putAll(data);
            }
            par.put(Panel.TITLE, browser.getName());
            Consumer<JComponent> onClose = c -> {
                Iterator<Browser> it = this.browsers.iterator();
                while (it.hasNext()) {
                    Browser b = it.next();
                    if (c != b.getPanel()) continue;
                    b.shutdown();
                    it.remove();
                    break;
                }
                this.browsers.trimToSize();
            };
            par.put(Panel.ON_CLOSE, onClose);
            this.getConsole().getPanelManager().open((Component)browser.getPanel(), par);
            this.browsers.add(browser);
            this.browsers.trimToSize();
        });
    }

    @Override
    public boolean restore(ComponentDescriptor storageBean, boolean lastRound) {
        Browser.Descriptor[] dd;
        if (!(storageBean instanceof Descriptor)) {
            return true;
        }
        Descriptor desc = (Descriptor)storageBean;
        if (!this.browsers.isEmpty()) {
            ArrayList<Browser> copy = new ArrayList<Browser>(this.browsers);
            for (Browser d : copy) {
                JComponent panel = d.getPanel();
                if (panel == null) continue;
                this.getConsole().getPanelManager().close(panel);
            }
            this.browsers.clear();
        }
        if ((dd = desc.getBrowsers()) != null) {
            for (Browser.Descriptor d : dd) {
                this.createBrowser(d);
            }
        }
        return true;
    }

    @Override
    public Descriptor save() {
        Descriptor desc = new Descriptor(this.getServices().getDescriptor());
        if (!this.browsers.isEmpty()) {
            Browser.Descriptor[] descriptors = new Browser.Descriptor[this.browsers.size()];
            for (int i = 0; i < descriptors.length; ++i) {
                descriptors[i] = this.browsers.get(i).save();
            }
            desc.setBrowsers(descriptors);
        }
        return desc;
    }

    public static class Descriptor
    extends ComponentDescriptor {
        private Browser.Descriptor[] browsers;

        public Descriptor() {
        }

        public Descriptor(ComponentDescriptor seed) {
            super(seed);
        }

        public Browser.Descriptor[] getBrowsers() {
            return this.browsers;
        }

        public void setBrowsers(Browser.Descriptor[] browsers) {
            this.browsers = browsers;
        }
    }
}

