/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.demo.gui.plugins.monitor;

import javax.swing.JComponent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.agent.AgentChannelsFilter;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.base.OptionalPage;
import org.lsst.ccs.gconsole.plugins.monitor.SectionedTableView;
import org.lsst.ccs.gconsole.plugins.monitor.TabbedView;
import org.lsst.ccs.subsystem.demo.gui.plugins.monitor.DemoFilter;

@Plugin(name="LSST CCS Plugin Monitoring Demo", id="mon-demo", description="The graphical console plugin that demonstrates the use of the monitoring framework.", loadAtStart=false)
public class MonitoringDemoPlugin
extends ConsolePlugin {
    private final OptionalPage demoMonitoringOptionalPage = new DemoMonitoringOptionalPage();

    public void initialize() {
        Console.getConsole().getOptionalPageService().add(this.demoMonitoringOptionalPage);
    }

    static class DemoMonitoringOptionalPage
    implements OptionalPage {
        DemoMonitoringOptionalPage() {
        }

        public boolean isAutoOpen() {
            return false;
        }

        public String getPage(AgentInfo agent) {
            if (agent.getAgentProperty("agentCategory", "").equals("demo")) {
                return "CCS Subsystems/" + agent.getName() + "/Monitoring";
            }
            return null;
        }

        public JComponent open(AgentInfo agent, JComponent existingComponent) {
            TabbedView view = new TabbedView();
            view.setViewFactory(name -> new SectionedTableView());
            DemoFilter monitorFilter = new DemoFilter(agent.getName());
            view.setFilter((AgentChannelsFilter)monitorFilter);
            view.install();
            view.getPanel().setName(agent.getName() + " Monitoring");
            return view.getPanel();
        }
    }
}

