/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.demo.gui.configurationview;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Future;
import java.util.function.Predicate;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.ConfigurationParameterInfo;
import org.lsst.ccs.bus.messages.BusMessage;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.StatusConfigurationInfo;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystem.demo.gui.configurationview.ConfigurationParameterTable;
import org.lsst.ccs.utilities.logging.Logger;

public class SubsystemConfigurationViewPanel
extends JPanel
implements StatusMessageListener {
    private static final long serialVersionUID = 4483704670424943133L;
    private static final Logger log = Logger.getLogger((String)"org.lsst.ccs.subsystem.demo.gui.configuration");
    private final Map<String, ComponentPanel> componentPanelMap = new TreeMap<String, ComponentPanel>();
    private final JPanel componentsPanel;
    private final JPanel buttonPanel = new JPanel(new FlowLayout(1));
    private final JButton submitAllButton = new JButton("Submit All");
    private final JButton commitButton = new JButton("Commit All");
    private final AgentMessagingLayer aml;
    private final ConcurrentMessagingUtils cmu;
    private final String destination;
    private final Predicate<BusMessage<? extends Serializable, ?>> filterConfig;

    public SubsystemConfigurationViewPanel(AgentMessagingLayer aml, String dest) {
        super(new BorderLayout());
        this.aml = aml;
        this.cmu = new ConcurrentMessagingUtils(aml);
        this.destination = dest;
        this.filterConfig = BusMessageFilterFactory.messageOrigin((String)dest).and(BusMessageFilterFactory.messageClass(StatusConfigurationInfo.class));
        this.componentsPanel = new JPanel();
        this.componentsPanel.setLayout(new BoxLayout(this.componentsPanel, 1));
        this.add((Component)new JScrollPane(this.componentsPanel), "Center");
        this.buttonPanel.add(this.submitAllButton);
        this.add((Component)this.buttonPanel, "South");
        this.submitAllButton.addActionListener(e -> {
            for (ComponentPanel cp : this.componentPanelMap.values()) {
                cp.submitChanges();
            }
        });
        this.commitButton.addActionListener(e -> new CommandWorker(this, new CommandRequest(this.destination, "commitBulkChange")).execute());
        this.buttonPanel.add(this.commitButton);
    }

    void initGui() {
        Future future = this.cmu.sendAsynchronousCommand(new CommandRequest(this.destination, "getConfigurationInfo"));
        try {
            ConfigurationInfo configInfo = (ConfigurationInfo)future.get();
            this.initializeWithConfigInfo(configInfo);
            this.aml.addStatusMessageListener((StatusMessageListener)this, this.filterConfig);
        }
        catch (Exception ex) {
            log.warn((Object)"unable to retrieve configuration information", (Throwable)ex);
        }
    }

    private void initializeWithConfigInfo(ConfigurationInfo configInfo) {
        TreeMap mapByComponentName = new TreeMap(ConfigurationInfo.getParameterInfoGroupByComponent((List)configInfo.getAllParameterInfo()));
        for (Map.Entry entry : mapByComponentName.entrySet()) {
            ComponentPanel componentPanel = this.componentPanelMap.get(entry.getKey());
            if (componentPanel == null) {
                componentPanel = new ComponentPanel((String)entry.getKey());
                this.componentPanelMap.put((String)entry.getKey(), componentPanel);
                this.componentsPanel.add(componentPanel);
            }
            componentPanel.initializeWithConfigInfo((List)entry.getValue());
        }
    }

    public void onStatusMessage(StatusMessage msg) {
        ConfigurationInfo configInfo = (ConfigurationInfo)msg.getObject();
        this.updateWithConfigInfo(configInfo);
    }

    void updateWithConfigInfo(ConfigurationInfo configInfo) {
        Map mapByComponentName = ConfigurationInfo.getParameterInfoGroupByComponent((List)configInfo.getAllParameterInfo());
        SwingUtilities.invokeLater(() -> {
            for (Map.Entry e : mapByComponentName.entrySet()) {
                this.componentPanelMap.get(e.getKey()).updateValues((List)e.getValue());
            }
        });
    }

    public void close() {
        this.aml.removeStatusMessageListener((StatusMessageListener)this);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SubsystemConfigurationViewPanel.this.componentsPanel.removeAll();
                SubsystemConfigurationViewPanel.this.componentPanelMap.clear();
                SubsystemConfigurationViewPanel.this.revalidate();
                SubsystemConfigurationViewPanel.this.repaint();
            }
        });
    }

    private class CommandWorker
    extends SwingWorker {
        private final Container parent;
        private final CommandRequest commandRequest;

        private CommandWorker(Container parent, CommandRequest commandRequest) {
            this.parent = parent;
            this.commandRequest = commandRequest;
        }

        protected Object doInBackground() throws Exception {
            Future future = SubsystemConfigurationViewPanel.this.cmu.sendAsynchronousCommand(this.commandRequest);
            return future.get();
        }

        @Override
        protected void done() {
            try {
                Object res = this.get();
                String textRes = "";
                if (res == null) {
                    textRes = "OK : VOID";
                } else if (res instanceof Exception) {
                    StringWriter stackTraceWriter = new StringWriter();
                    ((Throwable)res).printStackTrace(new PrintWriter(stackTraceWriter));
                    textRes = stackTraceWriter.toString();
                } else {
                    textRes = res.toString();
                }
                JOptionPane.showMessageDialog(this.parent, textRes);
            }
            catch (Exception ex) {
                log.error((Object)ex);
            }
        }
    }

    private class ComponentPanel
    extends JPanel {
        private static final long serialVersionUID = 5653132723598295156L;
        private final String componentName;
        private final ConfigurationParameterTable table;
        private final JButton submitChangesB;
        private final JButton resetSubmissionB;

        private ComponentPanel(String componentName) {
            super(new BorderLayout());
            this.table = new ConfigurationParameterTable();
            this.submitChangesB = new JButton("submit");
            this.resetSubmissionB = new JButton("reset");
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK), componentName));
            this.componentName = componentName;
            this.add((Component)new JScrollPane(this.table), "Center");
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 2;
            gbc.gridx = 0;
            gbc.gridy = 0;
            buttonPanel.add((Component)this.submitChangesB, gbc);
            gbc.gridx = 0;
            gbc.gridy = 1;
            buttonPanel.add((Component)this.resetSubmissionB, gbc);
            this.add((Component)buttonPanel, "East");
        }

        private void initializeWithConfigInfo(List<ConfigurationParameterInfo> parmList) {
            this.table.initialize(parmList);
            this.submitChangesB.addActionListener(e -> this.submitChanges());
        }

        private void updateValues(List<ConfigurationParameterInfo> parmList) {
            this.table.updateValues(parmList);
        }

        private void submitChanges() {
            HashMap res = new HashMap();
            new CommandWorker(this, new CommandRequest(SubsystemConfigurationViewPanel.this.destination, "submitChanges", new Object[]{this.componentName, res})).execute();
        }
    }
}

