/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.python.core.ArgParser;
import org.python.core.JyAttribute;
import org.python.core.Py;
import org.python.core.PyBuiltinMethod;
import org.python.core.PyBuiltinMethodNarrow;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.python.core.PySequence;
import org.python.core.SequenceIndexDelegate;
import org.python.core.Untraversable;
import org.python.util.Generic;

class JavaProxyList {
    private static final PyBuiltinMethodNarrow listGetProxy = new ListMethod("__getitem__", 1){

        @Override
        public PyObject __call__(PyObject key) {
            return new ListIndexDelegate(this.asList()).checkIdxAndGetItem(key);
        }
    };
    private static final PyBuiltinMethodNarrow listSetProxy = new ListMethod("__setitem__", 2){

        @Override
        public PyObject __call__(PyObject key, PyObject value) {
            new ListIndexDelegate(this.asList()).checkIdxAndSetItem(key, value);
            return Py.None;
        }
    };
    private static final PyBuiltinMethodNarrow listRemoveProxy = new ListMethod("__delitem__", 1){

        @Override
        public PyObject __call__(PyObject key) {
            new ListIndexDelegate(this.asList()).checkIdxAndDelItem(key);
            return Py.None;
        }
    };
    private static final PyBuiltinMethodNarrow listEqProxy = new ListMethod("__eq__", 1){

        @Override
        public PyObject __call__(PyObject other) {
            List jList = this.asList();
            if (other.getType().isSubType(PyList.TYPE)) {
                PyList oList = (PyList)other;
                if (jList.size() != oList.size()) {
                    return Py.False;
                }
                for (int i = 0; i < jList.size(); ++i) {
                    if (Py.java2py(jList.get(i))._eq(oList.pyget(i)).__nonzero__()) continue;
                    return Py.False;
                }
                return Py.True;
            }
            Object oj = other.getJavaProxy();
            if (oj instanceof List) {
                List oList = (List)oj;
                if (jList.size() != oList.size()) {
                    return Py.False;
                }
                for (int i = 0; i < jList.size(); ++i) {
                    if (Py.java2py(jList.get(i))._eq(Py.java2py(oList.get(i))).__nonzero__()) continue;
                    return Py.False;
                }
                return Py.True;
            }
            return null;
        }
    };
    private static final PyBuiltinMethodNarrow listAppendProxy = new ListMethod("append", 1){

        @Override
        public PyObject __call__(PyObject value) {
            this.asList().add(value);
            return Py.None;
        }
    };
    private static final PyBuiltinMethodNarrow listExtendProxy = new ListMethod("extend", 1){

        @Override
        public PyObject __call__(PyObject obj) {
            List jList = this.asList();
            ArrayList<PyObject> extension2 = new ArrayList<PyObject>();
            for (PyObject item : obj.asIterable()) {
                extension2.add(item);
            }
            jList.addAll(extension2);
            return Py.None;
        }
    };
    private static final PyBuiltinMethodNarrow listInsertProxy = new ListMethod("insert", 2){

        @Override
        public PyObject __call__(PyObject index, PyObject object) {
            List jlist = this.asList();
            ListIndexDelegate lid = new ListIndexDelegate(jlist);
            int idx = lid.fixBoundIndex(index);
            jlist.add(idx, object);
            return Py.None;
        }
    };
    private static final PyBuiltinMethodNarrow listPopProxy = new ListMethod("pop", 0, 1){

        @Override
        public PyObject __call__() {
            return this.__call__(Py.newInteger(-1));
        }

        @Override
        public PyObject __call__(PyObject index) {
            List jlist = this.asList();
            if (jlist.isEmpty()) {
                throw Py.IndexError("pop from empty list");
            }
            ListIndexDelegate ldel = new ListIndexDelegate(jlist);
            PyObject item = ldel.checkIdxAndFindItem(index.asInt());
            if (item == null) {
                throw Py.IndexError("pop index out of range");
            }
            ldel.checkIdxAndDelItem(index);
            return item;
        }
    };
    private static final PyBuiltinMethodNarrow listIndexProxy = new ListMethod("index", 1, 3){

        @Override
        public PyObject __call__(PyObject object) {
            return this.__call__(object, (PyObject)Py.newInteger(0), (PyObject)Py.newInteger(this.asList().size()));
        }

        @Override
        public PyObject __call__(PyObject object, PyObject start) {
            return this.__call__(object, start, (PyObject)Py.newInteger(this.asList().size()));
        }

        @Override
        public PyObject __call__(PyObject object, PyObject start, PyObject end) {
            List jlist = this.asList();
            ListIndexDelegate lid = new ListIndexDelegate(jlist);
            int start_index = lid.fixBoundIndex(start);
            int end_index = lid.fixBoundIndex(end);
            try {
                ListIterator it = jlist.listIterator(start_index);
                for (int i = start_index; it.hasNext() && i != end_index; ++i) {
                    Object jobj = it.next();
                    if (!Py.java2py(jobj)._eq(object).__nonzero__()) continue;
                    return Py.newInteger(i);
                }
            }
            catch (ConcurrentModificationException e) {
                throw Py.ValueError(object.toString() + " is not in list");
            }
            throw Py.ValueError(object.toString() + " is not in list");
        }
    };
    private static final PyBuiltinMethodNarrow listCountProxy = new ListMethod("count", 1){

        @Override
        public PyObject __call__(PyObject object) {
            int count2 = 0;
            List jlist = this.asList();
            for (int i = 0; i < jlist.size(); ++i) {
                Object jobj = jlist.get(i);
                if (!Py.java2py(jobj)._eq(object).__nonzero__()) continue;
                ++count2;
            }
            return Py.newInteger(count2);
        }
    };
    private static final PyBuiltinMethodNarrow listReverseProxy = new ListMethod("reverse", 0){

        @Override
        public PyObject __call__() {
            List jlist = this.asList();
            Collections.reverse(jlist);
            return Py.None;
        }
    };
    private static final PyBuiltinMethodNarrow listRemoveOverrideProxy = new ListMethod("remove", 1){

        @Override
        public PyObject __call__(PyObject object) {
            List jlist = this.asList();
            for (int i = 0; i < jlist.size(); ++i) {
                Object jobj = jlist.get(i);
                if (!Py.java2py(jobj)._eq(object).__nonzero__()) continue;
                jlist.remove(i);
                return Py.None;
            }
            if (object.isIndex()) {
                ListIndexDelegate ldel = new ListIndexDelegate(jlist);
                ldel.checkIdxAndDelItem(object);
                return Py.None;
            }
            throw Py.ValueError(object.toString() + " is not in list");
        }
    };
    private static final PyBuiltinMethodNarrow listRAddProxy = new ListMethod("__radd__", 1){

        @Override
        public PyObject __call__(PyObject obj) {
            List jClone;
            List jList = this.asList();
            try {
                jClone = (List)jList.getClass().newInstance();
            }
            catch (IllegalAccessException e) {
                throw Py.JavaError(e);
            }
            catch (InstantiationException e) {
                throw Py.JavaError(e);
            }
            for (Object entry : jList) {
                jClone.add(entry);
            }
            if (obj instanceof Collection) {
                jClone.addAll(0, (Collection)((Object)obj));
            } else {
                int i = 0;
                for (PyObject item : obj.asIterable()) {
                    jClone.add(i, item);
                    ++i;
                }
            }
            return Py.java2py(jClone);
        }
    };
    private static final PyBuiltinMethodNarrow listIAddProxy = new ListMethod("__iadd__", 1){

        @Override
        public PyObject __call__(PyObject obj) {
            List jList = this.asList();
            if (obj instanceof Collection) {
                jList.addAll((Collection)((Object)obj));
            } else {
                for (PyObject item : obj.asIterable()) {
                    jList.add(item);
                }
            }
            return this.self;
        }
    };
    private static final PyBuiltinMethodNarrow listIMulProxy = new ListMethod("__imul__", 1){

        @Override
        public PyObject __call__(PyObject obj) {
            List jList = this.asList();
            int mult = obj.asInt();
            if (mult <= 0) {
                jList.clear();
            } else {
                try {
                    if (jList instanceof ArrayList) {
                        ((ArrayList)jList).ensureCapacity(jList.size() * (mult - 1));
                    }
                    int originalSize = jList.size();
                    --mult;
                    while (mult > 0) {
                        for (int i = 0; i < originalSize; ++i) {
                            jList.add(jList.get(i));
                        }
                        --mult;
                    }
                }
                catch (OutOfMemoryError t) {
                    throw Py.MemoryError("");
                }
            }
            return this.self;
        }
    };
    private static final PyBuiltinMethodNarrow listSortProxy = new ListMethod("sort", 0, 3){

        @Override
        public PyObject __call__() {
            JavaProxyList.list_sort(this.asList(), Py.None, Py.None, false);
            return Py.None;
        }

        @Override
        public PyObject __call__(PyObject cmp) {
            JavaProxyList.list_sort(this.asList(), cmp, Py.None, false);
            return Py.None;
        }

        @Override
        public PyObject __call__(PyObject cmp, PyObject key) {
            JavaProxyList.list_sort(this.asList(), cmp, key, false);
            return Py.None;
        }

        @Override
        public PyObject __call__(PyObject cmp, PyObject key, PyObject reverse) {
            JavaProxyList.list_sort(this.asList(), cmp, key, reverse.__nonzero__());
            return Py.None;
        }

        @Override
        public PyObject __call__(PyObject[] args, String[] kwds) {
            ArgParser ap = new ArgParser("list", args, kwds, new String[]{"cmp", "key", "reverse"}, 0);
            PyObject cmp = ap.getPyObject(0, Py.None);
            PyObject key = ap.getPyObject(1, Py.None);
            PyObject reverse = ap.getPyObject(2, Py.False);
            JavaProxyList.list_sort(this.asList(), cmp, key, reverse.__nonzero__());
            return Py.None;
        }
    };

    JavaProxyList() {
    }

    private static synchronized void list_sort(List list, PyObject cmp, PyObject key, boolean reverse) {
        int size = list.size();
        ArrayList<KV> decorated = new ArrayList<KV>(size);
        for (Object value : list) {
            PyObject pyvalue = Py.java2py(value);
            if (key == null || key == Py.None) {
                decorated.add(new KV(pyvalue, value));
                continue;
            }
            decorated.add(new KV(key.__call__(pyvalue), value));
        }
        list.clear();
        KVComparator c = new KVComparator(cmp);
        if (reverse) {
            Collections.reverse(decorated);
        }
        Collections.sort(decorated, c);
        if (reverse) {
            Collections.reverse(decorated);
        }
        boolean modified = list.size() > 0;
        for (KV kv : decorated) {
            list.add(kv.value);
        }
        if (modified) {
            throw Py.ValueError("list modified during sort");
        }
    }

    static PyBuiltinMethod[] getProxyMethods() {
        return new PyBuiltinMethod[]{listGetProxy, listSetProxy, listEqProxy, listRemoveProxy, listAppendProxy, listExtendProxy, listInsertProxy, listPopProxy, listIndexProxy, listCountProxy, listReverseProxy, listRAddProxy, listIAddProxy, new ListMulProxyClass("__mul__", 1), new ListMulProxyClass("__rmul__", 1), listIMulProxy};
    }

    static PyBuiltinMethod[] getPostProxyMethods() {
        return new PyBuiltinMethod[]{listSortProxy, listRemoveOverrideProxy};
    }

    private static class KVComparator
    implements Comparator<KV> {
        private final PyObject cmp;

        KVComparator(PyObject cmp) {
            this.cmp = cmp;
        }

        @Override
        public int compare(KV o1, KV o2) {
            if (this.cmp != null && this.cmp != Py.None) {
                PyObject pyresult = this.cmp.__call__(o1.key, o2.key);
                if (pyresult instanceof PyInteger || pyresult instanceof PyLong) {
                    return pyresult.asInt();
                }
                throw Py.TypeError(String.format("comparison function must return int, not %.200s", pyresult.getType().fastGetName()));
            }
            int result2 = o1.key._cmp(o2.key);
            return result2;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof KVComparator) {
                return this.cmp.equals(((KVComparator)o).cmp);
            }
            return false;
        }
    }

    private static class KV {
        private final PyObject key;
        private final Object value;

        KV(PyObject key, Object value) {
            this.key = key;
            this.value = value;
        }
    }

    @Untraversable
    private static class ListMulProxyClass
    extends ListMethod {
        protected ListMulProxyClass(String name, int numArgs) {
            super(name, numArgs);
        }

        @Override
        public PyObject __call__(PyObject obj) {
            int mult;
            List jList = this.asList();
            ArrayList newList = null;
            if (mult > 0) {
                try {
                    newList = new ArrayList(jList.size() * mult);
                    for (mult = obj.asInt(); mult > 0; --mult) {
                        for (Object entry : jList) {
                            newList.add(entry);
                        }
                    }
                }
                catch (OutOfMemoryError t) {
                    throw Py.MemoryError("");
                }
            } else {
                newList = Collections.EMPTY_LIST;
            }
            return Py.java2py(newList);
        }
    }

    protected static class ListIndexDelegate
    extends SequenceIndexDelegate {
        private final List list;

        public ListIndexDelegate(List list) {
            this.list = list;
        }

        @Override
        public void delItem(int idx) {
            this.list.remove(idx);
        }

        @Override
        public PyObject getItem(int idx) {
            return Py.java2py(this.list.get(idx));
        }

        @Override
        public PyObject getSlice(int start, int stop, int step) {
            List newList;
            if (step > 0 && stop < start) {
                stop = start;
            }
            int n = PySequence.sliceLength(start, stop, step);
            try {
                newList = (List)this.list.getClass().newInstance();
            }
            catch (Exception e) {
                throw Py.JavaError(e);
            }
            int j = 0;
            int i = start;
            while (j < n) {
                newList.add(this.list.get(i));
                ++j;
                i += step;
            }
            return Py.java2py(newList);
        }

        @Override
        public String getTypeName() {
            return this.list.getClass().getName();
        }

        @Override
        public int len() {
            return this.list.size();
        }

        protected int fixBoundIndex(PyObject index) {
            PyInteger length = Py.newInteger(this.len());
            if (index._lt(Py.Zero).__nonzero__()) {
                if ((index = index._add(length))._lt(Py.Zero).__nonzero__()) {
                    index = Py.Zero;
                }
            } else if (index._gt(length).__nonzero__()) {
                index = length;
            }
            int i = index.asIndex();
            assert (i >= 0);
            return i;
        }

        @Override
        public void setItem(int idx, PyObject value) {
            this.list.set(idx, value.__tojava__(Object.class));
        }

        @Override
        public void setSlice(int start, int stop, int step, PyObject value) {
            if (stop < start) {
                stop = start;
            }
            if (JyAttribute.getAttr(value, (byte)-128) == this.list) {
                List xs = Generic.list();
                xs.addAll(this.list);
                this.setsliceList(start, stop, step, xs);
            } else if (value instanceof PyList) {
                this.setslicePyList(start, stop, step, (PyList)value);
            } else {
                Object valueList = value.__tojava__(List.class);
                if (valueList != null && valueList != Py.NoConversion) {
                    this.setsliceList(start, stop, step, (List)valueList);
                } else {
                    this.setsliceIterator(start, stop, step, value.asIterable().iterator());
                }
            }
        }

        private final void setsliceList(int start, int stop, int step, List value) {
            if (step == 1) {
                this.list.subList(start, stop).clear();
                this.list.addAll(start, value);
            } else {
                int size = this.list.size();
                ListIterator iter = value.listIterator();
                int j = start;
                while (iter.hasNext()) {
                    Object item = iter.next();
                    if (j >= size) {
                        this.list.add(item);
                    } else {
                        this.list.set(j, item);
                    }
                    j += step;
                }
            }
        }

        private final void setsliceIterator(int start, int stop, int step, Iterator<PyObject> iter) {
            if (step == 1) {
                ArrayList<Object> insertion = new ArrayList<Object>();
                if (iter != null) {
                    while (iter.hasNext()) {
                        insertion.add(iter.next().__tojava__(Object.class));
                    }
                }
                this.list.subList(start, stop).clear();
                this.list.addAll(start, insertion);
            } else {
                int size = this.list.size();
                int j = start;
                while (iter.hasNext()) {
                    Object item = iter.next().__tojava__(Object.class);
                    if (j >= size) {
                        this.list.add(item);
                    } else {
                        this.list.set(j, item);
                    }
                    j += step;
                }
            }
        }

        private final void setslicePyList(int start, int stop, int step, PyList value) {
            if (step == 1) {
                this.list.subList(start, stop).clear();
                int n = value.getList().size();
                int i = 0;
                int j = start;
                while (i < n) {
                    Object item = value.getList().get(i).__tojava__(Object.class);
                    this.list.add(j, item);
                    ++i;
                    ++j;
                }
            } else {
                int size = this.list.size();
                ListIterator<PyObject> iter = value.getList().listIterator();
                int j = start;
                while (iter.hasNext()) {
                    Object item = ((PyObject)iter.next()).__tojava__(Object.class);
                    if (j >= size) {
                        this.list.add(item);
                    } else {
                        this.list.set(j, item);
                    }
                    j += step;
                }
            }
        }

        @Override
        public void delItems(int start, int stop) {
            int n = stop - start;
            while (n-- > 0) {
                this.delItem(start);
            }
        }
    }

    @Untraversable
    private static class ListMethod
    extends PyBuiltinMethodNarrow {
        protected ListMethod(String name, int numArgs) {
            super(name, numArgs);
        }

        protected ListMethod(String name, int minArgs, int maxArgs) {
            super(name, minArgs, maxArgs);
        }

        protected List asList() {
            return (List)this.self.getJavaProxy();
        }

        protected List newList() {
            try {
                return (List)this.asList().getClass().newInstance();
            }
            catch (IllegalAccessException e) {
                throw Py.JavaError(e);
            }
            catch (InstantiationException e) {
                throw Py.JavaError(e);
            }
        }
    }
}

