/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.services.command;

import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeoutException;
import org.lsst.ccs.bus.messages.CommandNack;
import org.lsst.ccs.gconsole.agent.command.CommandHandle;
import org.lsst.ccs.gconsole.agent.command.CommandTask;
import org.lsst.ccs.gconsole.base.Console;

public class DefaultCommandHandle
implements CommandHandle {
    @Override
    public void onSendingFailure(Throwable exception, CommandTask source) {
        try {
            Console.getConsole().error("Failed to send command: " + source.getCommand(), (Exception)exception);
        }
        catch (ClassCastException x) {
            Console.getConsole().error("Failed to send command: " + source.getCommand() + ". Reason: " + exception);
        }
    }

    @Override
    public void onNack(CommandNack nack, CommandTask source) {
        StringBuilder message = new StringBuilder("Command: ");
        message.append(source.getCommand()).append(" has been rejected by the target subsystem.");
        if (nack != null) {
            message.append(" Reason: ").append(nack.getReason());
        }
    }

    @Override
    public void onExecutionFailure(Throwable exception, CommandTask source) {
        try {
            Console.getConsole().error("Target subsystem failed to execute command: " + source.getCommand(), (Exception)exception);
        }
        catch (ClassCastException x) {
            Console.getConsole().error("Target subsystem failed to execute command: " + source.getCommand() + ". Reason: " + exception);
        }
    }

    @Override
    public void onTimeout(TimeoutException exception, CommandTask source) {
        Console.getConsole().error("Command timed out: " + source.getCommand(), exception);
    }

    @Override
    public void onCancel(CancellationException exception, CommandTask source) {
        Console.getConsole().error("Command has been canceled: " + source.getCommand(), exception);
    }
}

