/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.logging;

import org.lsst.ccs.utilities.logging.LogPropertiesLoader;

public class StackTraceFormats {
    private static int depth = -1;
    private static volatile boolean modified = false;

    public static int getDepth() {
        return depth;
    }

    public static void setDepth(int depth) {
        StackTraceFormats.depth = depth;
        modified = true;
    }

    public static void setDepthFromInitialProperties() {
        if (modified) {
            return;
        }
        int depth = LogPropertiesLoader.loaderGetIntProperty("org.lsst.ccs.logging.StackTraceFormats.depth", -1);
        StackTraceFormats.setDepth(depth);
    }

    public static String toString(Throwable throwable) {
        return StackTraceFormats.toString(throwable, 1);
    }

    public static String toString(Throwable throwable, int level) {
        Throwable cause;
        StringBuilder stb = new StringBuilder(String.valueOf(throwable)).append('\n');
        StackTraceElement[] traces = throwable.getStackTrace();
        int size = traces.length;
        if (depth < 0 || size <= depth * 2) {
            for (StackTraceElement trace : traces) {
                StackTraceFormats.indent(stb, level).append(trace).append('\n');
            }
        } else {
            int ix;
            for (ix = 0; ix < depth; ++ix) {
                StackTraceFormats.indent(stb, level).append(traces[ix]).append('\n');
            }
            StackTraceFormats.indent(stb, level).append(".....\n");
            for (ix = size - depth; ix < size; ++ix) {
                StackTraceFormats.indent(stb, level).append(traces[ix]).append('\n');
            }
        }
        if ((cause = throwable.getCause()) != null) {
            StackTraceFormats.indent(stb, level - 1).append("caused by : ").append(StackTraceFormats.toString(cause, level + 1));
        }
        return stb.toString();
    }

    private static StringBuilder indent(StringBuilder stb, int level) {
        for (int ix = 0; ix <= level; ++ix) {
            stb.append("  ");
        }
        return stb;
    }
}

