package org.lsst.ccs.subsystem.demo.gui.plugins.monitor;

import java.util.Collections;
import java.util.List;
import org.lsst.ccs.gconsole.annotations.ConsoleLookup;
import org.lsst.ccs.gconsole.agent.filter.GenericFilter;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorField;

/**
 * Demo monitoring filter.
 *
 * @author onoprien
 */
@ConsoleLookup(id="org.lsst.ccs.gconsole.agent.AgentChannelsFilter",
               name="Demo filter",
               path="Demo/Demo Subsystem/DemoFilter",
               description="Demo filter packaged with the demo subsystem.")
public class DemoFilter  extends GenericFilter {

    private final String agentName;
    
    public final static String FIELDS = 
        MonitorField.VALUE.getKey()+","+
        MonitorField.UNITS.getKey()+","+
        MonitorField.LOW_ALARM.getKey()+","+
        MonitorField.LOW_WARN.getKey()+","+
        MonitorField.ALERT_LOW.getKey()+","+
        MonitorField.HIGH_WARN.getKey()+","+
        MonitorField.HIGH_ALARM.getKey()+","+
        MonitorField.ALERT_HIGH.getKey()+","+
        MonitorField.NAME.getKey()+","+
        MonitorField.DESCR.getKey();
    
    
    public DemoFilter(String agentName) {
        super("Demo",agentName,"/main/", "", true, FIELDS);
        this.agentName = agentName;
    }
    
    @Override
    public String getOriginPath(String displayPath) {
        return agentName+"/"+ displayPath.replace("//", "/");
    }

    @Override
    public List<String> getDisplayPath(String originPath) {
        int i1 = originPath.indexOf("/");
        int i2 = originPath.indexOf("/", i1+1);
        if (i1 == -1 || i2 == -1) return Collections.emptyList();
        String displayPath = originPath.substring(i1 + 1, i2) +"//"+ originPath.substring(i2 + 1);
        return Collections.singletonList(displayPath);
    }

}
