package org.lsst.ccs.subsystem.demo.gui.plugins.monitor;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.base.panel.Panel;
import org.lsst.ccs.gconsole.base.panel.PanelManager;

/**
 * Graphical console plugin that demonstrates the use of the monitoring framework.
 *
 * @author onoprien
 */
@Plugin(name = "LSST CCS Plugin Monitoring Demo",
        id="mon-demo",
        description="The graphical console plugin that demonstrates the use of the monitoring framework.",
        loadAtStart = false)
public class MonitoringDemoPlugin extends ConsolePlugin {

// -- Fields : -----------------------------------------------------------------
    
    private JComponent page;
    private Action act;

// -- Life cycle : -------------------------------------------------------------

    /**
     * Called by the framework when the console starts, to initialize this plugin.
     */
    @Override
    public void initialize() {
        act = new AbstractAction("Monitoring") {
            @Override
            public void actionPerformed(ActionEvent e) {
                if ((Boolean)getValue(Action.SELECTED_KEY)) {
                    startMonitoring();
                } else {
                    stopMonitoring();
                }
            }
        };
        act.putValue(Action.SELECTED_KEY, false);
        getServices().addMenu(act, "Demo");


    }
    
    private void startMonitoring() {
//        DemoMonitorGui gui = new DemoMonitorGui("monitor-test");
        DemoMonitorGui gui = new DemoMonitorGui("demo-subsystem-with-monitoring", "monitor-test");
        gui.initGui();
        page = gui.getGuiLayout();
        PanelManager pm = getConsole().getPanelManager();
        pm.open(page, "Monitor Demo");
        pm.addListener(e -> {
            if (e.hasKey(Panel.OPEN) && (Boolean) e.getNewValue() == false) {
                stopMonitoring();
            }
        });
        act.putValue(Action.SELECTED_KEY, true);
    }
    
    private void stopMonitoring() {
        getConsole().getPanelManager().close(page);
        page = null;
        act.putValue(Action.SELECTED_KEY, false);
    }
    
//    private void startMonitoring() {
//        DemoSubsystemWithMonitoringGUI gui = new DemoSubsystemWithMonitoringGUI(getConsole().getMessagingAccess());
//        gui.initGui();
//        page = gui.getGuiLayout();
//        PanelManager pm = getConsole().getPanelManager();
//        pm.open(page, "Monitor Demo");
//        pm.addListener(e -> {
//            if (e.hasKey(Panel.OPEN) && (Boolean) e.getNewValue() == false) {
//                stopMonitoring();
//            }
//        });
//        act.putValue(Action.SELECTED_KEY, true);
//    }
//    
//    private void stopMonitoring() {
//        getConsole().getPanelManager().close(page);
//        page = null;
//        act.putValue(Action.SELECTED_KEY, false);
//    }
    
}
