/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.services;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import org.lsst.ccs.Agent;
import org.lsst.ccs.ServiceLifecycle;
import org.lsst.ccs.StateChangeListener;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusStateChangeNotification;
import org.lsst.ccs.bus.states.AgentState;
import org.lsst.ccs.bus.states.StateBundle;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.services.AgentService;
import org.lsst.ccs.utilities.logging.Logger;

public final class AgentStateService
implements AgentService,
ServiceLifecycle {
    private static final Logger log = Logger.getLogger((String)"org.lsst.ccs.services.state");
    private StateBundle innerState = new StateBundle(new Enum[0]);
    private final Object innerStateLock = new Object();
    private final ReentrantLock stateWaitLock = new ReentrantLock(true);
    private volatile LinkedHashMap<Condition, Predicate<StateBundle>> stateWaitList;
    private StateBundle stateWaitState;
    private final Map<StateChangeListener, List<Class>> stateChangeListeners = new ConcurrentHashMap<StateChangeListener, List<Class>>();
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent agent;

    @Override
    public String getAgentServiceName() {
        return "stateService";
    }

    @Override
    public boolean startForAgent(AgentInfo agentInfo) {
        return true;
    }

    @Override
    public void preStart() {
    }

    @Override
    public void preInit() {
        this.agent.addCommandsFromObject(new AgentStateServiceCommands(this), "");
    }

    public Object getStateLock() {
        return this.innerStateLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInState(Enum state) {
        Object object = this.innerStateLock;
        synchronized (object) {
            return this.innerState.isInState(state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isComponentInState(String component, Enum state) {
        Object object = this.innerStateLock;
        synchronized (object) {
            return this.innerState.isComponentInState(component, state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInState(StateBundle state) {
        Object object = this.innerStateLock;
        synchronized (object) {
            return this.innerState.isInState(state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enum getState(Class stateClass) {
        Object object = this.innerStateLock;
        synchronized (object) {
            return this.innerState.getState(stateClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enum getComponentState(String component, Class stateClass) {
        Object object = this.innerStateLock;
        synchronized (object) {
            return this.innerState.getComponentState(component, stateClass);
        }
    }

    public void updateAgentState(Enum ... stateChanges) {
        StateBundle sb = new StateBundle(stateChanges);
        this.updateAgentState(false, sb);
    }

    public void updateAgentState(StateBundle stateChanges) {
        this.updateAgentState(false, stateChanges);
    }

    public void updateAgentComponentState(Object component, Enum ... stateChanges) {
        StateBundle sb = new StateBundle(new Enum[0]);
        sb.setComponentState(this.agent.getComponentLookup().getComponentNodeForObject(component).getPath(), stateChanges);
        this.updateAgentState(false, sb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAgentState(boolean isInternal, StateBundle stateChanges) {
        StateBundle after;
        StateBundle before;
        if (!isInternal) {
            for (Enum state : stateChanges.getDecodedStates().values()) {
                if (!(state instanceof AgentState)) continue;
                throw new IllegalArgumentException("Attempt to modify internal Agent states");
            }
            for (String component : stateChanges.getComponentsWithStates()) {
                if (this.agent.getComponentLookup().getComponentByPath(component) == null) {
                    log.warn((Object)("Component state name " + component + " does not correspond to an object in the agent lookup tree. Please change your code to use the object's full path"));
                }
                for (Enum state : stateChanges.getComponentStateBundle(component).getDecodedStates().values()) {
                    if (!(state instanceof AgentState)) continue;
                    throw new IllegalArgumentException("Attempt to modify internal Agent states");
                }
            }
        }
        Iterator iterator = this.innerStateLock;
        synchronized (iterator) {
            before = this.innerState.clone();
            this.innerState = this.innerState.mergeState(stateChanges);
            after = this.innerState.clone();
            if (!AgentState.isLegal((StateBundle)before, (StateBundle)after)) {
                this.innerState = before;
                String msg = "Illegal state transition from " + before + " to " + after;
                log.error((Object)msg);
                throw new IllegalArgumentException(msg);
            }
        }
        if (!before.equals((Object)after)) {
            this.stateWaitNotify(after);
            if (!this.stateChangeListeners.isEmpty()) {
                this.notifyStateChange(after.diffState(before), before);
            }
            if (this.agent.isConnectedToTheBuses()) {
                this.publishStateChange(before, after);
            }
        }
    }

    public final void updateInternalState(AgentState ... stateChanges) {
        StateBundle sb = new StateBundle(new Enum[0]);
        for (AgentState change : stateChanges) {
            sb.setState(new Enum[]{(Enum)change});
        }
        this.updateAgentState(true, sb);
    }

    protected void publishStateChange(StateBundle before, StateBundle after) {
        StatusStateChangeNotification sm = new StatusStateChangeNotification(before, after);
        this.agent.getMessagingAccess().sendStatusMessage((StatusMessage)sm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean waitFor(Predicate<StateBundle> target, long timeout, TimeUnit unit) throws InterruptedException {
        long deadline = TimeUnit.MILLISECONDS.convert(timeout, unit) + System.currentTimeMillis();
        if (!this.stateWaitLock.tryLock(timeout, unit)) {
            return false;
        }
        try {
            this.stateWaitState = this.getState();
            if (target.test(this.stateWaitState)) {
                boolean bl = true;
                return bl;
            }
            Condition condition = this.stateWaitLock.newCondition();
            if (this.stateWaitList == null) {
                this.stateWaitList = new LinkedHashMap(4);
            }
            this.stateWaitList.put(condition, target);
            while (this.stateWaitList != null && this.stateWaitList.containsKey(condition)) {
                timeout = deadline - System.currentTimeMillis();
                if (condition.await(timeout, TimeUnit.MILLISECONDS)) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.stateWaitLock.unlock();
        }
        return true;
    }

    private void stateWaitNotify(StateBundle currentState) {
        if (this.stateWaitList != null) {
            this.agent.getScheduler().schedule(() -> {
                try {
                    this.stateWaitLock.lockInterruptibly();
                    if (this.stateWaitList == null) {
                        return;
                    }
                    this.stateWaitState = currentState;
                    Iterator<Map.Entry<Condition, Predicate<StateBundle>>> it = this.stateWaitList.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry<Condition, Predicate<StateBundle>> entry = it.next();
                        Predicate<StateBundle> target = entry.getValue();
                        if (!target.test(this.stateWaitState)) continue;
                        entry.getKey().signal();
                        it.remove();
                    }
                    if (this.stateWaitList.isEmpty()) {
                        this.stateWaitList = null;
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    this.stateWaitLock.unlock();
                }
            }, 0L, TimeUnit.NANOSECONDS);
        }
    }

    private void notifyStateChange(StateBundle diff, StateBundle oldState) {
        for (Map.Entry<StateChangeListener, List<Class>> e : this.stateChangeListeners.entrySet()) {
            StateChangeListener l = e.getKey();
            List<Class> stateClasses = e.getValue();
            for (Class stateClass : stateClasses) {
                Enum newState = diff.getState(stateClass);
                if (newState != null) {
                    l.stateChanged(this, newState, oldState.getState(stateClass));
                }
                Map changedComponents = diff.getComponentsWithState(stateClass);
                for (Map.Entry componetsEntry : changedComponents.entrySet()) {
                    String componentName = (String)componetsEntry.getKey();
                    Object changedComponent = this.agent.getComponentLookup().getComponentByPath(componentName);
                    if (changedComponent == null) {
                        changedComponent = componentName;
                    }
                    l.stateChanged(changedComponent, (Enum)componetsEntry.getValue(), oldState.getComponentState(componentName, stateClass));
                }
            }
        }
    }

    public void addStateChangeListener(StateChangeListener stateChangeListener, Class ... states) {
        this.stateChangeListeners.put(stateChangeListener, Arrays.asList(states));
    }

    public void removeStateChangeListener(StateChangeListener stateChangeListener) {
        this.stateChangeListeners.remove(stateChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StateBundle getState() {
        Object object = this.getStateLock();
        synchronized (object) {
            return this.innerState.clone();
        }
    }

    public class AgentStateServiceCommands {
        private final AgentStateService stateService;

        AgentStateServiceCommands(AgentStateService stateService) {
            this.stateService = stateService;
        }

        @Command(category=Command.CommandCategory.SYSTEM, type=Command.CommandType.QUERY)
        public StateBundle getState() {
            return this.stateService.getState();
        }
    }
}

