/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.demo.gui;

import java.awt.Component;
import java.awt.Point;
import java.time.Duration;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.freehep.swing.popup.HasPopupItems;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.command.BasicCommand;
import org.lsst.ccs.command.RawCommand;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystem.demo.gui.DemoSubsystemWithMonitoringAssembly;
import org.lsst.ccs.subsystem.monitor.data.MonitorFullState;
import org.lsst.ccs.subsystem.monitor.ui.CommandSender;
import org.lsst.ccs.subsystem.monitor.ui.MonitorAssembly;

public class DemoSubsystemWithMonitoringGUI
implements CommandSender,
StatusMessageListener,
AgentPresenceListener,
HasPopupItems {
    private final String subsys = "demo-subsystem-with-monitoring";
    private final DemoSubsystemWithMonitoringAssembly assembly;
    private final MonitorAssembly mon;
    private volatile boolean enabled = false;
    private ConcurrentMessagingUtils messagingUtils;
    private final AgentMessagingLayer layer;

    public DemoSubsystemWithMonitoringGUI(AgentMessagingLayer layer) {
        this.layer = layer;
        try {
            this.assembly = new DemoSubsystemWithMonitoringAssembly("demo-subsystem-with-monitoring", this);
            this.mon = this.assembly.getMonitor();
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    }

    public void initGui() {
        this.mon.setSubsystems(new String[]{"demo-subsystem-with-monitoring"});
        this.messagingUtils = new ConcurrentMessagingUtils(this.layer);
        this.layer.getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)this);
    }

    public JComponent getGuiLayout() {
        return this.assembly;
    }

    public void resetGui() {
    }

    public static void main(String[] args) throws Exception {
        Agent guiAgent = new Agent("aSomething", AgentInfo.AgentType.LISTENER);
        guiAgent.startAgent();
        DemoSubsystemWithMonitoringGUI t = new DemoSubsystemWithMonitoringGUI(guiAgent.getMessagingAccess());
        JFrame frame = new JFrame("Main Gui");
        frame.setContentPane(t.getGuiLayout());
        frame.pack();
        frame.setVisible(true);
        t.initGui();
        frame.setDefaultCloseOperation(3);
    }

    public void onStatusMessage(StatusMessage s) {
        StatusSubsystemData ssd = (StatusSubsystemData)s;
        this.mon.handleData("demo-subsystem-with-monitoring", ssd.getDataKey(), (Object)ssd.getSubsystemData());
    }

    public void connecting(AgentInfo agent) {
        if (agent.getName().equals("demo-subsystem-with-monitoring")) {
            this.enable();
        }
    }

    public void disconnecting(AgentInfo agent) {
        if (agent.getName().equals("demo-subsystem-with-monitoring")) {
            this.disable();
        }
    }

    public String sendCommand(String dest, String target, String cmnd, Object ... args) {
        this.sendCmnd(dest, target, cmnd, args);
        return "";
    }

    private void enable() {
        if (this.enabled) {
            return;
        }
        this.enabled = true;
        Object reply = this.sendCmnd(null, null, "getMonitorFullState", new Object[0]);
        if (reply instanceof MonitorFullState) {
            this.mon.updateTableModel("demo-subsystem-with-monitoring", (MonitorFullState)reply);
        } else {
            this.enabled = false;
        }
        this.layer.addStatusMessageListener((StatusMessageListener)this, BusMessageFilterFactory.messageOrigin((String)"demo-subsystem-with-monitoring").and(BusMessageFilterFactory.messageClass(StatusSubsystemData.class)));
    }

    private void disable() {
        if (!this.enabled) {
            return;
        }
        this.enabled = false;
        this.mon.disableSystem("demo-subsystem-with-monitoring");
        this.layer.removeStatusMessageListener((StatusMessageListener)this);
    }

    private Object sendCmnd(String dest, String target, String cmnd, Object ... args) {
        String dst = (dest == null ? "demo-subsystem-with-monitoring" : dest) + (target == null ? "" : "/" + target);
        RawCommand cmd = new RawCommand(cmnd, Arrays.asList(args));
        CommandRequest r = new CommandRequest(dst, (BasicCommand)cmd);
        try {
            return this.messagingUtils.sendSynchronousCommand(r, Duration.ofMillis(5000L));
        }
        catch (Exception e) {
            return null;
        }
    }

    public JPopupMenu modifyPopupMenu(JPopupMenu jpm, Component cmpnt, Point point) {
        System.out.println("popup");
        jpm.add(new JMenuItem("popup"));
        return jpm;
    }
}

