/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.configdb.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.MapKey;
import org.hibernate.annotations.Immutable;
import org.lsst.ccs.localdb.configdb.model.ConfigurationParameter;
import org.lsst.ccs.localdb.configdb.model.ParameterPath;
import org.lsst.ccs.localdb.statusdb.model.AgentDesc;

@Entity
@Immutable
public class Description
implements Serializable {
    private static final long serialVersionUID = 1931407188397328132L;
    private long id;
    private Map<ParameterPath, ConfigurationParameter> parameterDescriptions = new HashMap<ParameterPath, ConfigurationParameter>();
    private AgentDesc agentDesc;

    protected Description() {
    }

    public Description(AgentDesc agentDesc) {
        this.agentDesc = agentDesc;
    }

    @Id
    @GeneratedValue
    public long getId() {
        return this.id;
    }

    void setId(long id) {
        this.id = id;
    }

    @ManyToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @MapKey(name="parameterPath")
    public Map<ParameterPath, ConfigurationParameter> getConfigurationParameters() {
        return this.parameterDescriptions;
    }

    void setConfigurationParameters(Map<ParameterPath, ConfigurationParameter> paramDescriptions) {
        this.parameterDescriptions = paramDescriptions;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="agentName")
    public AgentDesc getAgentDesc() {
        return this.agentDesc;
    }

    public void setAgentDesc(AgentDesc agentDesc) {
        this.agentDesc = agentDesc;
    }

    public String toString() {
        return "{id=" + this.getId() + ";descriptions=" + this.getConfigurationParameters() + '}';
    }

    public ConfigurationParameter fetch(String pathString) {
        return this.parameterDescriptions.get(ParameterPath.valueOf(pathString));
    }
}

