/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.services;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.lsst.ccs.Agent;
import org.lsst.ccs.ServiceLifecycle;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.alerts.InfrastructureAlert;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.bus.states.ConfigurationState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.description.ComponentNode;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentMonitor;
import org.lsst.ccs.services.AgentService;
import org.lsst.ccs.services.PeriodicTaskComponent;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.scheduler.PeriodicTask;
import org.lsst.ccs.utilities.scheduler.Scheduler;

public final class AgentPeriodicTaskService
implements ServiceLifecycle,
HasLifecycle,
AgentMonitor,
ClearAlertHandler,
AgentService {
    private static final Logger log = Logger.getLogger((String)"org.lsst.ccs.services");
    private Scheduler scheduler;
    private final ConcurrentHashMap<String, PeriodicTaskComponent> tasksMap = new ConcurrentHashMap();
    private final Object taskLock = new Object();
    private boolean hasBeenInitialized = false;
    private ComponentLookup lookupService;
    private ComponentNode agentPeriodicTaskNode;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent agent;
    private final List<String> tasksBehind = new ArrayList<String>();
    private final List<String> tasksWithFaiuresWarning = new ArrayList<String>();
    private final List<String> tasksWithFaiuresAlarm = new ArrayList<String>();

    @Override
    public String getAgentServiceName() {
        return "periodicTasks";
    }

    @Override
    public void preBuild() {
        this.scheduler = new Scheduler("AgentPeriodicTaskService scheduler for " + this.agent.getName(), 8);
        this.scheduler.setLogger(this.agent.getLogger());
        this.lookupService = this.agent.getComponentLookup();
        this.agentPeriodicTaskNode = this.lookupService.getComponentNodeForObject((Object)this);
    }

    @Override
    public void preInit() {
        this.hasBeenInitialized = true;
    }

    @Override
    public void postShutdown() {
        this.scheduler.shutdown();
        try {
            this.scheduler.awaitTermination(500L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            log.severe((Object)"could not await scheduler termination", (Throwable)ex);
            this.scheduler.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleAgentPeriodicTask(AgentPeriodicTask task) {
        if (this.hasBeenInitialized) {
            throw new RuntimeException("Too late to schedule an AgentPeriodicTask. Tasks must be scheduled in the build phase of HasLifecycle.");
        }
        Object object = this.taskLock;
        synchronized (object) {
            if (this.tasksMap.containsKey(task.getTaskName())) {
                throw new RuntimeException("Task with name " + task.getTaskName() + " has already been scheduled. Tasks must be unique.");
            }
            PeriodicTaskComponent periodicTaskComponent = new PeriodicTaskComponent(task, this.scheduler);
            this.tasksMap.put(task.getTaskName(), periodicTaskComponent);
            ComponentNode taskNode = new ComponentNode(this.agentPeriodicTaskNode, task.getTaskName(), (Object)periodicTaskComponent);
            this.lookupService.addComponentNodeToLookup(this.agentPeriodicTaskNode, taskNode);
        }
    }

    public Duration getPeriodicTaskPeriod(String taskName) {
        PeriodicTaskComponent periodicTask = this.tasksMap.get(taskName);
        if (periodicTask == null) {
            throw new RuntimeException("PeriodicTask with name \"" + taskName + "\" does not exist.");
        }
        return Duration.ofMillis(periodicTask.getTaskPeriodMillis());
    }

    public void setPeriodicTaskPeriod(String taskName, Duration period) {
        Subsystem s;
        PeriodicTaskComponent periodicTask = this.tasksMap.get(taskName);
        if (periodicTask == null) {
            throw new RuntimeException("PeriodicTask with name \"" + taskName + "\" does not exist.");
        }
        if (this.agent instanceof Subsystem && (s = (Subsystem)this.agent).getConfigurationService() != null && s.getState().getState(ConfigurationState.class) != null && !s.isInState((Enum)ConfigurationState.INITIAL_SAFE)) {
            s.getConfigurationService().change(taskName, "taskPeriodMillis", period.toMillis());
            return;
        }
        periodicTask.setTaskPeriodMillis(period.toMillis());
    }

    @Command(name="getAgentPeriodicTaskNames", description="Get the list of the names of the scheduled tasks", type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM)
    public List<String> getAgentPeriodicTaskNames() {
        return Collections.list(this.tasksMap.keys());
    }

    public List<PeriodicTask> getPeriodicTasks() {
        ArrayList<PeriodicTask> tasks = new ArrayList<PeriodicTask>();
        for (PeriodicTaskComponent taskComponent : this.tasksMap.values()) {
            tasks.add(taskComponent.getTask());
        }
        return tasks;
    }

    private String getSchedulerState() {
        return "Active Threads: " + this.scheduler.getActiveCount() + " Pool Size: " + this.scheduler.getPoolSize() + " Queue Size: " + this.scheduler.getQueueSize();
    }

    @Override
    public String getAgentMonitorStatus(boolean useCcsBuses) {
        return this.getStatus(useCcsBuses);
    }

    @Override
    public String getAgentMonitorDescription() {
        return "Periodic Task Agent Monitor";
    }

    private synchronized String getStatus(boolean publish) {
        boolean isOk = true;
        for (PeriodicTask task : this.getPeriodicTasks()) {
            if (this.isPeriodicTaskOk(task, publish)) continue;
            isOk = false;
        }
        return isOk ? "OK" : this.getStatusDescription();
    }

    private boolean isPeriodicTaskOk(PeriodicTask task, boolean publish) {
        boolean isTaskOk = true;
        if (this.isPeriodicTaskBehind(task, publish)) {
            isTaskOk = false;
        }
        if (this.isPeriodicTaskFailing(task, publish)) {
            isTaskOk = false;
        }
        return isTaskOk;
    }

    private boolean isPeriodicTaskBehind(PeriodicTask task, boolean publish) {
        long delay = task.getDelay(TimeUnit.MILLISECONDS);
        long period = task.getPeriod(TimeUnit.MILLISECONDS);
        String taskName = task.getTaskName();
        if (delay < 0L && Math.abs(delay) > period / 2L) {
            if (publish && !this.tasksBehind.contains(taskName)) {
                this.tasksBehind.add(taskName);
                this.agent.getAlertService().raiseAlert(InfrastructureAlert.PERIODIC_TASK_BEHIND.getAlert(), AlertState.WARNING, "The following tasks are falling behind: " + this.tasksBehind + ". " + this.getSchedulerState());
            }
            return true;
        }
        if (delay > 0L && publish && this.tasksBehind.remove(taskName) && this.tasksBehind.isEmpty()) {
            this.agent.getAlertService().raiseAlert(InfrastructureAlert.PERIODIC_TASK_BEHIND.getAlert(), AlertState.NOMINAL, "All tasks are keeping up. " + this.getSchedulerState());
        }
        return false;
    }

    private boolean isPeriodicTaskFailing(PeriodicTask task, boolean publish) {
        int taskFailures = task.getFailures();
        String taskName = task.getTaskName();
        if (taskFailures > 0) {
            int taskMaxFailures = task.getMaxFailures();
            if (taskFailures > taskMaxFailures / 2 && taskFailures < taskMaxFailures) {
                if (publish && !this.tasksWithFaiuresWarning.contains(taskName)) {
                    this.tasksWithFaiuresWarning.add(taskName);
                    this.agent.getAlertService().raiseAlert(InfrastructureAlert.PERIODIC_TASK_FAILURE.getAlert(), AlertState.WARNING, "Task " + taskName + " has experienced " + taskFailures + " exceptions. The maximum allowed exceptions is " + taskMaxFailures + " (" + this.tasksWithFaiuresWarning + "). " + this.getSchedulerState());
                }
            } else if (taskFailures >= taskMaxFailures) {
                if (publish && !this.tasksWithFaiuresAlarm.contains(taskName)) {
                    this.tasksWithFaiuresAlarm.add(taskName);
                    this.agent.getAlertService().raiseAlert(InfrastructureAlert.PERIODIC_TASK_FAILURE.getAlert(), AlertState.ALARM, "Task " + taskName + " has experenced the maximum allowed number of exceptions: " + taskFailures + " (max:" + taskMaxFailures + "). It will stop executing. (" + this.tasksWithFaiuresAlarm + "). " + this.getSchedulerState());
                }
                return true;
            }
        }
        return false;
    }

    private String getStatusDescription() {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> tasksFallingBehind = new ArrayList<String>();
        ArrayList<String> tasksWithFailure = new ArrayList<String>();
        for (PeriodicTask task : this.getPeriodicTasks()) {
            if (this.isPeriodicTaskBehind(task, false)) {
                tasksFallingBehind.add(task.getTaskName());
            }
            if (!this.isPeriodicTaskFailing(task, false)) continue;
            tasksWithFailure.add(task.getTaskName());
        }
        if (!tasksFallingBehind.isEmpty()) {
            sb.append("Tasks falling behind: ");
            for (String taskName : tasksFallingBehind) {
                sb.append(taskName).append(" ");
            }
            sb.append("\n");
        }
        if (!tasksWithFailure.isEmpty()) {
            sb.append("Tasks with failures: ");
            for (String taskName : tasksWithFailure) {
                sb.append(taskName).append(" ");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert) {
        String alertId = alert.getAlertId();
        if (alertId.equals(InfrastructureAlert.PERIODIC_TASK_FAILURE.getAlertId())) {
            for (PeriodicTask task : this.getPeriodicTasks()) {
                if (!this.isPeriodicTaskFailing(task, false)) continue;
                return ClearAlertHandler.ClearAlertCode.DONT_CLEAR_ALERT;
            }
            return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
        }
        if (alertId.equals(InfrastructureAlert.PERIODIC_TASK_BEHIND.getAlertId())) {
            for (PeriodicTask task : this.getPeriodicTasks()) {
                if (!this.isPeriodicTaskBehind(task, false)) continue;
                return ClearAlertHandler.ClearAlertCode.DONT_CLEAR_ALERT;
            }
            return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
        }
        return ClearAlertHandler.ClearAlertCode.UNKWNOWN_ALERT;
    }
}

