/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.monitor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.lsst.ccs.bus.states.DataProviderState;
import org.lsst.ccs.gconsole.agent.AgentChannel;
import org.lsst.ccs.gconsole.agent.AgentChannelsFilter;
import org.lsst.ccs.gconsole.agent.AgentStatusEvent;
import org.lsst.ccs.gconsole.agent.MutableAgentChannel;
import org.lsst.ccs.gconsole.plugins.monitor.ChannelHandle;
import org.lsst.ccs.gconsole.plugins.monitor.FormattedValue;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorCell;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorFormat;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorTableCellRenderer;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorView;

public class CellTableView
extends JTable
implements MonitorView,
AgentChannelsFilter {
    private final int nRows;
    private final int nColumns;
    private final ArrayList<MonitorCell> cells;
    private final Dimension maxSize = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    private int[] minRowHeights;
    private int[] minColumnWidths;
    private int minRowHeight;
    private int minColumnWidth;
    private int height;
    private boolean resizeAndRepaintEnabled = true;
    private ChangeListener resizeListener;
    private MonitorFormat formatter = MonitorFormat.DEFAULT;

    public CellTableView(int rows, int columns, MonitorCell ... content) {
        if (rows * columns != content.length) {
            throw new IllegalArgumentException("Incorrect number of cell descriptors");
        }
        this.nRows = rows;
        this.nColumns = columns;
        this.cells = new ArrayList(rows * columns);
        this.cells.addAll(Arrays.asList(content));
        this.init();
    }

    public void setResizeListener(ChangeListener listener) {
        this.resizeListener = listener;
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public JComponent getPanel() {
        return this;
    }

    @Override
    public AgentChannelsFilter getFilter() {
        return this;
    }

    @Override
    public void setFilter(AgentChannelsFilter filter) {
    }

    @Override
    public MonitorView.Descriptor save() {
        return MonitorView.super.save();
    }

    @Override
    public void restore(MonitorView.Descriptor descriptor) {
        MonitorView.super.restore(descriptor);
    }

    @Override
    public void connect(AgentStatusEvent event) {
        SwingUtilities.invokeLater(() -> this.update(event));
    }

    @Override
    public void configure(AgentStatusEvent event) {
        SwingUtilities.invokeLater(() -> this.update(event));
    }

    @Override
    public void disconnect(AgentStatusEvent event) {
        SwingUtilities.invokeLater(() -> this.update(event));
    }

    @Override
    public void statusChanged(AgentStatusEvent event) {
        SwingUtilities.invokeLater(() -> this.update(event));
    }

    private void update(AgentStatusEvent event) {
        String path;
        for (AgentChannel channel : event.getAddedChannels()) {
            path = channel.getPath();
            block1: for (MonitorCell cell : this.cells) {
                for (ChannelHandle handle : cell.getChannels()) {
                    if (!path.equals(handle.getPath())) continue;
                    handle.setChannel(channel);
                    this.formatter.format(cell);
                    continue block1;
                }
            }
        }
        for (AgentChannel channel : event.getRemovedChannels()) {
            path = channel.getPath();
            block4: for (MonitorCell cell : this.cells) {
                for (ChannelHandle handle : cell.getChannels()) {
                    if (!path.equals(handle.getPath())) continue;
                    AgentChannel ch = handle.getChannel();
                    if (ch == null) continue block4;
                    if (channel instanceof MutableAgentChannel) {
                        ((MutableAgentChannel)channel).set("state", DataProviderState.OFF_LINE);
                        handle.update(null);
                    } else {
                        handle.setChannel(null);
                    }
                    this.formatter.format(cell);
                    continue block4;
                }
            }
        }
        for (AgentChannel channel : event.getStatusChanges().keySet()) {
            path = channel.getPath();
            block7: for (MonitorCell cell : this.cells) {
                for (ChannelHandle handle : cell.getChannels()) {
                    if (!path.equals(handle.getPath())) continue;
                    handle.setChannel(channel);
                    this.formatter.format(cell);
                    continue block7;
                }
            }
        }
        ((Model)this.getModel()).fireTableDataChanged();
    }

    @Override
    public List<String> getOriginChannels() {
        return this.cells.stream().flatMap(cell -> cell.getChannels().stream()).map(handle -> handle.getPath()).collect(Collectors.toList());
    }

    @Override
    public List<String> getDisplayChannels() {
        return this.getOriginChannels();
    }

    @Override
    public String getOriginPath(String displayPath) {
        return displayPath;
    }

    @Override
    public List<String> getDisplayPath(String originPath) {
        return Collections.singletonList(originPath);
    }

    @Override
    public List<String> getFields(boolean compact) {
        return Collections.singletonList("value");
    }

    private void init() {
        this.setOpaque(true);
        this.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.setShowGrid(true);
        this.setRowSelectionAllowed(false);
        this.setColumnSelectionAllowed(false);
        this.setFillsViewportHeight(true);
        Renderer renderer = new Renderer();
        this.setDefaultRenderer(Object.class, renderer);
        this.setModel(new Model());
        this.minRowHeight = this.getRowHeight();
        this.minColumnWidth = 0;
        Enumeration<TableColumn> en = this.getColumnModel().getColumns();
        while (en.hasMoreElements()) {
            TableColumn tc = en.nextElement();
            this.minColumnWidth = Math.max(this.minColumnWidth, tc.getMinWidth());
            tc.setPreferredWidth(this.minColumnWidth);
        }
    }

    public void setFormat(MonitorFormat format) {
        this.formatter = format;
    }

    public void setEqualRows(boolean value) {
        if (value && this.minRowHeights != null) {
            this.minRowHeight = 0;
            for (int h : this.minRowHeights) {
                this.minRowHeight = Math.max(this.minRowHeight, h);
            }
            this.minRowHeights = null;
        } else if (!value && this.minRowHeights == null) {
            this.minRowHeights = new int[this.nRows];
            Arrays.fill(this.minRowHeights, this.minRowHeight);
            this.minRowHeight *= this.nRows;
        }
    }

    public void setEqualColumns(boolean value) {
        if (value && this.minColumnWidths != null) {
            this.minColumnWidth = 0;
            for (int h : this.minColumnWidths) {
                this.minColumnWidth = Math.max(this.minColumnWidth, h);
            }
            this.minColumnWidths = null;
        } else if (!value && this.minColumnWidths == null) {
            this.minColumnWidths = new int[this.nColumns];
            Arrays.fill(this.minColumnWidths, this.minColumnWidth);
            this.minColumnWidth = 0;
        }
    }

    public boolean isEqualRows() {
        return this.minRowHeights == null;
    }

    public boolean isEqualColumns() {
        return this.minColumnWidths == null;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        if (this.isEqualRows()) {
            d.height = this.minRowHeight * this.nRows;
        } else {
            d.height = 0;
            for (int i = 0; i < this.nRows; ++i) {
                d.height += this.minRowHeights[i];
            }
        }
        return d;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.maxSize;
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        if (height != this.height) {
            this.resizeAndRepaintEnabled = false;
            if (this.isEqualRows()) {
                int totalHeight = this.minRowHeight * this.nRows;
                if (totalHeight < height) {
                    int h = height / this.nRows;
                    height = h * this.nRows;
                    this.setRowHeight(h);
                } else {
                    super.setRowHeight(this.minRowHeight);
                }
            } else {
                int excessHeight = height - this.minRowHeight;
                if (excessHeight > 0) {
                    int h = excessHeight / this.nRows;
                    int extra = excessHeight % this.nRows;
                    for (int row = 0; row < this.nRows; ++row) {
                        super.setRowHeight(row, row < extra ? this.minRowHeights[row] + h + 1 : this.minRowHeights[row] + h);
                    }
                } else {
                    for (int row = 0; row < this.nRows; ++row) {
                        super.setRowHeight(row, this.minRowHeights[row]);
                    }
                }
            }
            this.height = height;
            this.resizeAndRepaintEnabled = true;
        }
        super.setBounds(x, y, width, height);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        super.addPropertyChangeListener(listener);
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        super.addPropertyChangeListener(propertyName, listener);
    }

    @Override
    protected void resizeAndRepaint() {
        if (this.resizeAndRepaintEnabled) {
            if (this.resizeListener != null) {
                this.resizeListener.stateChanged(null);
            }
            super.resizeAndRepaint();
        }
    }

    public void test(int rowIndex, int columnIndex, String text) {
        FormattedValue fv = new FormattedValue(text, 0);
        this.cells.get(rowIndex * this.nColumns + columnIndex).setFormattedValue(fv);
        ((Model)this.getModel()).fireTableRowsUpdated(0, this.nRows - 1);
    }

    private class Renderer
    extends MonitorTableCellRenderer {
        private Renderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            boolean resized = false;
            int w = this.getMinimumSize().width + 2;
            TableColumnModel tcm = table.getColumnModel();
            TableColumn c = tcm.getColumn(column);
            if (w > c.getMinWidth()) {
                CellTableView.this.resizeAndRepaintEnabled = false;
                if (CellTableView.this.isEqualColumns()) {
                    for (int i = 0; i < CellTableView.this.nColumns; ++i) {
                        tcm.getColumn(i).setMinWidth(w);
                    }
                } else {
                    c.setMinWidth(w);
                }
                CellTableView.this.resizeAndRepaintEnabled = true;
                resized = true;
            }
            int h = this.getMinimumSize().height;
            if (CellTableView.this.isEqualRows()) {
                if (h > CellTableView.this.minRowHeight) {
                    CellTableView.this.minRowHeight = h;
                    resized = true;
                }
            } else if (h > CellTableView.this.minRowHeights[row]) {
                CellTableView.this.minRowHeight = CellTableView.this.minRowHeight - CellTableView.this.minRowHeights[row] + h;
                ((CellTableView)CellTableView.this).minRowHeights[row] = h;
                resized = true;
            }
            if (resized) {
                CellTableView.this.resizeAndRepaint();
            }
            return this;
        }
    }

    private class Model
    extends AbstractTableModel {
        private Model() {
        }

        @Override
        public int getRowCount() {
            return CellTableView.this.nRows;
        }

        @Override
        public int getColumnCount() {
            return CellTableView.this.nColumns;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return ((MonitorCell)CellTableView.this.cells.get(rowIndex * CellTableView.this.nColumns + columnIndex)).getFormattedValue();
        }
    }
}

