/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.demo.gui.plugins.trending;

import java.time.Instant;
import java.time.ZoneId;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import org.lsst.ccs.gconsole.plugins.trending.Trend;
import org.lsst.ccs.gconsole.plugins.trending.TrendData;
import org.lsst.ccs.gconsole.plugins.trending.TrendingChannel;
import org.lsst.ccs.gconsole.plugins.trending.TrendingSource;

public class DemoSource
extends TrendingSource {
    private final TrendingChannel channel1 = new TrendingChannel("Extra/Minutes/OfDay", "Minute of a day");
    private final TrendingChannel channel2 = new TrendingChannel("Extra/Minutes/OfHour", "Minute of an hour");
    private final TrendingChannel channel3 = new TrendingChannel("Extra/ScaleTest", "Scale Test");
    private final TrendingChannel channelDelay5 = new TrendingChannel("Delayed/5 seconds", "5 seconds delay");
    private final TrendingChannel channelDelay8 = new TrendingChannel("Delayed/8 seconds", "8 seconds delay");
    private final TrendingChannel channelMeta = new TrendingChannel("WithMetadata/sin");
    private final TrendingChannel channelMetaDelay = new TrendingChannel("WithMetadata/sinDelay5sec");

    public List<TrendingChannel> getChannels() {
        ArrayList<TrendingChannel> out = new ArrayList<TrendingChannel>();
        Collections.addAll(out, this.channel1, this.channel2, this.channel3, this.channelDelay5, this.channelDelay8, this.channelMeta, this.channelMetaDelay);
        return out;
    }

    public TrendData get(TrendingChannel channel, long begin, long end, EnumSet<Trend.Meta> metadata, TrendData history) {
        if (end <= begin) {
            return null;
        }
        if (this.channel1.equals((Object)channel) || this.channel2.equals((Object)channel)) {
            return this.get12test(channel, begin, end);
        }
        if (this.channelDelay5.equals((Object)channel)) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return this.get12(this.channel1, begin, end);
        }
        if (this.channelDelay8.equals((Object)channel)) {
            try {
                Thread.sleep(8000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return this.get12(this.channel2, begin, end);
        }
        if (this.channelMeta.equals((Object)channel) || this.channelMetaDelay.equals((Object)channel)) {
            return this.getMeta(begin, end, this.channelMeta.equals((Object)channel) ? 0L : 5000L);
        }
        return this.get3(begin, end);
    }

    private TrendData get12(TrendingChannel channel, long begin, long end) {
        long[] time = new long[10];
        double[] value = new double[10];
        long delta = (end - begin) / 10L;
        ChronoField field = channel.equals((Object)this.channel1) ? ChronoField.MINUTE_OF_DAY : ChronoField.MINUTE_OF_HOUR;
        for (int i = 0; i < 10; ++i) {
            long t;
            time[i] = t = begin + (long)i * delta;
            value[i] = Instant.ofEpochMilli(t).atZone(ZoneId.systemDefault()).get(field);
        }
        HashMap<String, long[]> times = new HashMap<String, long[]>();
        times.put("value", time);
        HashMap<String, double[]> values = new HashMap<String, double[]>();
        values.put("value", value);
        return new TrendData(times, values, new long[]{begin, end});
    }

    private TrendData get12test(TrendingChannel channel, long begin, long end) {
        ArrayList<Long> t = new ArrayList<Long>();
        ArrayList<Double> v = new ArrayList<Double>();
        long now = System.currentTimeMillis();
        for (long x = begin; x < now; x += ChronoUnit.MINUTES.getDuration().toMillis()) {
            t.add(x);
            v.add(Math.sin((double)x / 10.0));
        }
        long[] time = new long[t.size()];
        double[] value = new double[t.size()];
        for (int i = 0; i < t.size(); ++i) {
            time[i] = (Long)t.get(i);
            value[i] = (Double)v.get(i);
        }
        HashMap<String, long[]> times = new HashMap<String, long[]>();
        times.put("value", time);
        HashMap<String, double[]> values = new HashMap<String, double[]>();
        values.put("value", value);
        return new TrendData(times, values, new long[]{begin, end});
    }

    private TrendData get3(long begin, long end) {
        int n;
        long t0;
        long range = end - begin;
        if (range < 600000L) {
            t0 = begin;
            n = (int)(range / 10L);
        } else {
            t0 = begin + range / 3L;
            n = 18000;
        }
        long[] time = new long[n];
        double[] value = new double[n];
        for (int i = 0; i < n; ++i) {
            long t;
            time[i] = t = t0 + (long)i * 10L;
            value[i] = 10.0 * Math.sin((double)(t - t0) / 60000.0) + Math.sin((double)(t - t0) / 1000.0);
        }
        HashMap<String, long[]> times = new HashMap<String, long[]>();
        times.put("value", time);
        HashMap<String, double[]> values = new HashMap<String, double[]>();
        values.put("value", value);
        return new TrendData(times, values, new long[]{begin, end});
    }

    private TrendData getMeta(long begin, long end, long delay) {
        if (delay > 0L) {
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        int n = 100;
        long period = 60000L;
        long range = end - begin;
        long delta = range / (long)n;
        long[] time = new long[n];
        double[] value = new double[n];
        double[] min = new double[n];
        double[] max = new double[n];
        double[] rms = new double[n];
        for (int i = 0; i < n; ++i) {
            long t;
            time[i] = t = begin + (long)i * delta;
            value[i] = Math.sin((double)(t * 2L) * Math.PI / (double)period) + 2.0;
            min[i] = value[i] - 1.0;
            max[i] = value[i] + 1.0;
            rms[i] = value[i] * 0.2;
        }
        HashMap<String, long[]> times = new HashMap<String, long[]>();
        times.put("value", time);
        HashMap<String, double[]> values = new HashMap<String, double[]>();
        values.put("value", value);
        values.put("min", min);
        values.put("max", max);
        values.put("rms", rms);
        long[] timeMetaOff = new long[]{begin, begin + range / 2L, begin + range / 2L, end};
        double[] low = new double[]{1.0, 1.0, 0.5, 0.5};
        double[] high = new double[]{3.0, 3.0, 3.5, 3.5};
        times.put("warningLow", timeMetaOff);
        values.put("warningLow", low);
        times.put("warningHigh", timeMetaOff);
        values.put("warningHigh", high);
        timeMetaOff = new long[]{begin, end};
        low = new double[]{0.0, 0.0};
        high = new double[]{4.0, 4.0};
        times.put("alarmLow", timeMetaOff);
        values.put("alarmLow", low);
        times.put("alarmHigh", timeMetaOff);
        values.put("alarmHigh", high);
        return new TrendData(times, values, new long[]{begin, end});
    }
}

