/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.taitime;

import java.io.IOException;
import java.io.Serializable;
import java.time.Instant;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.utilities.taitime.LeapSecondReader;
import org.lsst.ccs.utilities.taitime.TAITime;
import org.lsst.ccs.utilities.taitime.TimeStorage;

public class CCSTimeStamp
implements Serializable {
    private static volatile boolean initializationNeeded = true;
    private static TAITime times;
    private static LeapSecondReader reader;
    private final Instant taiInstant;
    private final Instant utcInstant;

    public static CCSTimeStamp currentTime() {
        return new CCSTimeStamp();
    }

    public static CCSTimeStamp currentTimeFromMillis(long milliseconds) {
        return new CCSTimeStamp(milliseconds);
    }

    private CCSTimeStamp(long milliseconds) {
        if (Boolean.getBoolean("org.lsst.ccs.utilities.taitime.useStrict")) {
            throw new RuntimeException("Cannot use in strict mode !");
        }
        this.utcInstant = Instant.ofEpochMilli(milliseconds);
        LeapSecondReader leapReader = null;
        try {
            leapReader = new LeapSecondReader();
        }
        catch (IOException ex) {
            Logger.getLogger(CCSTimeStamp.class.getName()).log(Level.SEVERE, null, ex);
        }
        int leapSecond = leapReader.getNumberOfLeapSeconds(this.utcInstant.toEpochMilli());
        this.taiInstant = this.utcInstant.plusSeconds(leapSecond);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CCSTimeStamp() {
        Class<CCSTimeStamp> clazz = CCSTimeStamp.class;
        synchronized (CCSTimeStamp.class) {
            if (initializationNeeded) {
                times = new TAITime();
                if (!times.isConfigured()) {
                    try {
                        reader = new LeapSecondReader();
                    }
                    catch (IOException x) {
                        throw new RuntimeException("Leap second file can not be loaded", x);
                    }
                }
                initializationNeeded = false;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (times.isConfigured()) {
                TimeStorage store = times.getTime();
                this.taiInstant = Instant.ofEpochSecond(store.getTimeSecsTAI(), store.getTimeNanoTAI());
                this.utcInstant = Instant.ofEpochSecond(store.getTimeSecsUTC(), store.getTimeNanoUTC());
            } else {
                this.utcInstant = Instant.now();
                int leapSecond = reader.getNumberOfLeapSeconds(this.utcInstant.toEpochMilli());
                this.taiInstant = this.utcInstant.plusSeconds(leapSecond);
            }
            return;
        }
    }

    public Instant getTAIInstant() {
        return this.taiInstant;
    }

    public Instant getUTCInstant() {
        return this.utcInstant;
    }

    public double getTAIDouble() {
        return (double)this.taiInstant.getEpochSecond() + (double)this.taiInstant.getNano() / 1.0E9;
    }

    public double getUTCDouble() {
        return (double)this.utcInstant.getEpochSecond() + (double)this.utcInstant.getNano() / 1.0E9;
    }
}

