/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.demo.gui.plugins;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.ConsolePlugin;

@Plugin(name="LSST CCS Plugin Properties Demo", id="propdemo", description="LSST CCS Plugin that demonstrates adding menu items and using plugin properties and preferences.")
public class PreferencesMenusPlugin
extends ConsolePlugin {
    public void initialize() {
        this.getServices().addProperty("oldEnough", (Object)true);
        this.getServices().addPreference(new String[]{"LSST", "Demo", "Pref"}, null, "${oldEnough} I am at least 21 years old.");
        this.getServices().addProperty("rangeMin", (Object)13.5);
        this.getServices().addProperty("rangeMax", (Object)100.0);
        this.getServices().addProperty("currency", (Object)Currency.USD);
        this.getServices().addPreference(new String[]{"LSST", "Demo", "Pref"}, "Price range", "Min: ${rangeMin}  Max: ${rangeMax}");
        this.getServices().addProperty("quantity", (Object)3);
        this.getServices().addPreference(new String[]{"LSST", "Demo", "Pref"}, null, "Quantity: ${quantity}");
        this.getServices().addProperty("name", (Object)"Jessica");
        this.getServices().addProperty("ms", (Object)78);
        this.getServices().addProperty("home", (Object)"SLAC National Accelerator Laboratory");
        this.getServices().addPreference(new String[]{"LSST", "Demo", "Pref"}, "Addressee", "Name: ${name}  M/S: ${ms}");
        this.getServices().addPreference(new String[]{"LSST", "Demo", "Pref"}, "Addressee", "Home institution: ${home}");
        this.getServices().addPreference(new String[]{"LSST", "Demo", "Pref"}, "Price range", "Currency: ${currency}");
        AbstractAction act = new AbstractAction("Currency"){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("\nCurrency: " + PreferencesMenusPlugin.this.getServices().getProperty("currency"));
            }
        };
        this.getServices().addMenu((Action)act, new String[]{"Demo", "Preferences:1:2"});
        act = new AbstractAction("Range"){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("\nMin: " + PreferencesMenusPlugin.this.getServices().getProperty("rangeMin") + "  Max: " + PreferencesMenusPlugin.this.getServices().getProperty("rangeMax"));
            }
        };
        this.getServices().addMenu((Action)act, new String[]{"Demo", "Preferences:1:1"});
        act = new AbstractAction("Quantity"){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("\nQuantity: " + PreferencesMenusPlugin.this.getServices().getProperty("quantity"));
            }
        };
        this.getServices().addMenu((Action)act, new String[]{"Demo", "Preferences:1"});
        act = new AbstractAction("Legal Age"){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("\nOld enough: " + PreferencesMenusPlugin.this.getServices().getProperty("oldEnough"));
            }
        };
        this.getServices().addMenu((Action)act, new String[]{"Demo", "Preferences"});
        act = new AbstractAction("Name"){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("\nName: " + PreferencesMenusPlugin.this.getServices().getProperty("name"));
            }
        };
        this.getServices().addMenu((Action)act, new String[]{"Demo", "Preferences:2:2", "Addressee"});
        act = new AbstractAction("Address"){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("\nAddress: M/S " + PreferencesMenusPlugin.this.getServices().getProperty("ms") + " at " + PreferencesMenusPlugin.this.getServices().getProperty("home"));
            }
        };
        this.getServices().addMenu((Action)act, new String[]{"Demo", "Preferences:2:1", "Addressee"});
        act = new AbstractAction("Reset preferences"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferencesMenusPlugin.this.getServices().setProperty("oldEnough", null);
                PreferencesMenusPlugin.this.getServices().setProperty("rangeMin", null);
                PreferencesMenusPlugin.this.getServices().setProperty("rangeMax", null);
                PreferencesMenusPlugin.this.getServices().setProperty("currency", null);
                PreferencesMenusPlugin.this.getServices().setProperty("quantity", null);
                PreferencesMenusPlugin.this.getServices().setProperty("name", null);
                PreferencesMenusPlugin.this.getServices().setProperty("ms", null);
                PreferencesMenusPlugin.this.getServices().setProperty("home", null);
            }
        };
        this.getServices().addMenu((Action)act, new String[]{"Demo"});
        act = new AbstractAction("CCS Subsystems-Demo-obsolete"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Toolkit.getDefaultToolkit().beep();
            }
        };
        this.getServices().addMenu((Action)act, new String[]{"CCS Subsystems", "Demo", "obsolete"});
        act = new AbstractAction("CCS Subsystems-Demo-obsolete:2:1"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Toolkit.getDefaultToolkit().beep();
            }
        };
        this.getServices().addMenu((Action)act, new String[]{"CCS Subsystems", "Demo:1", "obsolete:2"});
        act = new AbstractAction("CCS Subsystems-Demo-new"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Toolkit.getDefaultToolkit().beep();
            }
        };
        this.getServices().addMenu((Action)act, new String[]{"CCS Subsystems", "Demo:2", "new"});
    }

    public void propertiesChanged(Object source, Map<String, Object> changes) {
        System.out.println("\nProperties changed:");
        changes.forEach((key, value) -> System.out.println(key + " = " + value));
    }

    public static enum Currency {
        USD("US Dollar"),
        EUR("Euro"),
        RUB("Rouble"),
        CLP("Peso");

        private final String hr;

        private Currency(String humanReadableName) {
            this.hr = humanReadableName;
        }

        public String toString() {
            return this.hr;
        }
    }
}

